/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpression;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpressionValue;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.AssignVarRequest;
import com.jetbrains.php.debug.zend.messages.AssignVarResponse;
import com.jetbrains.php.debug.zend.messages.GetVarRequest;
import com.jetbrains.php.debug.zend.messages.GetVarResponse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import gnu.trove.THashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerValue
extends PhpNavigatableValue {
    protected final PhpDebugProcess<ZendDebuggerConnection> myDebugProcess;
    protected final ZendDebuggerExpression myExpression;

    public ZendDebuggerValue(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, @NotNull ZendDebuggerExpression expression) {
        if (debugProcess == null) {
            ZendDebuggerValue.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            ZendDebuggerValue.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myExpression = expression;
    }

    public String getEvaluationExpression() {
        return this.myExpression.getExpression();
    }

    public XValueModifier getModifier() {
        return new XValueModifier(){

            public void setValue(@NotNull XExpression expression, final @NotNull XValueModifier.XModificationCallback callback) {
                ZendDebuggerConnection connection;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((connection = ZendDebuggerValue.this.myDebugProcess.getConnection()) == null) {
                    callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
                    return;
                }
                connection.send(new AssignVarRequest(ZendDebuggerValue.this.myExpression.getPath(), expression.getExpression()), new ZendDebuggerResponseHandler<AssignVarResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull AssignVarResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        callback.valueModified();
                    }

                    @Override
                    public void onErrorResponse(@NotNull AssignVarResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        callback.errorOccurred(PhpBundle.message("debug.error.cannot.modify.value", new Object[0]));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "message";
                        objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerValue$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public String getInitialValueEditorText() {
                ZendDebuggerExpressionValue value = ZendDebuggerValue.this.myExpression.getValue();
                String valueAsString = value.getValueAsString();
                if (value.isString()) {
                    return (String)StringUtil.QUOTER.fun((Object)valueAsString);
                }
                return valueAsString;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerValue$1";
                objectArray[2] = "setValue";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            ZendDebuggerValue.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ZendDebuggerValue.$$$reportNull$$$0(3);
        }
        ZendDebuggerExpressionValue expressionValue = this.myExpression.getValue();
        Icon icon = ZendDebuggerExpressionValue.getIcon(expressionValue);
        String valuePresentation = expressionValue.getValueAsString();
        if (valuePresentation.length() > 1000) {
            node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(valuePresentation));
        }
        String type = null;
        if (!expressionValue.isPrimitive()) {
            type = expressionValue.getTypeAsString();
        } else if (expressionValue.isNumber()) {
            type = expressionValue.isFloat() ? PhpBundle.message("debug.type.float", new Object[0]) : PhpBundle.message("debug.type.int", new Object[0]);
        }
        node.setPresentation(icon, this.createPresentation(valuePresentation, type, expressionValue), expressionValue.getChildrenCount() > 0);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        ZendDebuggerExpressionValue expressionValue;
        if (node == null) {
            ZendDebuggerValue.$$$reportNull$$$0(4);
        }
        if ((expressionValue = this.myExpression.getValue()).isFullyLoaded()) {
            XValueChildrenList children = new XValueChildrenList();
            for (ZendDebuggerExpression childExpression : this.myExpression.getValue().getChildren()) {
                children.add(childExpression.getLastName(), (XValue)new ZendDebuggerValue(this.myDebugProcess, childExpression));
            }
            node.addChildren(children, true);
        } else {
            node.addChildren(XValueChildrenList.EMPTY, false);
            ZendDebuggerConnection connection = this.myDebugProcess.getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            connection.send(new GetVarRequest(this.myExpression.getPath()), new ZendDebuggerResponseHandler<GetVarResponse>(){

                @Override
                public void onSuccessResponse(@NotNull GetVarResponse message) {
                    if (message == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String variableContent = message.getVariableContent();
                    Project project = ZendDebuggerValue.this.myDebugProcess.getSession().getProject();
                    ZendDebuggerValue.this.myExpression.setValue(ZendDebuggerExpressionValue.deserialize(project, ZendDebuggerValue.this.myExpression, variableContent.getBytes(StandardCharsets.UTF_8)));
                    ZendDebuggerValue.this.computeChildren(node);
                }

                @Override
                public void onErrorResponse(@NotNull GetVarResponse message) {
                    if (message == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    node.setErrorMessage(PhpBundle.message("debug.error.cannot.evaluate.variables", new Object[0]));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "message";
                    objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerValue$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Override
    @NotNull
    public String getPresentableValue() {
        return ZendDebuggerValue.getPresentableValue(this.myExpression.getValue());
    }

    @NotNull
    private static String getPresentableValue(@NotNull ZendDebuggerExpressionValue value) {
        if (value == null) {
            ZendDebuggerValue.$$$reportNull$$$0(5);
        }
        String string = value.isObject() ? value.getTypeAsString() : value.getValueAsString();
        if (string == null) {
            ZendDebuggerValue.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected boolean isArray() {
        return this.myExpression.getValue().isArray();
    }

    @Override
    protected boolean isObject() {
        return this.myExpression.getValue().isObject();
    }

    @Override
    protected List<String> getChildren(int maxCount) {
        if (this.isArray() || this.isObject()) {
            ZendDebuggerExpression[] children = this.myExpression.getValue().getChildren();
            ArrayList<String> values = new ArrayList<String>(maxCount);
            for (int i = 0; i < children.length && i < maxCount; ++i) {
                ZendDebuggerExpression child = children[i];
                String name = child.getLastName();
                StringBuilder presentableValue = new StringBuilder();
                if (StringUtil.isNotEmpty((String)name) && !name.equals(String.valueOf(i))) {
                    presentableValue.append(name);
                    presentableValue.append(" => ");
                }
                ZendDebuggerExpressionValue value = child.getValue();
                presentableValue.append(this.wrapPresentableValue(value, ZendDebuggerValue.getPresentableValue(value)));
                values.add(presentableValue.toString());
            }
            return values;
        }
        return new SmartList((Object)this.myExpression.getValue().getValueAsString());
    }

    @Override
    @Nullable
    public Map<String, String> getLoadedChildren() {
        if (this.isArray() || this.isObject()) {
            ZendDebuggerExpression[] children;
            THashMap values = new THashMap();
            for (ZendDebuggerExpression child : children = this.myExpression.getValue().getChildren()) {
                values.put(child.getLastName(), child.getValue().getValueAsString());
            }
            return values;
        }
        return null;
    }

    @Override
    protected int getChildrenCount() {
        return this.myExpression.getValue().getChildrenCount();
    }

    @Override
    protected XDebugSession getSession() {
        return this.myDebugProcess.getSession();
    }

    @Override
    public String getShortName() {
        return this.myExpression.getLastName();
    }

    @Override
    public void processFullValue(@NotNull PhpEvaluationResultProcessor evaluationCallback) {
        if (evaluationCallback == null) {
            ZendDebuggerValue.$$$reportNull$$$0(7);
        }
        evaluationCallback.success(this.getPresentableValue(), this.myExpression.getValue(), this);
    }

    @Override
    @Nullable
    protected PsiElement findTargetElement(@NotNull Project project, @NotNull XSourcePosition position, @NotNull Editor editor) {
        if (project == null) {
            ZendDebuggerValue.$$$reportNull$$$0(8);
        }
        if (position == null) {
            ZendDebuggerValue.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            ZendDebuggerValue.$$$reportNull$$$0(10);
        }
        if (this.myExpression.getPath().length == 1) {
            return this.findTargetVariable(project, position, editor, this.myExpression.getLastName());
        }
        if (this.myExpression.getPath().length == 2 && StringUtil.equalsIgnoreCase((CharSequence)this.myExpression.getPath()[0], (CharSequence)"$this")) {
            return this.findTargetField(project, position, editor, this.myExpression.getLastName());
        }
        return null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getShortName();
        if (string == null) {
            ZendDebuggerValue.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    protected PhpType calculateType() {
        PhpType phpType = new PhpType().add(this.myExpression.getValue().getTypeAsString());
        if (phpType == null) {
            ZendDebuggerValue.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationCallback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableValue";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFullValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

