/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.proxy;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.connection.InputReader;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpOutputMessage;
import com.jetbrains.php.debug.xdebug.proxy.DBGPProxyConfigurable;
import com.jetbrains.php.debug.xdebug.proxy.DBGPProxySettings;
import com.jetbrains.php.ui.PhpUiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DBGPProxyActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(DBGPProxyActionBase.class);
    protected static final String NOTIFICATION_GROUP_ID = "DBGP Proxy";

    protected DBGPProxyActionBase(@NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(1);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        this.actionPerformed(project);
    }

    private void actionPerformed(@NotNull Project project) {
        if (project == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(2);
        }
        boolean allowAction = true;
        try {
            DBGPProxyConfigurable.validate(project, true);
        }
        catch (ConfigurationException e) {
            allowAction = PhpUiUtil.editConfigurable(project, new DBGPProxyConfigurable(project, true));
        }
        if (allowAction) {
            this.actionPerformedAndConfigurationValid(project);
        }
    }

    private void actionPerformedAndConfigurationValid(@NotNull Project project) {
        if (project == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(3);
        }
        DBGPProxySettings.State xdebugProxySettings = DBGPProxySettings.getInstance(project).getState();
        String host = xdebugProxySettings.getProxyHost();
        String ideKey = xdebugProxySettings.getIdeKey();
        int port = xdebugProxySettings.getProxyPort();
        DbgpOutputMessage request = this.createOutputMessage(project);
        final StringWriter stringWriter = new StringWriter();
        try {
            request.serialize(stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        final Runnable runnable = () -> {
            Socket socket = null;
            try {
                socket = new Socket(host, port);
                XdebugConnection.MyOutputWriter writer = new XdebugConnection.MyOutputWriter(socket.getOutputStream());
                writer.write(request);
                final InputStream inputStream = socket.getInputStream();
                InputReader<DbgpInputMessage> reader = new InputReader<DbgpInputMessage>(){

                    @Override
                    public DbgpInputMessage read() throws IOException {
                        return DbgpUtil.readMessageFromProxyServer(inputStream);
                    }
                };
                DbgpInputMessage inputMessage = (DbgpInputMessage)reader.read();
                ResponseResult responseResult = this.createResponseResult(inputMessage);
                String message = responseResult.getMessage();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(message);
                }
                if (responseResult.isSuccess()) {
                    DBGPProxyActionBase.showInfoNotification(project, message);
                } else {
                    DBGPProxyActionBase.showErrorNotification(project, StringUtil.notNullize((String)message, (String)PhpBundle.message("dbgp.proxy.ide.register.error", ideKey)));
                }
            }
            catch (UnknownHostException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Throwable)e);
                }
                DBGPProxyActionBase.showErrorNotification(project, PhpBundle.message("dbgp.proxy.cannot.connect.to.host", host));
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Throwable)e);
                }
                String stringPort = String.valueOf(port);
                DBGPProxyActionBase.showErrorNotification(project, PhpBundle.message("dbgp.proxy.cannot.connect.to.xdebug.proxy", host, stringPort));
            }
            finally {
                block22: {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block22;
                            LOG.debug((Throwable)e);
                        }
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DBGPProxyActionBase.getProgressTaskTitle(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(PhpBundle.message("dbgp.proxy.sending.request.to.xdebug.proxy", new Object[0]));
                @NlsSafe String request = stringWriter.toString();
                indicator.setText2(request);
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/debug/xdebug/proxy/DBGPProxyActionBase$2", "run"));
            }
        });
    }

    @NotNull
    protected abstract ResponseResult createResponseResult(@NotNull DbgpInputMessage var1);

    @NotNull
    protected abstract DbgpOutputMessage createOutputMessage(@NotNull Project var1);

    protected static void showInfoNotification(@NotNull Project project, @NotNull @NlsContexts.NotificationContent String message) {
        if (project == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(4);
        }
        if (message == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_GROUP_ID, PhpBundle.message("dbgp.proxy", new Object[0]), message, NotificationType.INFORMATION), (Project)project);
    }

    protected static void showErrorNotification(@NotNull Project project, @NotNull @NlsContexts.NotificationContent String message) {
        if (project == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(6);
        }
        if (message == null) {
            DBGPProxyActionBase.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_GROUP_ID, PhpBundle.message("dbgp.proxy", new Object[0]), message, NotificationType.ERROR), (Project)project);
    }

    @NlsContexts.ProgressTitle
    protected static String getProgressTaskTitle() {
        return PhpBundle.message("dbgp.proxy", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/proxy/DBGPProxyActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformedAndConfigurationValid";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfoNotification";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class ResponseResult {
        private final boolean mySuccess;
        private final String myMessage;

        public static ResponseResult createSuccessResponseResult(@NotNull String message) {
            if (message == null) {
                ResponseResult.$$$reportNull$$$0(0);
            }
            return new ResponseResult(true, message);
        }

        public static ResponseResult createErrorResponseResult(@Nullable String message) {
            return new ResponseResult(false, message);
        }

        public static ResponseResult createErrorResponseResult() {
            return new ResponseResult(false, null);
        }

        private ResponseResult(boolean success, @Nullable String message) {
            this.mySuccess = success;
            this.myMessage = message;
        }

        public boolean isSuccess() {
            return this.mySuccess;
        }

        @Nullable
        @NlsSafe
        public String getMessage() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/proxy/DBGPProxyActionBase$ResponseResult", "createSuccessResponseResult"));
        }
    }
}

