/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.options;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.debug.xdebug.options.Xdebug2ConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.Xdebug3ConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsProvider;
import com.jetbrains.php.debug.xdebug.options.XdebugDefaultConfigurationOptionsProvider;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugConfigurationOptionsManager {
    private static final Logger LOGGER = Logger.getLogger(XdebugConfigurationOptionsManager.class.getName());

    @NotNull
    private static Optional<String> getXdebugVersion(@NotNull PhpInfo phpInfo) {
        List xDebuggers;
        if (phpInfo == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(0);
        }
        if ((xDebuggers = ContainerUtil.filter(phpInfo.getDebuggers(), debugger -> debugger.getDebugger().equals("xdebug"))).isEmpty()) {
            LOGGER.warning("Xdebug not found among available debuggers");
            Optional<String> optional = Optional.empty();
            if (optional == null) {
                XdebugConfigurationOptionsManager.$$$reportNull$$$0(1);
            }
            return optional;
        }
        if (xDebuggers.size() > 1) {
            LOGGER.warning("Several xDebugs are configured");
            Optional<String> optional = Optional.empty();
            if (optional == null) {
                XdebugConfigurationOptionsManager.$$$reportNull$$$0(2);
            }
            return optional;
        }
        Optional<String> optional = Optional.ofNullable(((PhpDebuggerInfo)xDebuggers.get(0)).getDebuggerVersion());
        if (optional == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(3);
        }
        return optional;
    }

    @NotNull
    public static XdebugConfigurationOptionsProvider getConfigurationOptionsProvider(@Nullable PhpInfo phpInfo) {
        String xdebugVersion;
        Optional<Object> optionalVersion = phpInfo == null ? Optional.empty() : XdebugConfigurationOptionsManager.getXdebugVersion(phpInfo);
        String string = xdebugVersion = optionalVersion.isEmpty() ? null : (String)optionalVersion.get();
        if (StringUtil.isEmpty((String)xdebugVersion)) {
            return new XdebugDefaultConfigurationOptionsProvider();
        }
        if (XdebugUtil.isAtLeastXdebug3(xdebugVersion)) {
            return new Xdebug3ConfigurationOptionsProvider();
        }
        return new Xdebug2ConfigurationOptionsProvider();
    }

    @NotNull
    public static XdebugConfigurationOptionsProvider getConfigurationOptionsProvider(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            XdebugConfigurationOptionsManager.$$$reportNull$$$0(4);
        }
        return interpreter == null ? new XdebugDefaultConfigurationOptionsProvider() : XdebugConfigurationOptionsManager.getConfigurationOptionsProvider(PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/options/XdebugConfigurationOptionsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/options/XdebugConfigurationOptionsManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXdebugVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXdebugVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationOptionsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

