/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertySetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import gnu.trove.THashMap;
import java.awt.Font;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugValue
extends PhpNavigatableValue {
    private static final Logger LOG = Logger.getInstance(XdebugValue.class);
    private static final String ANONYMOUS_CLASS = "class@anonymous";
    @NotNull
    private final PhpDebugProcess<XdebugConnection> myDebugProcess;
    private final int myStackDepth;
    private final int myContextId;
    @NotNull
    private final DbgpProperty myProperty;
    @Nullable
    private final String myNameOverride;
    @Nullable
    private final String myFullNameOverride;
    private static final String ARROW = "->";
    @Nullable
    public final String myParentClassName;
    public final String myParentFullName;
    private final boolean myParentIsArray;

    public XdebugValue(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, int stackDepth, int contextId, @NotNull DbgpProperty property, @Nullable String nameOverride, @Nullable String parentClassName, @Nullable String parentFullName, boolean parentIsArray, @Nullable String fullNameOverride) {
        if (debugProcess == null) {
            XdebugValue.$$$reportNull$$$0(0);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myStackDepth = stackDepth;
        this.myContextId = contextId;
        this.myProperty = property;
        this.myNameOverride = nameOverride;
        this.myParentClassName = parentClassName;
        this.myParentFullName = parentFullName;
        this.myParentIsArray = parentIsArray;
        this.myFullNameOverride = fullNameOverride;
    }

    public XdebugValue(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, int stackDepth, int contextId, @NotNull DbgpProperty property) {
        if (debugProcess == null) {
            XdebugValue.$$$reportNull$$$0(2);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(3);
        }
        this(debugProcess, stackDepth, contextId, property, null, null, null, false, null);
    }

    public Pair<String, Boolean> getValue() {
        return XdebugValue.getValue(this.myDebugProcess.getSession().getProject(), this.myProperty);
    }

    @NotNull
    protected static Pair<String, Boolean> getValue(@NotNull Project project, @NotNull DbgpProperty property) {
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(4);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(5);
        }
        if (property.isBoolean()) {
            String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
            boolean booleanValue = DbgpUtil.toBoolean((String)property.getLoadedValue((String)encoding).first);
            Pair pair = Pair.create((Object)(booleanValue ? "true" : "false"), (Object)false);
            if (pair == null) {
                XdebugValue.$$$reportNull$$$0(6);
            }
            return pair;
        }
        if (property.isArray() || property.isObject()) {
            Pair pair = Pair.create((Object)PhpBundle.message("debug.composite.value.presentation", property.getChildCount()), (Object)false);
            if (pair == null) {
                XdebugValue.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (property.isNull()) {
            Pair pair = Pair.create((Object)"null", (Object)false);
            if (pair == null) {
                XdebugValue.$$$reportNull$$$0(8);
            }
            return pair;
        }
        boolean isTrimmed = false;
        String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
        Pair<String, Integer> valueAndSize = property.getLoadedValue(encoding);
        String value = (String)valueAndSize.first;
        if ((Integer)valueAndSize.second < property.getValueSize()) {
            isTrimmed = true;
        }
        Pair pair = Pair.create((Object)value, (Object)isTrimmed);
        if (pair == null) {
            XdebugValue.$$$reportNull$$$0(9);
        }
        return pair;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        String address;
        Icon icon;
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(10);
        }
        if (place == null) {
            XdebugValue.$$$reportNull$$$0(11);
        }
        StringBuilder type = new StringBuilder();
        if (this.myProperty.isObject()) {
            icon = AllIcons.Debugger.Value;
            type.append(this.myProperty.getClassName(PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject())));
        } else if (this.myProperty.isArray()) {
            icon = AllIcons.Debugger.Db_array;
            type.append(PhpBundle.message("debug.type.array", new Object[0]));
        } else if (this.myProperty.isResource()) {
            icon = AllIcons.Debugger.Db_primitive;
            type.append(PhpBundle.message("debug.type.resource", new Object[0]));
        } else if (this.myProperty.isNumber()) {
            icon = AllIcons.Debugger.Db_primitive;
            if (this.myProperty.isFloat()) {
                type.append(PhpBundle.message("debug.type.float", new Object[0]));
            } else {
                type.append(PhpBundle.message("debug.type.int", new Object[0]));
            }
        } else {
            icon = AllIcons.Debugger.Db_primitive;
        }
        if (place != XValuePlace.TOOLTIP && PhpProjectDebugConfiguration.getInstance(this.myDebugProcess.getSession().getProject()).getState().isXDebugShowAddresses() && (address = this.myProperty.getAddress()) != null) {
            type.append('@').append(address);
        }
        Pair<String, Boolean> value = this.getValue();
        String typePresentation = type.length() > 0 ? type.toString() : null;
        Boolean isTrimmed = (Boolean)value.second;
        String valuePresentation = (String)value.first;
        if (valuePresentation.length() > 1000 && !isTrimmed.booleanValue()) {
            node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(valuePresentation));
        }
        node.setPresentation(icon, this.createPresentation(valuePresentation, typePresentation, this.myProperty), this.myProperty.hasChildren());
        if (isTrimmed.booleanValue()) {
            node.setFullValueEvaluator(new XFullValueEvaluator(){

                public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    if (callback == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    XdebugValue.this.evaluateFullValue(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$1", "startEvaluation"));
                }
            });
        }
    }

    private void evaluateFullValue(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        XdebugConnection connection;
        if (callback == null) {
            XdebugValue.$$$reportNull$$$0(12);
        }
        if ((connection = this.myDebugProcess.getConnection()) == null) {
            callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
            return;
        }
        connection.send(new PropertyValueRequest(this.getFullName(), this.myStackDepth, this.myContextId, 0, this.myProperty.getValueSize()), new DbgpResponseHandler<PropertyValueResponse>(){

            @Override
            public void onSuccessResponse(@NotNull PropertyValueResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                String encoding = PhpDebugUtil.getDebugOutputEncoding(XdebugValue.this.myDebugProcess.getSession().getProject());
                try {
                    String fullValue = message.getValue(encoding);
                    callback.evaluated(fullValue);
                }
                catch (UnsupportedEncodingException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    2.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(errorResponse.getErrorMessage());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public void processFullValue(final @NotNull PhpEvaluationResultProcessor evaluationCallback) {
        Pair<String, Boolean> value;
        Boolean isTrimmed;
        if (evaluationCallback == null) {
            XdebugValue.$$$reportNull$$$0(13);
        }
        if (!(isTrimmed = (Boolean)(value = this.getValue()).getSecond()).booleanValue()) {
            evaluationCallback.success((String)value.getFirst(), this.myProperty, this);
        } else {
            this.evaluateFullValue(new XFullValueEvaluator.XFullValueEvaluationCallback(){

                public void evaluated(@NotNull String fullValue, @Nullable Font font) {
                    if (fullValue == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.evaluated(fullValue);
                }

                public void evaluated(@NotNull String fullValue) {
                    if (fullValue == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    evaluationCallback.success(fullValue, XdebugValue.this.myProperty, XdebugValue.this);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    evaluationCallback.error(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fullValue";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public String getName() {
        String name;
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        String string = name = this.myNameOverride != null ? this.myNameOverride : this.myProperty.getShortName(encoding);
        if (name == null) {
            LOG.warn("Null property name, fullName=" + this.myProperty.getFullName(encoding));
            name = PhpBundle.message("unnamed.variable", new Object[0]);
        }
        return name;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        List<DbgpProperty> loadedChildren;
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(14);
        }
        if (this.myProperty.getChildCount() == 0) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.appendChildren(node, loadedChildren, (loadedChildren = this.myProperty.getLoadedChildren()).isEmpty() ? 0 : 1, 0);
    }

    private void appendChildren(final XCompositeNode node, List<DbgpProperty> properties, final int page, int reported) {
        int childCount = this.myProperty.getChildCount();
        if (properties.isEmpty()) {
            if (page > 0) {
                if (reported < childCount) {
                    LOG.warn("Not all children reported: " + reported + " out of " + childCount);
                }
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
        } else {
            XValueChildrenList children = new XValueChildrenList();
            for (DbgpProperty child : properties) {
                if (!child.isInitialized()) continue;
                String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
                XdebugValue value = new XdebugValue(this.myDebugProcess, this.myStackDepth, this.myContextId, child, null, this.myProperty.getClassName(encoding), this.getFullName(), this.myProperty.isArray(), null);
                children.add(value.getName(), (XValue)value);
            }
            if ((reported += properties.size()) > childCount) {
                LOG.warn("Too much children reported: " + reported + " out of " + childCount);
            }
            node.addChildren(children, reported == childCount);
        }
        if (reported < childCount) {
            final int reported1 = reported;
            XdebugConnection connection = this.myDebugProcess.getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            connection.send(new PropertyGetRequest(this.getFullName(), this.myStackDepth, this.myContextId, page), new DbgpResponseHandler<PropertyGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull PropertyGetResponse message) {
                    if (message == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    DbgpProperty property = message.getProperty();
                    XdebugValue.this.appendChildren(node, property.getLoadedChildren(), page + 1, reported1);
                }

                @Override
                public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                    if (errorResponse == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    node.setErrorMessage(errorResponse.getErrorMessage());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorResponse";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @NotNull
    public String getFullName() {
        if (this.myFullNameOverride != null) {
            String string = this.myFullNameOverride;
            if (string == null) {
                XdebugValue.$$$reportNull$$$0(15);
            }
            return string;
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        Object fullName = this.myProperty.getFullName(encoding);
        if (StringUtil.isEmpty((String)fullName)) {
            String shortName = this.myProperty.getShortName(encoding);
            if (this.myParentIsArray) {
                LOG.assertTrue(this.myParentFullName != null);
                String arrayKey = XdebugUtil.isInteger(shortName) ? shortName : (String)StringUtil.SINGLE_QUOTER.fun((Object)shortName);
                fullName = this.myParentFullName + "[" + arrayKey + "]";
            } else {
                fullName = (String)(StringUtil.isNotEmpty((String)this.myParentFullName) ? this.myParentFullName + ARROW : "") + shortName;
            }
        }
        String string = fullName;
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public String getEvaluationExpression() {
        return this.getFullName();
    }

    public XValueModifier getModifier() {
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            return null;
        }
        final String fullName = this.getFullName();
        return new XValueModifier(){

            public void setValue(@NotNull XExpression expression, final @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    5.$$$reportNull$$$0(1);
                }
                String encoding = PhpDebugUtil.getDebugOutputEncoding(XdebugValue.this.myDebugProcess.getSession().getProject());
                XdebugConnection connection = XdebugValue.this.myDebugProcess.getConnection();
                if (connection == null) {
                    callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
                    return;
                }
                PropertySetRequest propertySetRequest = new PropertySetRequest(fullName, XdebugValue.this.myContextId, XdebugValue.this.myStackDepth, expression.getExpression(), encoding);
                connection.send(propertySetRequest, new DbgpResponseHandler<SetResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull SetResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (message.isSuccess()) {
                            callback.valueModified();
                        } else {
                            callback.errorOccurred(PhpBundle.message("debug.error.cannot.modify.value", new Object[0]));
                        }
                    }

                    @Override
                    public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                        if (errorResponse == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        callback.errorOccurred(errorResponse.getErrorMessage());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorResponse";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$5$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public String getInitialValueEditorText() {
                String value = (String)XdebugValue.this.getValue().first;
                if (XdebugValue.this.myProperty.isString()) {
                    return StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)value));
                }
                return value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$5";
                objectArray[2] = "setValue";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public String getAddress() {
        return this.myProperty.getAddress();
    }

    @Override
    protected XDebugSession getSession() {
        return this.myDebugProcess.getSession();
    }

    @Override
    @Nullable
    protected PsiElement findTargetElement(@NotNull Project project, @NotNull XSourcePosition position, @NotNull Editor editor) {
        boolean isVariable;
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(17);
        }
        if (position == null) {
            XdebugValue.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            XdebugValue.$$$reportNull$$$0(19);
        }
        boolean bl = isVariable = StringUtil.isEmpty((String)this.myParentFullName) || this.myParentIsArray;
        if (isVariable) {
            if (!this.myProperty.isConstant()) {
                return this.findTargetVariable(project, position, editor, this.getFullName());
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)this.myParentFullName, (CharSequence)"$this")) {
            return this.findTargetField(project, position, editor, this.getName());
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return this.myProperty.isArray();
    }

    @Override
    public boolean isObject() {
        return this.myProperty.isObject();
    }

    @Override
    public int getChildrenCount() {
        return this.myProperty.getChildCount();
    }

    @Override
    public List<String> getChildren(int count) {
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            List<DbgpProperty> children = this.myProperty.getLoadedChildren();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < children.size() && i < count; ++i) {
                DbgpProperty child = children.get(i);
                String name = child.getShortName(encoding);
                StringBuilder presentableValue = new StringBuilder();
                if (StringUtil.isNotEmpty((String)name) && !name.equals(String.valueOf(i))) {
                    presentableValue.append(name);
                    presentableValue.append(" => ");
                }
                String value = this.getPresentableValue(this.myDebugProcess.getSession().getProject(), child);
                presentableValue.append(this.wrapPresentableValue(child, value));
                values.add(presentableValue.toString());
            }
            return values;
        }
        return new SmartList((Object)this.getPresentableValue(this.myDebugProcess.getSession().getProject(), this.myProperty));
    }

    @Override
    @Nullable
    public Map<String, String> getLoadedChildren() {
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            THashMap values = new THashMap();
            List<DbgpProperty> children = this.myProperty.getLoadedChildren();
            String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
            for (DbgpProperty child : children) {
                values.put(child.getShortName(encoding), this.getPresentableValue(this.myDebugProcess.getSession().getProject(), child));
            }
            return values;
        }
        return null;
    }

    @Override
    @NotNull
    public String getPresentableValue() {
        String string = this.getPresentableValue(this.myDebugProcess.getSession().getProject(), this.myProperty);
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getPresentableValue(@NotNull Project project, @NotNull DbgpProperty property) {
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(21);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(22);
        }
        if (property.isObject()) {
            String string = property.getClassName(PhpDebugUtil.getDebugOutputEncoding(project));
            if (string == null) {
                XdebugValue.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = (String)XdebugValue.getValue((Project)project, (DbgpProperty)property).first;
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = StringUtil.trimStart((String)this.getShortName(), (String)"$");
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    @NotNull
    protected PhpType calculateType() {
        if (this.isObject()) {
            String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
            String className = this.myProperty.getClassName(encoding);
            if (ANONYMOUS_CLASS.equals(className)) {
                PhpType phpType = new PhpType().add(className);
                if (phpType == null) {
                    XdebugValue.$$$reportNull$$$0(26);
                }
                return phpType;
            }
            PhpType phpType = new PhpType().add(PhpLangUtil.toFQN(className));
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(27);
            }
            return phpType;
        }
        if (this.myProperty.isBoolean()) {
            PhpType phpType = PhpType.BOOLEAN;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(28);
            }
            return phpType;
        }
        if (this.myProperty.isFloat()) {
            PhpType phpType = PhpType.FLOAT;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(29);
            }
            return phpType;
        }
        if (this.myProperty.isInt()) {
            PhpType phpType = PhpType.INT;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(30);
            }
            return phpType;
        }
        if (this.myProperty.isArray()) {
            PhpType phpType = PhpType.ARRAY;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(31);
            }
            return phpType;
        }
        if (this.myProperty.isString()) {
            PhpType phpType = PhpType.STRING;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(32);
            }
            return phpType;
        }
        if (this.myProperty.isNull()) {
            PhpType phpType = PhpType.NULL;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(33);
            }
            return phpType;
        }
        if (this.myProperty.isResource()) {
            PhpType phpType = PhpType.RESOURCE;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(34);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            XdebugValue.$$$reportNull$$$0(35);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationCallback";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluateFullValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processFullValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

