/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpLineBreakpointType;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.common.PhpSuspendContext;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoState;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.actions.XdebugAddMethodToSkipListAction;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointRemoveRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointRemoveResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointSetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpBreakpointPosition;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpStatus;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DetachRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ExceptionBreakpointSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.LineBreakpointSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.MethodBreakpointSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpErrorNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpResolvedBreakpointNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.RunRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StdoutNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StepIntoRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StepOutRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StepOverRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StopRequest;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpStackFrame;
import com.jetbrains.php.debug.xdebug.debugger.XdebugStackFrame;
import com.jetbrains.php.debug.xdebug.debugger.XdebugValue;
import com.jetbrains.php.debug.xdebug.handlers.DbgpErrorNotificationHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XdebugDriver
extends PhpDebugDriver<XdebugConnection> {
    private static final Logger LOG = Logger.getInstance(XdebugDriver.class);
    public static final XdebugDriver INSTANCE = new XdebugDriver();
    XdebugAddMethodToSkipListAction actionAddToSkipList;

    private XdebugDriver() {
    }

    @Override
    @NotNull
    public String getSessionIdName() {
        return "ide key";
    }

    @Override
    public boolean isConditionalBreakpointSupported(XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        return breakpoint instanceof PhpLineBreakpointType;
    }

    @Override
    public boolean isExceptionalBreakpointSupported() {
        return true;
    }

    @Override
    public boolean isMethodBreakpointSupported() {
        return true;
    }

    @Override
    public void registerBreakpoint(@NotNull XdebugConnection connection, @NotNull String remoteFilePath, int line, @Nullable String condition, @NotNull String encoding, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            XdebugDriver.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            XdebugDriver.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            XdebugDriver.$$$reportNull$$$0(3);
        }
        String remoteFileUrl = XdebugDriver.pathToUrl(remoteFilePath);
        LineBreakpointSetRequest request = condition != null ? new LineBreakpointSetRequest(remoteFileUrl, line, condition, encoding) : new LineBreakpointSetRequest(remoteFileUrl, line);
        XdebugDriver.registerBreakpoint(connection, request, callback);
    }

    @Override
    public void registerExceptionBreakpoint(@NotNull XdebugConnection connection, @NotNull String exception2, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(4);
        }
        if (exception2 == null) {
            XdebugDriver.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            XdebugDriver.$$$reportNull$$$0(6);
        }
        ExceptionBreakpointSetRequest request = new ExceptionBreakpointSetRequest(exception2);
        XdebugDriver.registerBreakpoint(connection, request, callback);
    }

    @Override
    public void registerMethodBreakpoint(@NotNull XdebugConnection connection, @NotNull PhpMethodBreakpointProperties properties, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            XdebugDriver.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            XdebugDriver.$$$reportNull$$$0(9);
        }
        MethodBreakpointSetRequest request = new MethodBreakpointSetRequest(properties.getFunctionFqn());
        XdebugDriver.registerBreakpoint(connection, request, callback);
    }

    private static void registerBreakpoint(final @NotNull XdebugConnection connection, final @NotNull BreakpointSetRequest request, final @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(10);
        }
        if (request == null) {
            XdebugDriver.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            XdebugDriver.$$$reportNull$$$0(12);
        }
        connection.send(request, new DbgpResponseHandler<BreakpointSetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull BreakpointSetResponse message) {
                String breakpointId;
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.isNotEmpty((String)(breakpointId = message.getBreakpointId()))) {
                    callback.registered(breakpointId);
                } else {
                    callback.errorOccurred(PhpBundle.message("debug.php.breakpoint.failed.to.register", new Object[0]));
                    Version version = connection.getEngineVersion();
                    LOG.error("Invalid 'breakpoint_set' response, breakpoint id is empty. Engine: " + (Comparable)((Object)(version == null ? "not detected" : version)) + "\n -> " + request);
                }
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(errorResponse.getErrorMessage());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void unregisterBreakpoint(@NotNull XdebugConnection connection, @NotNull String breakpointId, final @NotNull PhpDebugProcess.UnregisterBreakpointCallback callback) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(13);
        }
        if (breakpointId == null) {
            XdebugDriver.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            XdebugDriver.$$$reportNull$$$0(15);
        }
        connection.send(new BreakpointRemoveRequest(breakpointId), new DbgpResponseHandler<BreakpointRemoveResponse>(){

            @Override
            public void onSuccessResponse(@NotNull BreakpointRemoveResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.unregistered();
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    2.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(errorResponse.getErrorMessage());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull PhpDebugProcess<XdebugConnection> process) {
        if (leftToolbar == null) {
            XdebugDriver.$$$reportNull$$$0(16);
        }
        if (topToolbar == null) {
            XdebugDriver.$$$reportNull$$$0(17);
        }
        if (process == null) {
            XdebugDriver.$$$reportNull$$$0(18);
        }
        topToolbar.add(ActionManager.getInstance().getAction("XdebugShowUserDefinedConstants"));
        topToolbar.add(ActionManager.getInstance().getAction("XdebugShowValuesAddresses"));
        topToolbar.add(ActionManager.getInstance().getAction("PhpDebugHideEmptySuperGlobals"));
        this.actionAddToSkipList = (XdebugAddMethodToSkipListAction)ActionManager.getInstance().getAction("XdebugAddMethodToSkipListAction");
        this.actionAddToSkipList.setProcess(process);
        topToolbar.add((AnAction)this.actionAddToSkipList);
    }

    @Override
    public XValueMarkerProvider<XdebugValue, String> createValueMarkerProvider() {
        return new XValueMarkerProvider<XdebugValue, String>(XdebugValue.class){

            public boolean canMark(@NotNull XdebugValue value) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                return value.getAddress() != null;
            }

            public String getMarker(@NotNull XdebugValue value) {
                if (value == null) {
                    3.$$$reportNull$$$0(1);
                }
                return value.getAddress();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canMark";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getMarker";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void registerHandlers(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess) {
        XdebugConnection connection;
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(19);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            connection.registerClassHandler(StatusResponse.class, new InputHandler<StatusResponse>(){

                @Override
                public void onResponse(@NotNull StatusResponse message) {
                    if (message == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    DbgpStatus status = message.getStatus();
                    connection.onDebugSessionStatusChanged(status);
                    if (status == DbgpStatus.BREAK) {
                        String url = message.getUrl();
                        if (StringUtil.isEmpty((String)url)) {
                            debugProcess.getSession().reportMessage(PhpBundle.message("debug.log.invalid.xdebug.message", new Object[0]), MessageType.ERROR);
                            debugProcess.getSession().resume();
                            return;
                        }
                        XdebugDriver.onBreak(debugProcess, url, message.getException(), message.getLineNumber());
                    } else if (status == DbgpStatus.STOPPING || status == DbgpStatus.STOPPED) {
                        XdebugConnection debugConnection = (XdebugConnection)debugProcess.getConnection();
                        if (debugConnection != null && debugConnection.getEngineVersion() != null && debugConnection.getEngineVersion().isOrGreaterThan(Integer.valueOf(3))) {
                            XdebugDriver.this.detach(debugConnection);
                        }
                        debugProcess.getSession().resume();
                    } else {
                        debugProcess.getSession().resume();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$4", "onResponse"));
                }
            });
            connection.registerClassHandler(StdoutNotification.class, new InputHandler<StdoutNotification>(){

                @Override
                public void onResponse(@NotNull StdoutNotification message) {
                    if (message == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!debugProcess.isExternalStdoutEnabled()) {
                        return;
                    }
                    XDebugSession session = debugProcess.getSession();
                    if (session != null) {
                        debugProcess.printExternalStdout(message.getData(PhpDebugUtil.getDebugOutputEncoding(session.getProject())));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$5", "onResponse"));
                }
            });
            connection.registerClassHandler(PhpResolvedBreakpointNotification.class, new InputHandler<PhpResolvedBreakpointNotification>(){

                @Override
                public void onResponse(@NotNull PhpResolvedBreakpointNotification message) {
                    DbgpBreakpointPosition.DbgpLineBreakpointPosition linePosition;
                    if (message == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    this.logResolvedBreakpoint(message);
                    DbgpBreakpointPosition resolved = message.getPosition();
                    if (!(resolved instanceof DbgpBreakpointPosition.DbgpLineBreakpointPosition)) {
                        return;
                    }
                    String breakpointId = message.getBreakpointId();
                    if (this.isResolvedToAnotherLine(breakpointId, linePosition = (DbgpBreakpointPosition.DbgpLineBreakpointPosition)resolved)) {
                        debugProcess.getLineBreakpointHandler().registerResolvedBreakpoint(breakpointId, linePosition);
                    }
                }

                private void logResolvedBreakpoint(@NotNull PhpResolvedBreakpointNotification message) {
                    if (message == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (LOG.isTraceEnabled()) {
                        StringBuilder out = new StringBuilder();
                        out.append("breakpoint with id=").append(message.getBreakpointId());
                        out.append(" was ").append(message.isResolved() ? "resolved" : "not resolved");
                        out.append(" (state=").append(message.getState());
                        out.append(", type=").append(message.getType());
                        if (StringUtil.isNotEmpty((String)message.getPresentation())) {
                            out.append(", ").append(message.getPresentation());
                        }
                        out.append(")\n");
                        LOG.trace(out.toString());
                    }
                }

                private boolean isResolvedToAnotherLine(@NotNull String breakpointId, DbgpBreakpointPosition.DbgpLineBreakpointPosition resolvedPosition) {
                    XLineBreakpoint<XBreakpointProperties> breakpoint;
                    if (breakpointId == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    if ((breakpoint = debugProcess.getLineBreakpointHandler().findBreakpointById(breakpointId)) == null) {
                        return true;
                    }
                    XSourcePosition position = breakpoint.getSourcePosition();
                    return position != null && position.getLine() != resolvedPosition.getLine();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "breakpointId";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "logResolvedBreakpoint";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isResolvedToAnotherLine";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Override
    public void registerErrorOutputHandler(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull PhpDebugProcess.ErrorOutputHandler handler) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(20);
        }
        if (handler == null) {
            XdebugDriver.$$$reportNull$$$0(21);
        }
        XdebugConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(PhpErrorNotification.class, new DbgpErrorNotificationHandler(debugProcess, handler));
    }

    @Override
    public void startStepOver(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(22);
        }
        connection.send(new StepOverRequest(), null);
    }

    @Override
    public void startStepInto(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(23);
        }
        connection.send(new StepIntoRequest(), null);
    }

    @Override
    public void startFilteredStepInto(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess, final @NotNull XdebugConnection connection, final @NotNull PhpStepFiltersConfiguration.State state) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(24);
        }
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(25);
        }
        if (state == null) {
            XdebugDriver.$$$reportNull$$$0(26);
        }
        connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StackGetResponse message) {
                if (message == null) {
                    7.$$$reportNull$$$0(0);
                }
                connection.send(new StepIntoRequest(), new DbgpResponseHandler<StatusResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull StatusResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        XdebugDriver.this.handleFilteredStepInto(debugProcess, connection, state);
                        connection.onDebugSessionStatusChanged(message.getStatus());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$7$1", "onSuccessResponse"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$7", "onSuccessResponse"));
            }
        });
    }

    @Override
    public void startSmartStepInto(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess) {
        XdebugConnection connection;
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(27);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull StackGetResponse message) {
                    if (message == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    List<DbgpStackFrame> frames = message.getStackFrames();
                    int depth = frames.size();
                    PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
                    assert (state != null);
                    state.setInitialDepth(depth);
                    connection.send(new StepIntoRequest(), new DbgpResponseHandler<StatusResponse>(){

                        @Override
                        public void onSuccessResponse(@NotNull StatusResponse message) {
                            if (message == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            XdebugDriver.this.handleSmartStepInto(debugProcess, connection);
                            connection.onDebugSessionStatusChanged(message.getStatus());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$8$1", "onSuccessResponse"));
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$8", "onSuccessResponse"));
                }
            });
        }
    }

    public void smartStepInto(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess, final @NotNull XdebugConnection connection) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(28);
        }
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(29);
        }
        connection.send(new StepOverRequest(), new DbgpResponseHandler<StatusResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StatusResponse message) {
                if (message == null) {
                    9.$$$reportNull$$$0(0);
                }
                XdebugDriver.this.handleSmartStepInto(debugProcess, connection);
                connection.onDebugSessionStatusChanged(message.getStatus());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$9", "onSuccessResponse"));
            }
        });
    }

    private void handleFilteredStepInto(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess, final @NotNull XdebugConnection connection, final PhpStepFiltersConfiguration.State state) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(30);
        }
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(31);
        }
        connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StackGetResponse message) {
                if (message == null) {
                    10.$$$reportNull$$$0(0);
                }
                List<DbgpStackFrame> frames = message.getStackFrames();
                assert (!frames.isEmpty());
                DbgpStackFrame firstFrame = frames.get(0);
                if (firstFrame != null && XdebugDriver.isSkipped(firstFrame, state, debugProcess)) {
                    debugProcess.log(PhpBundle.message("PhpStepFilters.log.frame", firstFrame.functionName, firstFrame.getRemoteFileUrl()));
                    XdebugDriver.this.startFilteredStepInto((PhpDebugProcess<XdebugConnection>)debugProcess, connection, state);
                } else {
                    this.stopFilteredStepInto();
                }
            }

            private void stopFilteredStepInto() {
                debugProcess.stopSmartStepInto(true);
                connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull StackGetResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        assert (!message.getStackFrames().isEmpty());
                        DbgpStackFrame dbgpStackFrame = message.getStackFrames().get(0);
                        String remoteFileUrl = dbgpStackFrame.getRemoteFileUrl();
                        int line = dbgpStackFrame.getLine();
                        XdebugDriver.onBreak(debugProcess, remoteFileUrl, null, line);
                    }

                    @Override
                    public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                        if (errorResponse == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        debugProcess.getSession().resume();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorResponse";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$10$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$10", "onSuccessResponse"));
            }
        });
    }

    private void handleSmartStepInto(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess, final @NotNull XdebugConnection connection) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(32);
        }
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(33);
        }
        connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StackGetResponse message) {
                String className;
                if (message == null) {
                    11.$$$reportNull$$$0(0);
                }
                List<DbgpStackFrame> frames = message.getStackFrames();
                assert (!frames.isEmpty());
                DbgpStackFrame firstFrame = frames.get(0);
                String name = firstFrame.functionName;
                PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
                List<String> functions = PhpDebugDriver.splitMethodName(name);
                String string = className = functions.size() == 2 ? functions.get(0) : null;
                assert (state != null);
                boolean isAchieved = state.isTargetFunctionReached(className, functions.get(functions.size() - 1));
                if (isAchieved || frames.size() <= state.getInitialDepth()) {
                    this.stopSmartStepInto(isAchieved);
                } else {
                    XdebugDriver.this.smartStepInto(debugProcess, connection);
                }
            }

            private void stopSmartStepInto(boolean functionAchieved) {
                debugProcess.stopSmartStepInto(functionAchieved);
                connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull StackGetResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        assert (!message.getStackFrames().isEmpty());
                        DbgpStackFrame dbgpStackFrame = message.getStackFrames().get(0);
                        String remoteFileUrl = dbgpStackFrame.getRemoteFileUrl();
                        int line = dbgpStackFrame.getLine();
                        XdebugDriver.onBreak(debugProcess, remoteFileUrl, null, line);
                    }

                    @Override
                    public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                        if (errorResponse == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        debugProcess.getSession().resume();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorResponse";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$11$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$11", "onSuccessResponse"));
            }
        });
    }

    @Override
    public void startStepOut(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(34);
        }
        connection.send(new StepOutRequest(), null);
    }

    @Override
    public void resume(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(35);
        }
        connection.send(new RunRequest(), null);
    }

    @Override
    public void stop(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(36);
        }
        StopRequest request = new StopRequest();
        request.setTimeout(1000, connection::stop);
        connection.send(request, null);
    }

    public void detach(@NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugDriver.$$$reportNull$$$0(37);
        }
        connection.send(new DetachRequest(), null);
    }

    @Override
    public void start(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess) {
        XdebugConnection connection;
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(38);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StackGetResponse message) {
                PhpPathMapper pathMapper;
                if (message == null) {
                    12.$$$reportNull$$$0(0);
                }
                assert (!message.getStackFrames().isEmpty());
                DbgpStackFrame dbgpStackFrame = message.getStackFrames().get(0);
                String remoteFileUrl = dbgpStackFrame.getRemoteFileUrl();
                int line = dbgpStackFrame.getLine();
                Project project = debugProcess.getSession().getProject();
                PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
                boolean breakAtFirstLine = state.isBreakAtFirstLine();
                if (!breakAtFirstLine && (pathMapper = debugProcess.getPathMapper()) != null) {
                    VirtualFile localFile = pathMapper.getLocalFile(remoteFileUrl);
                    if (localFile != null) {
                        XLineBreakpoint<XBreakpointProperties> breakpoint;
                        boolean shouldResume;
                        boolean allowForceBreak = debugProcess.getStrategy().isAllowToForceBreak();
                        boolean breakOutsideTheProject = this.forceBreakOutsideTheProject(project, state, localFile);
                        boolean bl = shouldResume = !allowForceBreak || !breakOutsideTheProject;
                        if (!shouldResume) {
                            shouldResume = (Boolean)ReadAction.compute(() -> GlobalSearchScope.allScope((Project)project).contains(localFile));
                        }
                        if (shouldResume && ((breakpoint = PhpLineBreakpointType.findBreakpointAtLine(project, localFile, line)) == null || !breakpoint.isEnabled())) {
                            debugProcess.getSession().resume();
                            return;
                        }
                    } else if (!debugProcess.getStrategy().isAllowToForceBreak() || !PhpProjectDebugConfiguration.getInstance(debugProcess.getSession().getProject()).getState().isXdebugForceBreakWhenNoPathMapping()) {
                        debugProcess.getSession().resume();
                        return;
                    }
                }
                XdebugDriver.onBreak(debugProcess, remoteFileUrl, null, line);
            }

            public boolean forceBreakOutsideTheProject(@NotNull Project project, @NotNull PhpProjectDebugConfiguration.State state, @NotNull VirtualFile localFile) {
                if (project == null) {
                    12.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    12.$$$reportNull$$$0(2);
                }
                if (localFile == null) {
                    12.$$$reportNull$$$0(3);
                }
                return state.isXdebugForceBreakWhenOutsideProject() && !PhpRunUtil.isPhpScratch(project, localFile);
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    12.$$$reportNull$$$0(4);
                }
                debugProcess.getSession().resume();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localFile";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "forceBreakOutsideTheProject";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void onBreak(final @NotNull PhpDebugProcess<XdebugConnection> debugProcess, final @NotNull String remoteFileUrl, final @Nullable DbgpExceptionBreak exception2, final int lineNumber) {
        if (debugProcess == null) {
            XdebugDriver.$$$reportNull$$$0(39);
        }
        if (remoteFileUrl == null) {
            XdebugDriver.$$$reportNull$$$0(40);
        }
        String remoteFilePath = XdebugDriver.urlToPath(remoteFileUrl);
        debugProcess.log(PhpBundle.message("debug.log.stop", remoteFileUrl, lineNumber));
        PhpPathMapper pathMapper = debugProcess.getPathMapper();
        if (pathMapper != null) {
            debugProcess.log(PhpBundle.message("debug.log.path.mapping.remote.local", remoteFileUrl, pathMapper.getLocalPath(remoteFileUrl)));
        }
        debugProcess.log(PhpBundle.message("debug.log.path.mapping.remote.extracted", remoteFileUrl, remoteFilePath));
        XdebugConnection connection = debugProcess.getConnection();
        if (connection == null) {
            debugProcess.log(PhpBundle.message("debug.log.connection.was.terminated", remoteFilePath, lineNumber));
            return;
        }
        connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StackGetResponse message) {
                if (message == null) {
                    13.$$$reportNull$$$0(0);
                }
                Runnable reloader = () -> XdebugDriver.onBreak(debugProcess, remoteFileUrl, exception2, lineNumber);
                List<DbgpStackFrame> dbgpStackFrames = message.getStackFrames();
                ArrayList<PhpStackFrame> stackFrames = new ArrayList<PhpStackFrame>(dbgpStackFrames.size());
                for (DbgpStackFrame dbgpStackFrame : dbgpStackFrames) {
                    String remoteFilePath = XdebugDriver.urlToPath(dbgpStackFrame.remoteFileUrl);
                    String functionName = dbgpStackFrame.functionName;
                    int line = dbgpStackFrame.line;
                    int depth = dbgpStackFrame.level;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        int deep = stackFrames.size();
                        stackFrames.add(new XdebugStackFrame(debugProcess, reloader, remoteFilePath, line, functionName, deep, depth, exception2));
                    });
                }
                if (exception2 != null) {
                    debugProcess.log(PhpBundle.message("debug.log.exception.break", exception2.getExceptionName(), exception2.getMessage()));
                }
                debugProcess.onReady(new PhpSuspendContext(stackFrames), exception2 == null ? null : exception2.getExceptionName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$13", "onSuccessResponse"));
            }
        });
    }

    @Override
    @NotNull
    public PhpDebugPathExtractor createPathFromUrlExtractor() {
        return new XdebugPathExtractor();
    }

    @NotNull
    public static String urlToPath(@NotNull String url) {
        if (url == null) {
            XdebugDriver.$$$reportNull$$$0(41);
        }
        if (url.startsWith("dbgp://")) {
            String string = PhpPathMapper.urlToPath(url.substring("dbgp://".length()));
            if (string == null) {
                XdebugDriver.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = PhpPathMapper.urlToPath(url);
        if (string == null) {
            XdebugDriver.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            XdebugDriver.$$$reportNull$$$0(44);
        }
        String protocolPrefix = path.contains(".phar") ? "phar://" : "file://";
        Object normalizedUrl = protocolPrefix + path;
        normalizedUrl = ((String)normalizedUrl).replace(File.separator, "/");
        normalizedUrl = StringUtil.replace((String)normalizedUrl, (String)"%", (String)"%25");
        Object object = normalizedUrl = StringUtil.replace((String)normalizedUrl, (String)" ", (String)"%20");
        if (object == null) {
            XdebugDriver.$$$reportNull$$$0(45);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileUrl";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerBreakpoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerExceptionBreakpoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodBreakpoint";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBreakpoint";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerHandlers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorOutputHandler";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startStepOver";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startFilteredStepInto";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "startSmartStepInto";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "smartStepInto";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "handleFilteredStepInto";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "handleSmartStepInto";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startStepOut";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resume";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "stop";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "detach";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "onBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "urlToPath";
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 42: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XdebugPathExtractor
    implements PhpDebugPathExtractor {
        private XdebugPathExtractor() {
        }

        @Override
        @NotNull
        public String extractPath(@NotNull String remoteFilePath) {
            if (remoteFilePath == null) {
                XdebugPathExtractor.$$$reportNull$$$0(0);
            }
            String string = XdebugDriver.urlToPath(remoteFilePath);
            if (string == null) {
                XdebugPathExtractor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$XdebugPathExtractor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugDriver$XdebugPathExtractor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

