/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpBreakpoint;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpBreakpointPosition;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpResolvedBreakpointNotification
extends DbgpInputMessage {
    private final DbgpBreakpoint myBreakpoint = new DbgpBreakpoint();

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        String name = packet.getAttributeValue("name");
        if (!StringUtil.equals((CharSequence)name, (CharSequence)"breakpoint_resolved")) {
            throw new IOException("Invalid type of notification");
        }
        Element breakpoint = PhpResolvedBreakpointNotification.getXdebugBreakpointTag(packet);
        if (breakpoint != null) {
            this.myBreakpoint.deserialize(breakpoint);
        }
        return this;
    }

    @Nullable
    private static Element getXdebugBreakpointTag(@NotNull Element packet) {
        Element child;
        if (packet == null) {
            PhpResolvedBreakpointNotification.$$$reportNull$$$0(0);
        }
        if ((child = packet.getChild("breakpoint", null)) != null) {
            return child;
        }
        Namespace namespace = packet.getNamespace("xdebug");
        return packet.getChild("breakpoint", namespace);
    }

    public String getBreakpointId() {
        return this.myBreakpoint.getBreakpointId();
    }

    public String getState() {
        return this.myBreakpoint.getState();
    }

    public boolean isResolved() {
        return this.myBreakpoint.isResolved();
    }

    public String getType() {
        return this.myBreakpoint.getType();
    }

    public String getPresentation() {
        return this.myBreakpoint.getPresentation();
    }

    public DbgpBreakpointPosition getPosition() {
        return this.myBreakpoint.getPosition();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packet", "com/jetbrains/php/debug/xdebug/dbgp/messages/PhpResolvedBreakpointNotification", "getXdebugBreakpointTag"));
    }
}

