/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PhpErrorNotification
extends DbgpInputMessage {
    private String myErrorType;
    private String myUrl;
    private int myLineNumber;
    private String myText;

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        String name = packet.getAttributeValue("name");
        if (!StringUtil.equals((CharSequence)name, (CharSequence)"error")) {
            throw new IOException("Invalid type of notification");
        }
        Element messageTag = DbgpUtil.getXdebugMessageTag(packet);
        if (messageTag != null) {
            String filePath = messageTag.getAttributeValue("filename");
            this.myUrl = StringUtil.isNotEmpty((String)filePath) ? URLUtil.decode((String)filePath) : "<undefined>";
            this.myLineNumber = StringUtilRt.parseInt((String)messageTag.getAttributeValue("lineno"), (int)0);
            this.myErrorType = StringUtil.notNullize((String)messageTag.getAttributeValue("type"));
            this.myText = StringUtil.notNullize((String)messageTag.getText());
        }
        return this;
    }

    public String getErrorType() {
        return this.myErrorType;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getPresentableMessage() {
        StringBuilder out = new StringBuilder("PHP ");
        out.append(this.getErrorType()).append(": ").append(this.getText());
        String url = this.getUrl();
        if (StringUtil.isNotEmpty((String)url)) {
            out.append(" in ").append(VirtualFileManager.extractPath((String)url));
        }
        out.append(" on line ").append(this.getLineNumber()).append("\n");
        String string = out.toString();
        if (string == null) {
            PhpErrorNotification.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/xdebug/dbgp/messages/PhpErrorNotification", "getPresentableMessage"));
    }
}

