/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class InitNotification
extends DbgpInputMessage {
    public static final String IDE_KEY_ATTR = "idekey";
    public static final String CLOUDID_ATTR = "userid";
    public static final String FILE_URI_ATTR = "fileuri";
    private static final String ENGINE_ELEMENT = "engine";
    private String mySessionId;
    private String myCloudId;
    private String myFileUri;
    private String myEngineVersion;
    private String myLanguageVersion;

    public String getCloudId() {
        return this.myCloudId;
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    public String getFileUri() {
        return this.myFileUri;
    }

    public String getEngineVersion() {
        return this.myEngineVersion;
    }

    @Nullable
    public String getLanguageVersion() {
        return this.myLanguageVersion;
    }

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        this.mySessionId = StringUtil.notNullize((String)packet.getAttributeValue(IDE_KEY_ATTR));
        this.myCloudId = StringUtil.notNullize((String)DbgpUtil.getXdebugAttribute(CLOUDID_ATTR, packet));
        this.myFileUri = URLUtil.decode((String)packet.getAttributeValue(FILE_URI_ATTR));
        this.myLanguageVersion = DbgpUtil.getXdebugAttribute("language_version", packet);
        Element element = packet.getChild(ENGINE_ELEMENT, DbgpUtil.DBGP_NAMESPACE);
        if (element == null) {
            throw new IOException("Cannot find <engine> child");
        }
        this.myEngineVersion = element.getAttributeValue("version");
        return this;
    }

    public String toString() {
        return "idekey='" + this.mySessionId + "', fileuri='" + this.myFileUri + "', language_version='" + this.myLanguageVersion + "', engine='" + this.myLanguageVersion + "'";
    }
}

