/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.debug.connection.Request;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpOutputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.FeatureSetRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DbgpRequest<R extends DbgpResponse>
extends DbgpOutputMessage
implements Request<R> {
    private static final String DATA_FORMAT = " -- {0}";
    private static final String ID_PARAMETER = "i";
    public static final String RUN_REQUEST = "run";
    public static final String DETACH_REQUEST = "detach";
    public static final String STEP_INTO_REQUEST = "step_into";
    public static final String STEP_OUT_REQUEST = "step_out";
    public static final String STEP_OVER_REQUEST = "step_over";
    public static final String STOP_REQUEST = "stop";
    public static final String STATUS_REQUEST = "status";
    public static final String EVAL_REQUEST = "eval";
    public static final String GET_STACK_REQUEST = "stack_get";
    public static final String CONTEXT_NAMES_REQUEST = "context_names";
    public static final String PROPERTY_VALUE_REQUEST = "property_value";
    public static final String BREAKPOINT_REMOVE_REQUEST = "breakpoint_remove";
    protected static final String BREAK_REQUEST = "break";
    public static final String BREAKPOINT_SET_REQUEST = "breakpoint_set";
    public static final String BREAKPOINT_GET_REQUEST = "breakpoint_get";
    public static final String FEATURE_SET_REQUEST = "feature_set";
    public static final String PROPERTY_SET_REQUEST = "property_set";
    public static final String CONTEXT_GET_REQUEST = "context_get";
    public static final String FEATURE_GET_REQUEST = "feature_get";
    public static final String STDOUT_REQUEST = "stdout";
    public static final String PROPERTY_GET_REQUEST = "property_get";
    public static final String STDERR_REQUEST = "stderr";
    public static final String CLOUD_INIT_REQUEST = "cloudinit";
    public static final String CLOUD_STOP_REQUEST = "cloudstop";
    public static final Set<String> STATUS_RESPONSE_SET = ContainerUtil.set((Object[])new String[]{"run", "detach", "step_into", "step_out", "step_over", "stop", "status"});
    public static final Set<String> SET_RESPONSE_SET = ContainerUtil.set((Object[])new String[]{"property_set", "feature_set", "stderr", "stdout"});
    protected static final String PARAMETER_NAME = "n";
    protected static final String PARAMETER_REDIRECT_TO = "c";
    protected static final String PARAMETER_VALUE = "v";
    protected static final String PARAMETER_DEPTH = "d";
    protected static final String PARAMETER_CONTEXT_ID = "c";
    protected static final String PARAMETER_PAGE = "p";
    protected static final String PARAMETER_BREAKPOINT_ID = "d";
    protected static final String PARAMETER_LENGTH = "l";
    protected static final String PARAMETER_M = "m";
    public static final int NO_STACK_DEPTH = -1;
    public static final int NO_CONTEXT_ID = -1;
    public static final int NO_PAGE = -1;
    public static final int CURRENT_STACK_DEPTH = 0;
    private int myTimeout;
    private Runnable myOnTimeout;
    private int myRequestId;
    private String myData;

    @Override
    public int getRequestId() {
        return this.myRequestId;
    }

    @Override
    public void setRequestId(int requestId) {
        this.myRequestId = requestId;
    }

    @Override
    public int getTimeout() {
        return this.myTimeout;
    }

    @Override
    public Runnable getOnTimeout() {
        return this.myOnTimeout;
    }

    @Override
    public void setTimeout(int timeout, @NotNull Runnable onTimeout) {
        if (onTimeout == null) {
            DbgpRequest.$$$reportNull$$$0(0);
        }
        this.myTimeout = timeout;
        this.myOnTimeout = onTimeout;
    }

    protected DbgpRequest(@NotNull String name) {
        if (name == null) {
            DbgpRequest.$$$reportNull$$$0(1);
        }
        super(name);
        this.myTimeout = -1;
        this.myRequestId = -1;
    }

    public DbgpRequest<R> setData(@NotNull String data, @NotNull String encoding) {
        if (data == null) {
            DbgpRequest.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            DbgpRequest.$$$reportNull$$$0(3);
        }
        try {
            this.myData = DbgpUtil.encode(data, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public final void serialize(Writer out) throws IOException {
        out.write(this.myName);
        DbgpRequest.writeOption(out, ID_PARAMETER, String.valueOf(this.getRequestId()));
        for (Pair parameter : this.myParameters) {
            DbgpRequest.writeOption(out, (String)parameter.getFirst(), (String)parameter.getSecond());
        }
        if (this.myData != null) {
            out.write(MessageFormat.format(DATA_FORMAT, this.myData));
        }
    }

    @NotNull
    public static FeatureSetRequest setMaxDepth(int value) {
        return new FeatureSetRequest("max_depth", value);
    }

    @NotNull
    public static FeatureSetRequest setExtendedProperties() {
        return new FeatureSetRequest("extended_properties", 1);
    }

    @NotNull
    public static FeatureSetRequest setResolvedBreakpoints() {
        return new FeatureSetRequest("resolved_breakpoints", 1);
    }

    @NotNull
    public static FeatureSetRequest setNotifications() {
        return new FeatureSetRequest("notify_ok", 1);
    }

    @NotNull
    public static FeatureSetRequest setDefaultMaxDepth() {
        return DbgpRequest.setMaxDepth(3);
    }

    @NotNull
    public static FeatureSetRequest setShowHidden(boolean value) {
        return new FeatureSetRequest("show_hidden", value);
    }

    @NotNull
    public static FeatureSetRequest setMultipleSessions(boolean value) {
        return new FeatureSetRequest("multiple_sessions", value);
    }

    @NotNull
    public static FeatureSetRequest setMaxChildren(int value) {
        return new FeatureSetRequest("max_children", value);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.myName);
        out.append(" -").append(ID_PARAMETER).append(" ").append(this.getRequestId());
        for (Pair parameter : this.myParameters) {
            out.append(" -").append((String)parameter.getFirst()).append(" ").append((String)parameter.getSecond());
        }
        if (this.myData != null) {
            out.append(MessageFormat.format(DATA_FORMAT, this.myData));
        }
        return out.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTimeout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/messages/DbgpRequest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimeout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

