/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpBreakpointPosition;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DbgpBreakpoint {
    private String myBreakpointId;
    private String myState;
    private boolean myResolved;
    private DbgpBreakpointPosition myPosition;

    public String getBreakpointId() {
        return this.myBreakpointId;
    }

    public String getState() {
        return this.myState;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public String getType() {
        return this.myPosition.getType();
    }

    public String getPresentation() {
        return this.myPosition.getPresentation();
    }

    public DbgpBreakpointPosition getPosition() {
        return this.myPosition;
    }

    @NotNull
    public DbgpBreakpoint deserialize(@NotNull Element breakpoint) throws IOException {
        if (breakpoint == null) {
            DbgpBreakpoint.$$$reportNull$$$0(0);
        }
        this.myBreakpointId = breakpoint.getAttributeValue("id");
        this.myState = breakpoint.getAttributeValue("state");
        this.myResolved = StringUtil.equals((CharSequence)breakpoint.getAttributeValue("resolved"), (CharSequence)"resolved");
        String type = breakpoint.getAttributeValue("type");
        if (StringUtil.equals((CharSequence)type, (CharSequence)"line")) {
            String filePath = breakpoint.getAttributeValue("filename");
            int lineno = StringUtil.parseInt((String)breakpoint.getAttributeValue("lineno"), (int)0);
            this.myPosition = new DbgpBreakpointPosition.DbgpLineBreakpointPosition(filePath, lineno);
        } else if (StringUtil.equals((CharSequence)type, (CharSequence)"call") || StringUtil.equals((CharSequence)type, (CharSequence)"return")) {
            String presentation = StringUtil.notNullize((String)breakpoint.getAttributeValue("function"), (String)"<undefined>");
            this.myPosition = new DbgpBreakpointPosition(type, presentation);
        } else if (StringUtil.equals((CharSequence)type, (CharSequence)"exception")) {
            String presentation = StringUtil.notNullize((String)breakpoint.getAttributeValue("exception"), (String)"<undefined>");
            this.myPosition = new DbgpBreakpointPosition(type, presentation);
        } else {
            this.myPosition = new DbgpBreakpointPosition(type, null);
        }
        DbgpBreakpoint dbgpBreakpoint = this;
        if (dbgpBreakpoint == null) {
            DbgpBreakpoint.$$$reportNull$$$0(1);
        }
        return dbgpBreakpoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/messages/DbgpBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/messages/DbgpBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

