/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.connection;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.debug.PhpDebugSessionLogger;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.FeatureSetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StdoutRedirectRequest;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class XdebugConnectionConfigurator {
    protected static final Logger LOG = Logger.getInstance(XdebugConnectionConfigurator.class);
    public static final String CONFIG_SCRIPT = "ini_get('xdebug.coverage_enable').';'.ini_get('xdebug.profiler_enable').';'.ini_get('xdebug.remote_autostart').';'.ini_get('xdebug.remote_connect_back').';'.ini_get('xdebug.remote_mode')";
    private final List<FeatureSetRequest> myConfigurationCommand;
    private final boolean myWithOutputRedirect;
    private static final List<FeatureSetRequest> DEFAULT_PARAMETERS;
    private static final FeatureSetRequest RESOLVE_BREAKPOINTS;
    private static final FeatureSetRequest REDIRECT;

    private XdebugConnectionConfigurator(@NotNull List<FeatureSetRequest> configurationCommand, boolean withOutputRedirect) {
        if (configurationCommand == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(0);
        }
        this.myConfigurationCommand = configurationCommand;
        this.myWithOutputRedirect = withOutputRedirect;
    }

    @NotNull
    public static XdebugConnectionConfigurator create(boolean withRedirect, boolean withResolveBreakpoints) {
        ArrayList<FeatureSetRequest> configurations = new ArrayList<FeatureSetRequest>(DEFAULT_PARAMETERS);
        if (withRedirect) {
            configurations.add(REDIRECT);
        }
        if (withResolveBreakpoints) {
            configurations.add(RESOLVE_BREAKPOINTS);
        }
        return new XdebugConnectionConfigurator(configurations, withRedirect);
    }

    public void configure(@NotNull XdebugConnection connection, @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(1);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(2);
        }
        this.evalConfig(connection);
        if (this.myConfigurationCommand.isEmpty()) {
            this.onCompleted(connection, onConfigured);
        } else {
            this.setFeature(connection, 0, onConfigured);
        }
    }

    protected void evalConfig(final @NotNull XdebugConnection connection) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(3);
        }
        if (PhpDebugSessionLogger.getInstance().isEnabled()) {
            connection.evalString(CONFIG_SCRIPT, "UTF-8", new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    String[] configurations;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((configurations = result.split(";")).length == 5) {
                        String mode = configurations[4];
                        FeatureUsageData data = new FeatureUsageData().addData("coverage", StringUtil.equals((CharSequence)configurations[0], (CharSequence)"1")).addData("profiler", StringUtil.equals((CharSequence)configurations[1], (CharSequence)"1")).addData("autostart", StringUtil.equals((CharSequence)configurations[2], (CharSequence)"1")).addData("connect_back", StringUtil.equals((CharSequence)configurations[3], (CharSequence)"1")).addData("mode", StringUtil.equals((CharSequence)mode, (CharSequence)"req") || StringUtil.equals((CharSequence)mode, (CharSequence)"jit") ? mode : "unknown");
                        PhpDebugSessionLogger.getInstance().logDebugConfig(connection, data);
                    }
                }

                @Override
                public void errorOccurred() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator$1", "evaluated"));
                }
            });
        }
    }

    private void setFeature(final @NotNull XdebugConnection connection, final int index, final @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(4);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(5);
        }
        final FeatureSetRequest request = this.myConfigurationCommand.get(index);
        connection.send(request, new DbgpResponseHandler<SetResponse>(){

            @Override
            public void onSuccessResponse(@NotNull SetResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.onResponse();
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.info("Xdebug protocol doesn't support command: '" + request + "'");
                this.onResponse();
            }

            private void onResponse() {
                if (index < XdebugConnectionConfigurator.this.myConfigurationCommand.size() - 1) {
                    XdebugConnectionConfigurator.this.setFeature(connection, index + 1, onConfigured);
                } else {
                    XdebugConnectionConfigurator.this.onCompleted(connection, onConfigured);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onCompleted(@NotNull XdebugConnection connection, final @NotNull Runnable onConfigured) {
        if (connection == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(6);
        }
        if (onConfigured == null) {
            XdebugConnectionConfigurator.$$$reportNull$$$0(7);
        }
        if (this.myWithOutputRedirect) {
            connection.send(new StdoutRedirectRequest(), new DbgpResponseHandler<SetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull SetResponse message) {
                    if (message == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!message.isSuccess()) {
                        LOG.info("Cannot redirect stdout");
                    }
                    onConfigured.run();
                }

                @Override
                public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                    if (errorResponse == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    LOG.info("Cannot redirect stdout: " + errorResponse.getErrorMessage());
                    onConfigured.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorResponse";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            onConfigured.run();
        }
    }

    static {
        RESOLVE_BREAKPOINTS = DbgpRequest.setResolvedBreakpoints();
        REDIRECT = DbgpRequest.setNotifications();
        DEFAULT_PARAMETERS = ContainerUtil.immutableList((Object[])new FeatureSetRequest[]{DbgpRequest.setShowHidden(true), DbgpRequest.setMaxDepth(1), DbgpRequest.setMaxChildren(100), DbgpRequest.setExtendedProperties()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationCommand";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onConfigured";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnectionConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evalConfig";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setFeature";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onCompleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

