/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.connection.PhpDebugSessionId;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudConnection;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudConnectionsSocket;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.connection.XdebugServer;
import com.jetbrains.php.util.connection.ConnectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;

public class XdebugCloudServer
extends XdebugServer {
    private static final String DESCRIPTIVE_NAME = "Xdebug Cloud Server";
    private final Semaphore myConnectedSessionSemaphore;

    public XdebugCloudServer(@NotNull String cloudId, @NotNull String cloudHost, int cloudPort, @NotNull Disposable parentDisposable) {
        if (cloudId == null) {
            XdebugCloudServer.$$$reportNull$$$0(0);
        }
        if (cloudHost == null) {
            XdebugCloudServer.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            XdebugCloudServer.$$$reportNull$$$0(2);
        }
        super(new XdebugCloudConnectionsSocket(cloudId, cloudHost, cloudPort), parentDisposable);
        this.myConnectedSessionSemaphore = new Semaphore(1);
    }

    @Override
    @NotNull
    protected Socket waitForDebugSessionConnection() throws IOException {
        Socket socket;
        try {
            this.myConnectedSessionSemaphore.acquire();
            socket = super.waitForDebugSessionConnection();
        }
        catch (InterruptedException e) {
            throw new IOException(PhpBundle.message("xdebug.cloud.cannot.open.new.debug.connection", new Object[0]));
        }
        if (socket == null) {
            XdebugCloudServer.$$$reportNull$$$0(3);
        }
        return socket;
    }

    @Override
    protected void closeDebugSessionConnection(@NotNull Socket socket) {
        if (socket == null) {
            XdebugCloudServer.$$$reportNull$$$0(4);
        }
        this.myConnectedSessionSemaphore.release();
    }

    @Override
    protected XdebugConnection createConnection(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        if (inputStream == null) {
            XdebugCloudServer.$$$reportNull$$$0(5);
        }
        if (outputStream == null) {
            XdebugCloudServer.$$$reportNull$$$0(6);
        }
        return new XdebugCloudConnection(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PhpDebugSessionId registerSessionHandler(boolean permanent, @NotNull ConnectionHandler<XdebugConnection> handler) throws ExecutionException {
        if (handler == null) {
            XdebugCloudServer.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        String sessionIdStr = this.generateNewSessionId();
        this.registerSessionHandler(sessionIdStr, true, handler);
        PhpDebugSessionId phpDebugSessionId = new PhpDebugSessionId(sessionIdStr);
        // MONITOREXIT : object
        if (phpDebugSessionId != null) return phpDebugSessionId;
        XdebugCloudServer.$$$reportNull$$$0(8);
        return phpDebugSessionId;
    }

    @Override
    @NotNull
    public String getDescriptiveName() {
        return DESCRIPTIVE_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudServer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "waitForDebugSessionConnection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerSessionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "closeDebugSessionConnection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConnection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerSessionHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

