/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud.connection;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudInitializer;
import com.jetbrains.php.util.connection.PhpDebugConnectionException;
import com.jetbrains.php.util.connection.PhpDebugSocketDescriptor;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionsSocket;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class XdebugCloudConnectionsSocket
implements PhpIncomingDebugConnectionsSocket {
    private static final Logger LOG = Logger.getInstance(XdebugCloudConnectionsSocket.class);
    private final PhpDebugSocketDescriptor myDescriptor;
    private final XdebugCloudInitializer myXdebugCloudInitializer;
    private SSLSocket mySSLSocket;

    XdebugCloudConnectionsSocket(@NotNull String cloudId, @NotNull String cloudHost, int cloudPort) {
        if (cloudId == null) {
            XdebugCloudConnectionsSocket.$$$reportNull$$$0(0);
        }
        if (cloudHost == null) {
            XdebugCloudConnectionsSocket.$$$reportNull$$$0(1);
        }
        this.mySSLSocket = null;
        this.myDescriptor = new PhpDebugSocketDescriptor(cloudId, cloudHost, cloudPort);
        this.myXdebugCloudInitializer = new XdebugCloudInitializer(cloudId, cloudHost, cloudPort);
    }

    @Override
    public ThrowableRunnable<PhpDebugConnectionException> openConnection(int port) {
        return () -> {
            try {
                long start = System.currentTimeMillis();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Start initializing connection to Xdebug Cloud");
                }
                this.mySSLSocket = this.myXdebugCloudInitializer.registerUserId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Initializing connection to Xdebug Cloud took " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (UnknownHostException e) {
                throw new PhpDebugConnectionException(PhpBundle.message("xdebug.cloud.cannot.connect.unknown.host", e.getMessage()), e);
            }
            catch (IOException e) {
                throw new PhpDebugConnectionException(e.getMessage(), e);
            }
        };
    }

    @Override
    public ThrowableRunnable<PhpDebugConnectionException> closeConnection() {
        SSLSocket socket = this.mySSLSocket;
        this.mySSLSocket = null;
        return () -> {
            try {
                this.myXdebugCloudInitializer.unregisterUserId();
                socket.close();
            }
            catch (IOException e) {
                throw new PhpDebugConnectionException(e.getMessage(), e);
            }
        };
    }

    @Override
    public boolean isConnectionOpened() {
        return this.mySSLSocket != null && !this.mySSLSocket.isClosed() && !this.mySSLSocket.isInputShutdown();
    }

    @Override
    public Socket waitForDebugSessionConnection() throws IOException {
        if (this.mySSLSocket == null) {
            throw new IOException();
        }
        return this.mySSLSocket;
    }

    @Override
    @NotNull
    public PhpDebugSocketDescriptor getDescriptor() {
        PhpDebugSocketDescriptor phpDebugSocketDescriptor = this.myDescriptor;
        if (phpDebugSocketDescriptor == null) {
            XdebugCloudConnectionsSocket.$$$reportNull$$$0(2);
        }
        return phpDebugSocketDescriptor;
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName() {
        String string = PhpBundle.message("xdebug.initializing.connection.xdebug.cloud", new Object[0]);
        if (string == null) {
            XdebugCloudConnectionsSocket.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudHost";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudConnectionsSocket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudConnectionsSocket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

