/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudServer;
import com.jetbrains.php.util.connection.PhpConnectionInitCallback;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugCloudConnectionManager
implements ServerConnectionListener<XdebugCloudServer>,
Disposable {
    private static final Logger LOG = Logger.getInstance(XdebugCloudConnectionManager.class);
    private final ArrayList<XdebugCloudServer> myServerConnections = new ArrayList();
    private final Object myLock = new Object();

    public static XdebugCloudConnectionManager getInstance() {
        return (XdebugCloudConnectionManager)ApplicationManager.getApplication().getService(XdebugCloudConnectionManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public XdebugCloudServer start(@Nullable String cloudId, @Nullable String host, int port, @NotNull PhpConnectionInitCallback callback) throws ExecutionException {
        XdebugCloudServer serverConnection;
        String error;
        if (callback == null) {
            XdebugCloudConnectionManager.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)(error = XdebugCloudConnectionManager.validateConfig(cloudId, host, port)))) {
            throw new ExecutionException(error);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        if (!$assertionsDisabled) {
            if (cloudId == null) throw new AssertionError();
            if (host == null) {
                throw new AssertionError();
            }
        }
        LOG.info("Connect to Xdebug Cloud: " + host + ":" + port);
        Iterator<XdebugCloudServer> iterator = this.myServerConnections.iterator();
        do {
            if (iterator.hasNext()) continue;
            XdebugCloudServer serverConnection2 = this.createServer(cloudId, host, port);
            this.myServerConnections.add(serverConnection2);
            serverConnection2.addListener(this);
            serverConnection2.startListening(port, callback);
            XdebugCloudServer xdebugCloudServer = serverConnection2;
            // MONITOREXIT : object
            if (xdebugCloudServer != null) return xdebugCloudServer;
            XdebugCloudConnectionManager.$$$reportNull$$$0(2);
            return xdebugCloudServer;
        } while (!(serverConnection = iterator.next()).getDescriptor().isEqual(cloudId, host, port));
        XdebugCloudServer xdebugCloudServer = serverConnection;
        // MONITOREXIT : object
        if (xdebugCloudServer != null) return xdebugCloudServer;
        XdebugCloudConnectionManager.$$$reportNull$$$0(1);
        return xdebugCloudServer;
    }

    @Nls
    @Nullable
    private static String validateConfig(@Nullable String cloudId, @Nullable String baseHost, int port) {
        if (StringUtil.isEmpty((String)cloudId)) {
            return PhpBundle.message("xdebug.cloud.validation.cloud.id.not.defined", new Object[0]);
        }
        if (StringUtil.isEmpty((String)baseHost)) {
            return PhpBundle.message("xdebug.cloud.validation.host.not.defined", new Object[0]);
        }
        if (port < 0) {
            return PhpBundle.message("xdebug.cloud.validation.port.invalid", new Object[0]);
        }
        return null;
    }

    @NotNull
    protected XdebugCloudServer createServer(@NotNull String cloudId, @NotNull String host, int port) {
        if (cloudId == null) {
            XdebugCloudConnectionManager.$$$reportNull$$$0(3);
        }
        if (host == null) {
            XdebugCloudConnectionManager.$$$reportNull$$$0(4);
        }
        return new XdebugCloudServer(cloudId, host, port, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(@NotNull XdebugCloudServer connection, ServerConnectionStatus status) {
        if (connection == null) {
            XdebugCloudConnectionManager.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (status == ServerConnectionStatus.STOPPED) {
                connection.removeListener(this);
                this.myServerConnections.remove(connection);
            }
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudConnectionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudConnectionManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createServer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "statusChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

