/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpStackFrame;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XdebugAddMethodToSkipListAction
extends ToggleAction {
    public static final String ID = "XdebugAddMethodToSkipListAction";
    public static final String SPECIAL_FUNCTION_PREFIX = "{";
    PhpDebugProcess<XdebugConnection> myProcess;

    public XdebugAddMethodToSkipListAction() {
        super(PhpBundle.messagePointer("XdebugAddMethodToSkipListToggleAction.text", new Object[0]), Presentation.NULL_STRING, PhpIcons.ADD_TO_SKIP_LIST);
    }

    public PhpDebugProcess<XdebugConnection> getProcess() {
        return this.myProcess;
    }

    public void setProcess(PhpDebugProcess<XdebugConnection> process) {
        this.myProcess = process;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            XdebugAddMethodToSkipListAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            XdebugAddMethodToSkipListAction.$$$reportNull$$$0(1);
        }
        if (this.myProcess != null) {
            XdebugConnection connection = this.myProcess.getConnection();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project != null) {
                final PhpStepFiltersConfiguration.State configuration = PhpStepFiltersConfiguration.getInstance(project).getState();
                if (state && connection != null) {
                    connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

                        @Override
                        public void onSuccessResponse(@NotNull StackGetResponse message) {
                            String functionName;
                            if (message == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            assert (message.getStackFrames().size() > 0);
                            DbgpStackFrame dbgpStackFrame = message.getStackFrames().get(0);
                            ArrayList<String> skippedFunctions = new ArrayList<String>(configuration.getSkippedFunctions());
                            if (!skippedFunctions.contains(functionName = dbgpStackFrame.getFunctionName()) && !functionName.startsWith(XdebugAddMethodToSkipListAction.SPECIAL_FUNCTION_PREFIX)) {
                                skippedFunctions.add(functionName);
                                PhpDebugUtil.NOTIFICATION_GROUP.createNotification(PhpBundle.message("debug.function.was.added.to.skip.list", functionName), MessageType.WARNING).notify(XdebugAddMethodToSkipListAction.this.myProcess.getSession().getProject());
                            }
                            configuration.setSkippedFunctions(skippedFunctions);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/actions/XdebugAddMethodToSkipListAction$1", "onSuccessResponse"));
                        }
                    });
                    this.myProcess.startStepOut(this.myProcess.getSession().getSuspendContext());
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/actions/XdebugAddMethodToSkipListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

