/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.factories.Xdebug2ConfigurationFactory;
import com.jetbrains.php.debug.validation.configuration.factories.Xdebug3ConfigurationFactory;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class XdebugConfiguration
extends PhpDebugConfiguration {
    protected static final String XDEBUG_REMOTE_MODE_URL = "https://xdebug.org/docs/all_settings#remote_mode";
    protected static final String XDEBUG_REMOTE_CONNECT_BACK_URL = "https://xdebug.org/docs/all_settings#remote_connect_back";
    protected static final String DBGP = "dbgp";
    private static final int MIN_PORT = 1024;
    protected final String myVersion;
    protected final boolean myIsLoadedByZendExtension;
    protected final String myProtocol;
    protected final String myHost;
    protected final String myPort;
    protected final String myLog;
    protected final boolean myIsConnectBack;

    protected XdebugConfiguration(String version, boolean isLoadedByZendExtension, String protocol, String host, String port, String log, boolean isConnectBack) {
        this.myVersion = version;
        this.myIsLoadedByZendExtension = isLoadedByZendExtension;
        this.myProtocol = protocol;
        this.myHost = host;
        this.myPort = port;
        this.myLog = log;
        this.myIsConnectBack = isConnectBack;
    }

    @NotNull
    public static XdebugConfiguration parseConfiguration(@NotNull Project project, @NotNull Attributes attributes) {
        if (project == null) {
            XdebugConfiguration.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            XdebugConfiguration.$$$reportNull$$$0(1);
        }
        if (XdebugUtil.isAtLeastXdebug3(attributes.getValue("version"))) {
            XdebugConfiguration xdebugConfiguration = new Xdebug3ConfigurationFactory(project).parseConfiguration(attributes);
            if (xdebugConfiguration == null) {
                XdebugConfiguration.$$$reportNull$$$0(2);
            }
            return xdebugConfiguration;
        }
        XdebugConfiguration xdebugConfiguration = new Xdebug2ConfigurationFactory().parseConfiguration(attributes);
        if (xdebugConfiguration == null) {
            XdebugConfiguration.$$$reportNull$$$0(3);
        }
        return xdebugConfiguration;
    }

    protected abstract PhpInfoValidationMessage onWrongHostConfigurationAsLocalhost(@Nullable String var1);

    protected abstract PhpInfoValidationMessage onSuccessfulHostConfiguration();

    protected abstract PhpInfoValidationMessage onWrongPortConfiguration(String var1);

    protected abstract PhpInfoValidationMessage onConnectBackEnabled();

    protected void validateHost(@NotNull List<PhpInfoValidationMessage> messages, @NotNull String serverHost, @Nullable String remoteAddr) {
        if (messages == null) {
            XdebugConfiguration.$$$reportNull$$$0(4);
        }
        if (serverHost == null) {
            XdebugConfiguration.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)this.myHost)) {
            boolean isLocalServer;
            boolean bl = isLocalServer = XdebugConfiguration.isLocalhost(serverHost) || XdebugConfiguration.isLocalhost(remoteAddr);
            if (!isLocalServer && XdebugConfiguration.isLocalhost(this.myHost)) {
                messages.add(this.onWrongHostConfigurationAsLocalhost(remoteAddr));
            } else {
                messages.add(this.onSuccessfulHostConfiguration());
            }
        }
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr) {
        if (messages == null) {
            XdebugConfiguration.$$$reportNull$$$0(6);
        }
        if (serverHost == null) {
            XdebugConfiguration.$$$reportNull$$$0(7);
        }
        String name = PhpDebugUtil.getDebuggerNameById("php.debugger.XDebug") + (String)(this.myVersion == null ? "" : " " + this.myVersion);
        messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.loaded.debugger.extension", name), null));
        if (!this.myIsLoadedByZendExtension) {
            String description = XdebugConfiguration.getDescription("php.web.server.validation.xdebug.zend.extension.load.description", null);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.zend.extension.load", new Object[0]), description));
        }
        this.validateHost(messages, serverHost, remoteAddr);
        try {
            int port = Integer.valueOf(this.myPort);
            if (state != null && !state.getXDebugDebugPorts().contains(port)) {
                String portInIde = String.valueOf(state.getXDebugDebugPort());
                messages.add(this.onWrongPortConfiguration(portInIde));
            } else if (port < 1024) {
                String description = PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo.description", new Object[0]);
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo", this.myPort), description));
            } else {
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.port", this.myPort), null));
            }
        }
        catch (Exception e) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.wrong.port.format", this.myPort), null));
        }
        if (this.myIsConnectBack) {
            messages.add(this.onConnectBackEnabled());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/XdebugConfiguration";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/XdebugConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseConfiguration";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateHost";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

