/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.XdebugConfiguration;
import com.jetbrains.php.debug.xdebug.cloud.XdebugCloudSettings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xdebug3Configuration
extends XdebugConfiguration {
    private static final String XDEBUG3_DEBUG_MODE = "https://3.xdebug.org/docs/all_settings#mode";
    private static final String XDEBUG3_REMOTE_HOST_URL = "https://3.xdebug.org/docs/all_settings#client_host";
    private static final String XDEBUG3_REMOTE_PORT_URL = "https://3.xdebug.org/docs/all_settings#client_port";
    private static final String XDEBUG3_START_WITH_REQUEST = "https://3.xdebug.org/docs/all_settings#start_with_request";
    private static final String XDEBUG3_START_UPON_ERROR = "https://3.xdebug.org/docs/all_settings#start_upon_error";
    private static final String XDEBUG3_CLIENT_DISCOVER_HEADER = "https://3.xdebug.org/docs/all_settings#client_discovery_header";
    private static final String XDEBUG3_CLIENT_DISCOVER_HOST = "https://3.xdebug.org/docs/all_settings#discover_client_host";
    private final String myDebugModes;
    private final String myStartWithRequest;
    private final String myStartUponError;
    private final boolean myIsDiscoverClientHost;
    private final String myClientDiscoveryHeader;
    private final String myCloudUserId;
    private final Project myProject;

    public Xdebug3Configuration(@NotNull Project project, String version, boolean isLoadedByZendExtension, String protocol, String host, String port, String log, boolean isConnectBack, String debugModes, String startWithRequest, String startUponError, boolean idDiscoverClientHost, String clientDiscoveryHeader, String cloudUserId) {
        if (project == null) {
            Xdebug3Configuration.$$$reportNull$$$0(0);
        }
        super(version, isLoadedByZendExtension, protocol, host, port, log, isConnectBack);
        this.myDebugModes = debugModes;
        this.myStartWithRequest = startWithRequest;
        this.myStartUponError = startUponError;
        this.myIsDiscoverClientHost = idDiscoverClientHost;
        this.myClientDiscoveryHeader = clientDiscoveryHeader;
        this.myCloudUserId = cloudUserId;
        this.myProject = project;
    }

    @Override
    protected PhpInfoValidationMessage onWrongHostConfigurationAsLocalhost(@Nullable String remoteAddr) {
        Object details = PhpBundle.message("php.web.server.validation.xdebug.debugger.host.description", new Object[0]);
        if (StringUtil.isNotEmpty((String)remoteAddr)) {
            details = (String)details + PhpBundle.message("php.web.server.validation.xdebug.debugger.host.remote.addr", "xdebug.client_host", remoteAddr);
        }
        String description = Xdebug3Configuration.getDescriptionByMessage((String)details, XDEBUG3_REMOTE_HOST_URL);
        return PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.debugger.localhost", this.myHost), description);
    }

    @Override
    protected PhpInfoValidationMessage onSuccessfulHostConfiguration() {
        String description = Xdebug3Configuration.getDescription("php.web.server.validation.xdebug.debugger.host.description", XDEBUG3_REMOTE_HOST_URL);
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.debugger.host", this.myHost), description);
    }

    @Override
    protected PhpInfoValidationMessage onWrongPortConfiguration(String portInIde) {
        String message = PhpBundle.message("php.web.server.validation.xdebug.wrong.port", this.myPort, portInIde);
        String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.wrong.port.description", "xdebug.client_port"), XDEBUG3_REMOTE_PORT_URL);
        return PhpInfoValidationMessage.error(message, description);
    }

    @Override
    protected PhpInfoValidationMessage onConnectBackEnabled() {
        String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.option.is.ignored.description", "xdebug.client_host"), "https://xdebug.org/docs/all_settings#remote_connect_back");
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.option.is.enabled", "Remote connect back"), description);
    }

    protected PhpInfoValidationMessage onLogEnabled() {
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.log", "Log", this.myLog), null);
    }

    @Override
    protected void validateHost(@NotNull List<PhpInfoValidationMessage> messages, @NotNull String serverHost, @Nullable String remoteAddr) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(1);
        }
        if (serverHost == null) {
            Xdebug3Configuration.$$$reportNull$$$0(2);
        }
        if (this.myIsDiscoverClientHost && StringUtil.isNotEmpty((String)this.myClientDiscoveryHeader)) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.with.discover.header", this.myClientDiscoveryHeader), XDEBUG3_CLIENT_DISCOVER_HEADER);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.message", new Object[0]), description));
        } else if (this.myIsDiscoverClientHost) {
            String description = Xdebug3Configuration.getDescription("php.web.server.validation.xdebug3.discover.client", XDEBUG3_CLIENT_DISCOVER_HOST);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.discover.client.message", new Object[0]), description));
        }
        super.validateHost(messages, serverHost, remoteAddr);
    }

    private List<DebugMode> parseDebugModes(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(3);
        }
        ArrayList<DebugMode> debugModes = new ArrayList<DebugMode>();
        for (String s : this.myDebugModes.split(",")) {
            try {
                debugModes.add(DebugMode.parse(s.trim()));
            }
            catch (NotMatchedException e) {
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", DebugMode.getOptionName(), this.myDebugModes), null));
            }
        }
        return debugModes;
    }

    private StartWithRequestMode parseStartWithRequest(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(4);
        }
        StartWithRequestMode startWithRequestMode = null;
        try {
            startWithRequestMode = StartWithRequestMode.parse(this.myStartWithRequest);
        }
        catch (NotMatchedException e) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.option.is.not.enabled.description", StartWithRequestMode.getOptionName()), XDEBUG3_START_WITH_REQUEST);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", StartWithRequestMode.getOptionName(), this.myStartWithRequest), description));
        }
        return startWithRequestMode;
    }

    private StartUponErrorMode parseStartUponError(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(5);
        }
        StartUponErrorMode startUponErrorMode = null;
        try {
            startUponErrorMode = StartUponErrorMode.parse(this.myStartUponError);
        }
        catch (NotMatchedException e) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.option.is.not.enabled.description", StartUponErrorMode.getOptionName()), XDEBUG3_START_UPON_ERROR);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.option.in.invalid.mode", StartUponErrorMode.getOptionName(), this.myStartUponError), description));
        }
        return startUponErrorMode;
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr) {
        String description;
        StartUponErrorMode startUponErrorMode;
        StartWithRequestMode startWithRequestMode;
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(6);
        }
        if (serverHost == null) {
            Xdebug3Configuration.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)this.myLog)) {
            messages.add(this.onLogEnabled());
        }
        if (!StringUtil.isEmpty((String)this.myCloudUserId) || XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            this.doValidationOfXdebugCloud(state, messages);
            return;
        }
        super.validate(messages, state, serverHost, remoteAddr);
        List<DebugMode> debugModes = this.parseDebugModes(messages);
        boolean isDebugSwitchedOn = debugModes.contains((Object)DebugMode.DEBUG);
        if (!isDebugSwitchedOn) {
            String description2 = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable.description", "xdebug.mode=debug"), XDEBUG3_DEBUG_MODE);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable", new Object[0]), description2));
        }
        if ((startWithRequestMode = this.parseStartWithRequest(messages)) != null) {
            String description3 = Xdebug3Configuration.getDescription("php.web.server.validation.xdebug3.start.with.request.description", XDEBUG3_START_WITH_REQUEST);
            String message = PhpBundle.message("php.web.server.validation.xdebug3.option.is.enabled.message", StartWithRequestMode.getOptionName(), this.myStartWithRequest);
            messages.add(PhpInfoValidationMessage.info(message, description3));
        }
        if ((startUponErrorMode = this.parseStartUponError(messages)) != null) {
            description = Xdebug3Configuration.getDescription("php.web.server.validation.xdebug3.start.upon.error.description", XDEBUG3_START_UPON_ERROR);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.option.is.enabled.message", StartUponErrorMode.getOptionName(), this.myStartUponError), description));
        }
        if (isDebugSwitchedOn && startWithRequestMode == StartWithRequestMode.TRIGGER) {
            description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.description", "req"), "https://xdebug.org/docs/all_settings#remote_mode");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.message", "req"), description));
        }
        if (isDebugSwitchedOn && startUponErrorMode == StartUponErrorMode.YES) {
            description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.description", "jit"), "https://xdebug.org/docs/all_settings#remote_mode");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.remote.mode.emulation.message", "jit"), description));
        }
    }

    private void doValidationOfXdebugCloud(@Nullable PhpProjectDebugConfiguration.State state, @NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            Xdebug3Configuration.$$$reportNull$$$0(8);
        }
        if (state != null && !state.isXDebugCanAcceptExternalConnections()) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.doesnt.accept.connections.message", new Object[0]), null));
        }
        if (!StringUtil.isEmpty((String)this.myCloudUserId) && !XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.disabled.message", new Object[0]), null));
        } else if (StringUtil.isEmpty((String)this.myCloudUserId) && XdebugCloudSettings.getInstance(this.myProject).getState().isEnabled()) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable.description", "xdebug.cloud_id=<YourCloudID>"), null);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.php.ini.xdebug.disabled.message", new Object[0]), description));
        }
        String ideCloudId = XdebugCloudSettings.getInstance(this.myProject).getState().getCloudId();
        if (!this.myCloudUserId.equals(ideCloudId)) {
            String description = Xdebug3Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.wrong.cloud.id.description", ideCloudId, this.myCloudUserId), null);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.wrong.cloud.id.message", new Object[0]), description));
        } else {
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug3.cloud.xdebug.correct.cloud.id.message", new Object[0]), null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDebugModes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStartWithRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStartUponError";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doValidationOfXdebugCloud";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum StartUponErrorMode {
        YES,
        NO,
        DEFAULT;


        static StartUponErrorMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                StartUponErrorMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"yes") || StringUtil.equals((CharSequence)configStr, (CharSequence)"1")) {
                return YES;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"no")) {
                return NO;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"default") || StringUtil.isEmpty((String)configStr)) {
                return DEFAULT;
            }
            throw new NotMatchedException("Unknown start_upon_error mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Start Upon Error";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configStr", "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$StartUponErrorMode", "parse"));
        }
    }

    private static enum StartWithRequestMode {
        YES,
        NO,
        TRIGGER,
        DEFAULT;


        static StartWithRequestMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                StartWithRequestMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"yes") || StringUtil.equals((CharSequence)configStr, (CharSequence)"1")) {
                return YES;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"no") || StringUtil.isEmpty((String)configStr)) {
                return NO;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"trigger")) {
                return TRIGGER;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"default")) {
                return DEFAULT;
            }
            throw new NotMatchedException("Unknown start_with_request mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Start With Request";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configStr", "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$StartWithRequestMode", "parse"));
        }
    }

    private static enum DebugMode {
        OFF,
        DEVELOP,
        COVERAGE,
        DEBUG,
        GCSTATS,
        PROFILE,
        TRACE;


        @NotNull
        static DebugMode parse(@NotNull String configStr) throws NotMatchedException {
            if (configStr == null) {
                DebugMode.$$$reportNull$$$0(0);
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"off")) {
                DebugMode debugMode = OFF;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(1);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"develop")) {
                DebugMode debugMode = DEVELOP;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(2);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"coverage")) {
                DebugMode debugMode = COVERAGE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(3);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"debug")) {
                DebugMode debugMode = DEBUG;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(4);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"gcstats")) {
                DebugMode debugMode = GCSTATS;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(5);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"profile")) {
                DebugMode debugMode = PROFILE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(6);
                }
                return debugMode;
            }
            if (StringUtil.equals((CharSequence)configStr, (CharSequence)"trace")) {
                DebugMode debugMode = TRACE;
                if (debugMode == null) {
                    DebugMode.$$$reportNull$$$0(7);
                }
                return debugMode;
            }
            throw new NotMatchedException("Unknown debug mode " + configStr);
        }

        @NotNull
        static String getOptionName() {
            return "Debug Mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configStr";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$DebugMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/Xdebug3Configuration$DebugMode";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NotMatchedException
    extends Exception {
        NotMatchedException(String message) {
            super(message);
        }
    }
}

