/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.XdebugConfiguration;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xdebug2Configuration
extends XdebugConfiguration {
    private static final String XDEBUG_REMOTE_ENABLE_URL = "https://xdebug.org/docs/all_settings#remote_enable";
    private static final String XDEBUG_REMOTE_HOST_URL = "https://xdebug.org/docs/all_settings#remote_host";
    private static final String XDEBUG_REMOTE_PORT_URL = "https://xdebug.org/docs/all_settings#remote_port";
    private static final String XDEBUG_REMOTE_AUTOSTART_URL = "https://xdebug.org/docs/all_settings#remote_autostart";
    private final boolean myIsRemoteEnable;
    private final String myMode;
    private final boolean myIsAutostartEnabled;

    public Xdebug2Configuration(String version, boolean isLoadedByZendExtension, String protocol, String host, String port, String log, boolean isConnectBack, boolean isRemoteEnable, String mode, boolean isAutostartEnabled) {
        super(version, isLoadedByZendExtension, protocol, host, port, log, isConnectBack);
        this.myIsRemoteEnable = isRemoteEnable;
        this.myMode = mode;
        this.myIsAutostartEnabled = isAutostartEnabled;
    }

    @Override
    protected PhpInfoValidationMessage onWrongHostConfigurationAsLocalhost(@Nullable String remoteAddr) {
        Object details = PhpBundle.message("php.web.server.validation.xdebug.debugger.host.description", new Object[0]);
        if (StringUtil.isNotEmpty((String)remoteAddr)) {
            details = (String)details + PhpBundle.message("php.web.server.validation.xdebug.debugger.host.remote.addr", "xdebug.remote_host", remoteAddr);
        }
        String description = Xdebug2Configuration.getDescriptionByMessage((String)details, XDEBUG_REMOTE_HOST_URL);
        return PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.debugger.localhost", this.myHost), description);
    }

    @Override
    protected PhpInfoValidationMessage onSuccessfulHostConfiguration() {
        String description = Xdebug2Configuration.getDescription("php.web.server.validation.xdebug.debugger.host.description", XDEBUG_REMOTE_HOST_URL);
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.debugger.host", this.myHost), description);
    }

    @Override
    protected PhpInfoValidationMessage onWrongPortConfiguration(String portInIde) {
        String message = PhpBundle.message("php.web.server.validation.xdebug.wrong.port", this.myPort, portInIde);
        String description = Xdebug2Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.wrong.port.description", "xdebug.remote_port"), XDEBUG_REMOTE_PORT_URL);
        return PhpInfoValidationMessage.error(message, description);
    }

    @Override
    protected PhpInfoValidationMessage onConnectBackEnabled() {
        String description = Xdebug2Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.option.is.ignored.description", "xdebug.remote_host"), "https://xdebug.org/docs/all_settings#remote_connect_back");
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.option.is.enabled", "Remote connect back"), description);
    }

    protected PhpInfoValidationMessage onLogEnabled() {
        return PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.log", "Remote log", this.myLog), null);
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr) {
        String description;
        if (messages == null) {
            Xdebug2Configuration.$$$reportNull$$$0(0);
        }
        if (serverHost == null) {
            Xdebug2Configuration.$$$reportNull$$$0(1);
        }
        super.validate(messages, state, serverHost, remoteAddr);
        if (StringUtil.isNotEmpty((String)this.myLog)) {
            messages.add(this.onLogEnabled());
        }
        if (!this.myIsRemoteEnable) {
            description = Xdebug2Configuration.getDescriptionByMessage(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable.description", "xdebug.remote_enable=1"), XDEBUG_REMOTE_ENABLE_URL);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.option.is.not.enabled.description", "Remote debug"), description));
        }
        if (this.myIsAutostartEnabled) {
            description = Xdebug2Configuration.getDescription("php.web.server.validation.xdebug.remote.autostart.description", XDEBUG_REMOTE_AUTOSTART_URL);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.option.is.enabled", "Remote autostart"), description));
        }
        if (StringUtil.equals((CharSequence)this.myMode, (CharSequence)"req")) {
            description = Xdebug2Configuration.getDescription("php.web.server.validation.xdebug.remote.mode.req.description", "https://xdebug.org/docs/all_settings#remote_mode");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.mode.req", new Object[0]), description));
        } else if (StringUtil.equals((CharSequence)this.myMode, (CharSequence)"jit")) {
            description = Xdebug2Configuration.getDescription("php.web.server.validation.xdebug.remote.mode.jit.description", "https://xdebug.org/docs/all_settings#remote_mode");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.mode.jit", new Object[0]), description));
        } else {
            String message = PhpBundle.message("php.web.server.validation.xdebug.mode.is.not.supported", this.myMode);
            messages.add(PhpInfoValidationMessage.error(message, Xdebug2Configuration.getDocumentation("https://xdebug.org/docs/all_settings#remote_mode")));
        }
        if (XdebugUtil.isBeforeXdebug29(this.myVersion) && !StringUtil.equalsIgnoreCase((CharSequence)this.myProtocol, (CharSequence)"dbgp")) {
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.protocol.is.not.supported", this.myProtocol), null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "messages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serverHost";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/debug/validation/configuration/Xdebug2Configuration";
        objectArray[2] = "validate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

