/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.validation.PhpWebServerValidationException;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PhpWebServerEnvironmentConfiguration {
    private static final Logger LOG = Logger.getInstance(PhpWebServerEnvironmentConfiguration.class);
    private final String myConfigurationFile;
    private final String myServerName;
    private final String myRemoteAddr;
    private final String myAdditionalPhpIni;
    private final List<PhpDebugConfiguration> myDebugConfigurations;

    public PhpWebServerEnvironmentConfiguration(@Nullable String configurationFile, @Nullable String additionalPhpIni, @Nullable String serverName, @Nullable String remoteAddr, @NotNull List<PhpDebugConfiguration> debugConfigurations) {
        if (debugConfigurations == null) {
            PhpWebServerEnvironmentConfiguration.$$$reportNull$$$0(0);
        }
        this.myConfigurationFile = configurationFile;
        this.myAdditionalPhpIni = additionalPhpIni;
        this.myServerName = serverName;
        this.myRemoteAddr = remoteAddr;
        this.myDebugConfigurations = debugConfigurations;
    }

    @NotNull
    public static PhpWebServerEnvironmentConfiguration parse(@NotNull Project project, @NotNull BufferedReader reader) throws PhpWebServerValidationException {
        if (project == null) {
            PhpWebServerEnvironmentConfiguration.$$$reportNull$$$0(1);
        }
        if (reader == null) {
            PhpWebServerEnvironmentConfiguration.$$$reportNull$$$0(2);
        }
        SmartList debuggers = new SmartList();
        final Ref additionalPhpIni = new Ref(null);
        final Ref configurationFile = new Ref();
        Ref serverName = new Ref(null);
        Ref remoteAddr = new Ref(null);
        StringBuilder result = new StringBuilder();
        try {
            String line = reader.readLine();
            if (line == null || StringUtil.isEmpty((String)line)) {
                throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.script.result.is.empty", new Object[0]), null);
            }
            result.append(line);
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(new DefaultHandler((List)debuggers, project, serverName, remoteAddr){
                final /* synthetic */ List val$debuggers;
                final /* synthetic */ Project val$project;
                final /* synthetic */ Ref val$serverName;
                final /* synthetic */ Ref val$remoteAddr;
                {
                    this.val$debuggers = list;
                    this.val$project = project;
                    this.val$serverName = ref3;
                    this.val$remoteAddr = ref4;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("path_to_ini".equals(qName)) {
                        String path = attributes.getValue("path");
                        if (StringUtil.isNotEmpty((String)path) && configurationFile.isNull()) {
                            configurationFile.set((Object)path);
                        }
                    } else if ("additional_php_ini".equals(qName)) {
                        String files = attributes.getValue("files");
                        if (StringUtil.isNotEmpty((String)files)) {
                            additionalPhpIni.set((Object)files);
                        }
                    } else if ("debugger".equals(qName)) {
                        this.val$debuggers.add(PhpDebugConfiguration.parse(this.val$project, attributes));
                    } else if ("server".equals(qName)) {
                        this.val$serverName.set((Object)attributes.getValue("server_name"));
                        this.val$remoteAddr.set((Object)attributes.getValue("remote_addr"));
                    }
                }
            });
            xr.parse(new InputSource(new StringReader(result.toString().trim())));
        }
        catch (SAXException e) {
            LOG.warn(result.toString());
            LOG.warn((Throwable)e);
            String description = "The failure may be caused by path mappings misconfiguration or warnings during script execution.<br>If mappings are properly configured please report the <a href=\"https://youtrack.jetbrains.com/issues/WI#newissue=yes\">issue</a> with attached IDE log files (from 'Help|Show Log in Files').";
            throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.script.result.wrong.format", new Object[0]), "The failure may be caused by path mappings misconfiguration or warnings during script execution.<br>If mappings are properly configured please report the <a href=\"https://youtrack.jetbrains.com/issues/WI#newissue=yes\">issue</a> with attached IDE log files (from 'Help|Show Log in Files').");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String description = "The failure may be caused by request interruption.<br>Please check that the connection to the server is stable and try again.";
            throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.failed.to.fetch.script.result", new Object[0]), "The failure may be caused by request interruption.<br>Please check that the connection to the server is stable and try again.");
        }
        return new PhpWebServerEnvironmentConfiguration((String)configurationFile.get(), (String)additionalPhpIni.get(), (String)serverName.get(), (String)remoteAddr.get(), (List<PhpDebugConfiguration>)debuggers);
    }

    @Nullable
    public String getConfigurationFile() {
        return this.myConfigurationFile;
    }

    @Nullable
    public String getAdditionalPhpIni() {
        return this.myAdditionalPhpIni;
    }

    @Nullable
    public String getServerName() {
        return this.myServerName;
    }

    @Nullable
    public String getRemoteAddr() {
        return this.myRemoteAddr;
    }

    @NotNull
    public List<PhpDebugConfiguration> getDebugConfigurations() {
        List<PhpDebugConfiguration> list = this.myDebugConfigurations;
        if (list == null) {
            PhpWebServerEnvironmentConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugConfigurations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpWebServerEnvironmentConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerEnvironmentConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

