/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.debug.ui.PhpIncomingRemoteConnectionDialog;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugFileChooserDialog
extends PhpIncomingRemoteConnectionDialog {
    private JPanel myCenterPanel;
    private SimpleTree myTree;
    private final AbstractTreeBuilder myTreeBuilder;
    private SimpleNode myLastSelectedNode;

    public PhpDebugFileChooserDialog(@NotNull String clientName, Project @NotNull [] projects, @NotNull String remoteFilePath, @NotNull String serverName, int serverPort, @NotNull String requestUri) {
        if (clientName == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(2);
        }
        if (requestUri == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(3);
        }
        if (projects == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(4);
        }
        super(clientName, remoteFilePath, serverName, serverPort, requestUri);
        this.$$$setupUI$$$();
        assert (projects.length > 0);
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)this.myTree, this.myTree.getBuilderModel(), (AbstractTreeStructure)new MyTreeStructure(projects), (Comparator)new WeightBasedComparator(true)){};
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTreeBuilder);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.myTree.setMinSizeInRows(10);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTreeBuilder.initRootNode();
        final Ref nodeRef = new Ref();
        final Ref maxWeight = new Ref((Object)Integer.MIN_VALUE);
        this.myTreeBuilder.accept(MyFileNode.class, (TreeVisitor)new TreeVisitor<MyFileNode>(){

            public boolean visit(@NotNull MyFileNode node) {
                int weight;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((weight = node.getWeight()) > (Integer)maxWeight.get()) {
                    nodeRef.set((Object)node);
                    maxWeight.set((Object)weight);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$2", "visit"));
            }
        });
        if (!nodeRef.isNull()) {
            this.myTreeBuilder.select(nodeRef.get());
        }
    }

    protected String getDimensionServiceKey() {
        return "PhpDebugFileChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    @NotNull
    public Project getSelectedProject() {
        assert (this.myLastSelectedNode != null);
        if (this.myLastSelectedNode instanceof MyProjectRootNode) {
            Project project = ((MyProjectRootNode)this.myLastSelectedNode).getNodeProject();
            if (project == null) {
                PhpDebugFileChooserDialog.$$$reportNull$$$0(5);
            }
            return project;
        }
        if (this.myLastSelectedNode instanceof MyFileNode) {
            Project project = ((MyFileNode)this.myLastSelectedNode).getFileProject();
            if (project == null) {
                PhpDebugFileChooserDialog.$$$reportNull$$$0(6);
            }
            return project;
        }
        assert (false);
        if (null == null) {
            PhpDebugFileChooserDialog.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        assert (this.myLastSelectedNode != null);
        if (this.myLastSelectedNode instanceof MyFileNode) {
            return ((MyFileNode)this.myLastSelectedNode).getFile();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestUri";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SimpleTree simpleTree;
        JPanel jPanel;
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(300, 200), null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, 300), null));
        this.myTree = simpleTree = new SimpleTree();
        simpleTree.setEditable(false);
        simpleTree.setRootVisible(false);
        simpleTree.setShowsRootHandles(true);
        jBScrollPane.setViewportView((Component)simpleTree);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugFileChooserDialog.class).getString("debug.label.select.a.project.or.a.file.to.debug"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public final class MyFileNode
    extends SimpleNode {
        private final VirtualFile myFile;
        private final Project myFileProject;

        private MyFileNode(MyProjectRootNode parent, VirtualFile file) {
            super((SimpleNode)parent);
            this.myFileProject = parent.getNodeProject();
            this.myFile = file;
        }

        public SimpleNode @NotNull [] getChildren() {
            if (NO_CHILDREN == null) {
                MyFileNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyFileNode.$$$reportNull$$$0(1);
            }
            super.update(presentation);
            presentation.setIcon(icons.PhpIcons.PhpIcon);
            VirtualFile myProjectBaseDir = this.myFileProject.getBaseDir();
            assert (myProjectBaseDir != null);
            presentation.setPresentableText(this.myFile.getPresentableUrl());
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public Project getFileProject() {
            return this.myFileProject;
        }

        public int getWeight() {
            return super.getWeight() + PhpPathMapper.intersectFromEnd(PhpDebugFileChooserDialog.this.myRemoteFilePath, this.myFile.getPath(), false).length;
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            PhpDebugFileChooserDialog.this.doOKAction();
        }

        public void handleSelection(SimpleTree tree) {
            PhpDebugFileChooserDialog.this.myLastSelectedNode = this;
        }

        public Object @NotNull [] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myFile};
            if (objectArray == null) {
                MyFileNode.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyFileNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyFileNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public final class MyProjectRootNode
    extends SimpleNode {
        private final Project myNodeProject;
        private SimpleNode[] myChildren;

        private MyProjectRootNode(SimpleNode parent, Project project) {
            super(parent);
            this.myNodeProject = project;
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                Collection candidates = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)this.myNodeProject, (String)PathUtil.getFileName((String)PhpDebugFileChooserDialog.this.myRemoteFilePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myNodeProject)));
                ArrayList<MyFileNode> children = new ArrayList<MyFileNode>();
                for (VirtualFile candidate : candidates) {
                    children.add(new MyFileNode(this, candidate));
                }
                this.myChildren = children.toArray(new MyFileNode[0]);
            }
            if (this.myChildren == null) {
                MyProjectRootNode.$$$reportNull$$$0(0);
            }
            return this.myChildren;
        }

        public Project getNodeProject() {
            return this.myNodeProject;
        }

        public Object @NotNull [] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myNodeProject};
            if (objectArray == null) {
                MyProjectRootNode.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyProjectRootNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setIcon(PhpIcons.PROJECT_ICON);
            presentation.setPresentableText(this.myNodeProject.getName());
        }

        public void handleSelection(SimpleTree tree) {
            PhpDebugFileChooserDialog.this.myLastSelectedNode = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyProjectRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyProjectRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyRootNode
    extends SimpleNode {
        private final MyProjectRootNode[] myChildren;

        private MyRootNode(Project[] projects) {
            ArrayList<MyProjectRootNode> children = new ArrayList<MyProjectRootNode>();
            for (Project project : projects) {
                children.add(new MyProjectRootNode(this, project));
            }
            this.myChildren = children.toArray(new MyProjectRootNode[0]);
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            return this.myChildren;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyRootNode", "getChildren"));
        }
    }

    private final class MyTreeStructure
    extends SimpleTreeStructure {
        private final Project[] myProjects;
        private MyRootNode myRootNode;

        private MyTreeStructure(Project[] projects) {
            this.myProjects = projects;
        }

        @NotNull
        public Object getRootElement() {
            if (this.myRootNode == null) {
                this.myRootNode = new MyRootNode(this.myProjects);
            }
            MyRootNode myRootNode = this.myRootNode;
            if (myRootNode == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return myRootNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/ui/PhpDebugFileChooserDialog$MyTreeStructure", "getRootElement"));
        }
    }
}

