/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.stepFilters;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfigurableForm;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.ui.PhpFileChooserDescriptor;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.ConfigurableForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpStepFiltersConfigurableForm
implements ConfigurableForm {
    private final Project myProject;
    private final ListTableModel<Ref<String>> myMethodListModel;
    private final ListTableModel<Ref<String>> myFileListModel;
    private final JPanel myMainPanel;
    private final JCheckBox mySkipMagicMethodsCb;
    private final JCheckBox mySkipConstructorsCb;
    private final TableView<Ref<String>> myFileListTable;

    public PhpStepFiltersConfigurableForm(final @NotNull Project project) {
        if (project == null) {
            PhpStepFiltersConfigurableForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        ColumnInfo<Ref<String>, String> ignorePathColumnInfo = new ColumnInfo<Ref<String>, String>(PhpBundle.message("PhpStepFiltersConfigurable.skipped.methods", new Object[0])){

            public String valueOf(Ref<String> s) {
                return (String)s.get();
            }

            public boolean isCellEditable(Ref<String> s) {
                return true;
            }

            public void setValue(Ref<String> s, String value) {
                s.set((Object)value);
            }
        };
        ColumnInfo<Ref<String>, String> ignorePathColumnInfo2 = new ColumnInfo<Ref<String>, String>(PhpBundle.message("PhpStepFiltersConfigurable.skipped.files", new Object[0])){

            public String valueOf(Ref<String> s) {
                return (String)s.get();
            }

            public boolean isCellEditable(Ref<String> s) {
                return true;
            }

            public TableCellEditor getEditor(Ref<String> o) {
                return new AbstractTableCellEditor(){
                    CellEditorComponentWithBrowseButton<JTextField> myComponent;

                    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, int column) {
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                VirtualFile fileOrProjectRoot = PhpUiUtil.getFileOrProjectRoot(project, (String)this.getCellEditorValue());
                                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)new PhpFileChooserDescriptor(), (Component)table, (Project)project, (VirtualFile)fileOrProjectRoot);
                                if (file != null) {
                                    ((JTextField)myComponent.getChildComponent()).setText(file.getPresentableUrl());
                                }
                            }
                        };
                        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(listener);
                        textFieldWithBrowseButton.setEditable(false);
                        this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)textFieldWithBrowseButton, (TableCellEditor)((Object)this));
                        ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                        ((JTextField)this.myComponent.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                            protected void textChanged(@NotNull DocumentEvent e) {
                                if (e == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                this.setValue((Ref<String>)((Ref)PhpStepFiltersConfigurableForm.this.myFileListModel.getItems().get(row)), ((JTextField)myComponent.getChildComponent()).getText());
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/stepFilters/PhpStepFiltersConfigurableForm$2$1$2", "textChanged"));
                            }
                        });
                        return this.myComponent;
                    }

                    public Object getCellEditorValue() {
                        return PhpDebugSkippedPathsConfigurableForm.getText((JTextField)this.myComponent.getChildComponent());
                    }
                };
            }

            public void setValue(Ref<String> s, String value) {
                s.set((Object)value);
            }
        };
        this.myMainPanel = new JPanel(new BorderLayout(10, 4));
        this.mySkipMagicMethodsCb = new JCheckBox(PhpBundle.message("PhpStepFiltersConfigurable.skip.magic.methods", new Object[0]));
        this.mySkipConstructorsCb = new JCheckBox(PhpBundle.message("PhpStepFiltersConfigurable.skip.constructors", new Object[0]));
        TableView methodListTable = new TableView();
        methodListTable.setShowGrid(false);
        this.myMethodListModel = new ListTableModel(new ColumnInfo[]{ignorePathColumnInfo});
        this.myFileListModel = new ListTableModel(new ColumnInfo[]{ignorePathColumnInfo2});
        PhpStepFiltersConfiguration.State state = PhpStepFiltersConfiguration.getInstance(this.myProject).getState();
        this.myMethodListModel.setItems(new ArrayList<Ref<String>>(PhpDebugUtil.wrap(state.getSkippedFunctions())));
        methodListTable.setModel(this.myMethodListModel);
        methodListTable.setRowHeight(new JTextField().getPreferredSize().height);
        this.myFileListModel.setItems(new ArrayList<Ref<String>>(PhpDebugUtil.wrap(state.getSkippedFiles())));
        this.myFileListTable = new TableView();
        this.myFileListTable.setShowGrid(false);
        this.myFileListTable.setModelAndUpdateColumns(this.myFileListModel);
        this.myFileListTable.setRowHeight(new JTextField().getPreferredSize().height);
        JPanel myCheckBoxesPanel = new JPanel(new GridLayout(2, 1));
        myCheckBoxesPanel.add(this.mySkipMagicMethodsCb);
        myCheckBoxesPanel.add(this.mySkipConstructorsCb);
        JPanel tablePanel = this.decorate((TableView<Ref<String>>)methodListTable, this.myMethodListModel, PhpBundle.message("PhpStepFiltersConfigurable.specify.method.name", new Object[0]), PhpBundle.message("PhpStepFiltersConfigurable.add.method", new Object[0]));
        JPanel tablePanel2 = ToolbarDecorator.createDecorator(this.myFileListTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<Ref> items = new ArrayList<Ref>(PhpStepFiltersConfigurableForm.this.myFileListModel.getItems());
                items.add(Ref.create((Object)""));
                PhpStepFiltersConfigurableForm.this.myFileListModel.setItems(items);
                int index = PhpStepFiltersConfigurableForm.this.myFileListModel.getRowCount() - 1;
                PhpStepFiltersConfigurableForm.this.myFileListTable.getSelectionModel().setSelectionInterval(index, index);
                PhpStepFiltersConfigurableForm.this.myFileListTable.scrollRectToVisible(PhpStepFiltersConfigurableForm.this.myFileListTable.getCellRect(index, 0, true));
                PhpStepFiltersConfigurableForm.this.myFileListTable.editCellAt(index, 0);
                IdeFocusManager.getInstance((Project)PhpStepFiltersConfigurableForm.this.myProject).requestFocus(PhpStepFiltersConfigurableForm.this.myFileListTable.getEditorComponent(), true);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PhpStepFiltersConfigurableForm.this.myFileListTable.stopEditing();
                ArrayList items = new ArrayList(PhpStepFiltersConfigurableForm.this.myFileListModel.getItems());
                int[] selectedRows = PhpStepFiltersConfigurableForm.this.myFileListTable.getSelectedRows();
                items.removeAll(PhpStepFiltersConfigurableForm.this.myFileListTable.getSelection());
                PhpStepFiltersConfigurableForm.this.myFileListModel.setItems(items);
                if (!items.isEmpty()) {
                    int index = Math.min(selectedRows[0], items.size() - 1);
                    PhpStepFiltersConfigurableForm.this.myFileListTable.getSelectionModel().addSelectionInterval(index, index);
                }
            }
        }).disableUpDownActions().createPanel();
        this.myMainPanel.add((Component)myCheckBoxesPanel, "North");
        JPanel tablePanels = new JPanel(new GridLayout(2, 1));
        tablePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("PhpStepFiltersConfigurable.title.methods", new Object[0])));
        tablePanels.add(tablePanel);
        tablePanel2.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("PhpStepFiltersConfigurable.title.files", new Object[0])));
        tablePanels.add(tablePanel2);
        this.myMainPanel.add((Component)tablePanels, "Center");
    }

    JPanel decorate(final TableView<Ref<String>> myListTable, final ListTableModel<Ref<String>> model, final @Nls String message, final @Nls String title) {
        return ToolbarDecorator.createDecorator(myListTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String name = Messages.showInputDialog((Component)PhpStepFiltersConfigurableForm.this.myMainPanel, (String)message, (String)title, null);
                if (name != null) {
                    ArrayList<Ref> items = new ArrayList<Ref>(model.getItems());
                    items.add(Ref.create((Object)name));
                    model.setItems(items);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                myListTable.stopEditing();
                ArrayList items = new ArrayList(model.getItems());
                int[] selectedRows = myListTable.getSelectedRows();
                items.removeAll(myListTable.getSelection());
                model.setItems(items);
                if (!items.isEmpty()) {
                    int index = Math.min(selectedRows[0], items.size() - 1);
                    myListTable.getSelectionModel().addSelectionInterval(index, index);
                }
            }
        }).disableUpDownActions().createPanel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpStepFiltersConfigurableForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public boolean isModified() {
        PhpStepFiltersConfiguration.State state = PhpStepFiltersConfiguration.getInstance(this.myProject).getState();
        List<String> originalSkipMethods = state.getSkippedFunctions();
        List<String> originalSkipFiles = state.getSkippedFiles();
        List<String> modifiedIgnoreMethods = PhpDebugUtil.unwrap(this.myMethodListModel.getItems());
        for (String s : modifiedIgnoreMethods) {
            if (originalSkipMethods.contains(s)) continue;
            return true;
        }
        for (String s : originalSkipMethods) {
            if (modifiedIgnoreMethods.contains(s)) continue;
            return true;
        }
        List<String> modifiedIgnoreFiles = PhpDebugUtil.unwrap(this.myFileListModel.getItems());
        for (String s : modifiedIgnoreFiles) {
            if (originalSkipFiles.contains(s)) continue;
            return true;
        }
        for (String s : originalSkipFiles) {
            if (modifiedIgnoreFiles.contains(s)) continue;
            return true;
        }
        return state.isSkipMagicMethods() != this.mySkipMagicMethodsCb.isSelected() || state.isSkipConstructors() != this.mySkipConstructorsCb.isSelected();
    }

    @Override
    public void apply() {
        this.simplify();
        PhpStepFiltersConfiguration.State state = PhpStepFiltersConfiguration.getInstance(this.myProject).getState();
        state.setSkipMagicMethods(this.mySkipMagicMethodsCb.isSelected());
        state.setSkipConstructors(this.mySkipConstructorsCb.isSelected());
        state.setSkippedFunctions(PhpDebugUtil.unwrap(this.myMethodListModel.getItems()));
        state.setSkippedFiles(PhpDebugUtil.unwrap(this.myFileListModel.getItems()));
    }

    @Override
    public void reset() {
        PhpStepFiltersConfiguration.State state = PhpStepFiltersConfiguration.getInstance(this.myProject).getState();
        this.mySkipMagicMethodsCb.setSelected(state.isSkipMagicMethods());
        this.mySkipConstructorsCb.setSelected(state.isSkipConstructors());
        this.myMethodListModel.setItems(new ArrayList<Ref<String>>(PhpDebugUtil.wrap(state.getSkippedFunctions())));
        this.myFileListModel.setItems(new ArrayList<Ref<String>>(PhpDebugUtil.wrap(state.getSkippedFiles())));
    }

    private void simplify() {
        ArrayList items = new ArrayList(this.myFileListModel.getItems());
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            if (!StringUtil.isEmptyOrSpaces((String)((String)((Ref)iterator.next()).get()))) continue;
            iterator.remove();
        }
        this.myFileListModel.setItems(items);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/stepFilters/PhpStepFiltersConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/stepFilters/PhpStepFiltersConfigurableForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

