/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.util.connection.ConnectionHandler;
import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugConnectionManager<C extends PhpDebugConnection>
implements ConnectionHandler<C>,
Disposable {
    private final Object myLock = new Object();
    private final Deque<C> myDebugConnections = new LinkedList<C>();
    private boolean isTouched = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@NotNull C connection) {
        if (connection == null) {
            PhpDebugConnectionManager.$$$reportNull$$$0(0);
        }
        this.isTouched = true;
        Object object = this.myLock;
        synchronized (object) {
            this.myDebugConnections.addLast(connection);
        }
    }

    public void dispose() {
        this.detachConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachConnections() {
        Object object = this.myLock;
        synchronized (object) {
            for (PhpDebugConnection debugConnection : this.myDebugConnections) {
                debugConnection.startDetach();
            }
            this.myDebugConnections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public C getCurrentConnection() {
        Object object = this.myLock;
        synchronized (object) {
            return (C)((PhpDebugConnection)this.myDebugConnections.pollFirst());
        }
    }

    public boolean isTouched() {
        return this.isTouched;
    }

    public void checkTouchedCli(@NotNull Project project, @Nullable String interpreterName) {
        if (project == null) {
            PhpDebugConnectionManager.$$$reportNull$$$0(1);
        }
        if (!this.isTouched() && StringUtil.isNotEmpty((String)interpreterName)) {
            PhpDebugUtil.showFailsToConnectMessage(project, interpreterName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugConnectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTouchedCli";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

