/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.jetbrains.php.debug.PhpDebugConnectionInfo;
import com.jetbrains.php.debug.PhpDebugSessionLogger;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpDebugConnectionDetacher<C extends PhpDebugConnection>
implements ConnectionListener<C> {
    @NotNull
    private final C myConnection;

    public PhpDebugConnectionDetacher(@NotNull C connection) {
        if (connection == null) {
            PhpDebugConnectionDetacher.$$$reportNull$$$0(0);
        }
        this.myConnection = connection;
    }

    public void init() {
        ((PhpDebugConnection)this.myConnection).addListener(this);
        this.registerHandlers();
        ((PhpDebugConnection)this.getConnection()).updateStatus();
    }

    @NotNull
    public final C getConnection() {
        C c = this.myConnection;
        if (c == null) {
            PhpDebugConnectionDetacher.$$$reportNull$$$0(1);
        }
        return c;
    }

    protected abstract void registerHandlers();

    @Override
    public final void statusChanged(@NotNull C connection, @NotNull ConnectionStatus status) {
        if (connection == null) {
            PhpDebugConnectionDetacher.$$$reportNull$$$0(2);
        }
        if (status == null) {
            PhpDebugConnectionDetacher.$$$reportNull$$$0(3);
        }
        switch (status) {
            case CONNECTED: {
                ((PhpDebugConnection)this.getConnection()).logEvent("Start detaching");
                ((PhpDebugConnection)this.getConnection()).initializeConnection(new PhpDebugProcess.InitializeCallback(){

                    @Override
                    public void initialized(boolean isJitMode) {
                        PhpDebugConnectionDetacher.this.start();
                    }

                    @Override
                    public void errorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage) {
                        if (errorTitle == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ((PhpDebugConnection)PhpDebugConnectionDetacher.this.getConnection()).stop();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "errorTitle";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/php/debug/connection/PhpDebugConnectionDetacher$1";
                        objectArray[2] = "errorOccurred";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, false, false);
                break;
            }
            case DISCONNECTED: {
                ((PhpDebugConnection)this.myConnection).removeListener(this);
                ((PhpDebugConnection)this.getConnection()).logEvent("Stop detaching");
                PhpDebugSessionLogger.getInstance().logSessionEnded((PhpDebugConnectionInfo)this.myConnection);
                break;
            }
        }
    }

    protected abstract void start();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugConnectionDetacher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugConnectionDetacher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "statusChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

