/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.smartStepInto;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSmartStepIntoState {
    @Nullable
    private final Set<String> myClassReference;
    private final String[] myVariant;
    private int myPositionInVariant;
    private int myInitialDepth;
    private final LineRange myInvokePosition;

    public PhpSmartStepIntoState(@Nullable Set<String> classReference, String[] variant, int startLine, int endLine) {
        this.myClassReference = classReference;
        this.myVariant = variant;
        this.myPositionInVariant = 0;
        this.myInitialDepth = 0;
        this.myInvokePosition = new LineRange(startLine, endLine);
    }

    public int getInitialDepth() {
        return this.myInitialDepth;
    }

    public void setInitialDepth(int initialDepth) {
        this.myInitialDepth = initialDepth;
    }

    public boolean isOnStartPosition(int depth, int line) {
        return depth == this.myInitialDepth && line >= this.myInvokePosition.startLine && line <= this.myInvokePosition.endLine;
    }

    public boolean isTargetFunctionReached(@Nullable String className, @NotNull String functionName) {
        if (functionName == null) {
            PhpSmartStepIntoState.$$$reportNull$$$0(0);
        }
        if (this.isFunctionReached(className, functionName)) {
            ++this.myPositionInVariant;
        }
        return this.myPositionInVariant == this.myVariant.length;
    }

    private boolean isFunctionReached(@Nullable String className, @NotNull String functionName) {
        if (functionName == null) {
            PhpSmartStepIntoState.$$$reportNull$$$0(1);
        }
        if (this.myPositionInVariant == 0 && (this.myClassReference != null && StringUtil.isEmpty((String)className) || this.myClassReference == null && StringUtil.isNotEmpty((String)className))) {
            return false;
        }
        if (this.myClassReference != null && StringUtil.isNotEmpty((String)className) && this.myPositionInVariant == 0) {
            return this.myClassReference.contains(StringUtil.toLowerCase((String)className)) && (PhpLangUtil.equalsMethodNames(this.myVariant[0], functionName) || PhpLangUtil.equalsMethodNames(this.myVariant[0], "__construct") && PhpLangUtil.equalsClassNames(functionName, className));
        }
        return this.myPositionInVariant >= 0 && PhpLangUtil.equalsFunctionNames(functionName, this.myVariant[this.myPositionInVariant]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "functionName";
        objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTargetFunctionReached";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionReached";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class LineRange {
        private final int startLine;
        private final int endLine;

        private LineRange(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }
}

