/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.debugConsole;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugCommentCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugConsoleCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugEvalCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugSimpleCommand;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugCommandFactory {
    @NotNull
    public static PhpDebugConsoleCommand createCommand(@NotNull PsiFile file, @Nullable XSourcePosition position) {
        XSourcePosition newPosition;
        if (file == null) {
            PhpDebugCommandFactory.$$$reportNull$$$0(0);
        }
        if (PhpDebugCommandFactory.isComment(file)) {
            return new PhpDebugCommentCommand();
        }
        final Ref wrapIntoEval = new Ref((Object)false);
        final Ref importContext = new Ref((Object)true);
        final Ref hasAssignment = new Ref((Object)false);
        file.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                this.setWrapIntoEval();
            }

            public void visitPhpGroupStatement(GroupStatement groupStatement) {
                PsiElement[] statements = groupStatement.getStatements();
                if (statements != null && statements.length > 1) {
                    this.setWrapIntoEval();
                }
                super.visitPhpGroupStatement(groupStatement);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                this.setWrapIntoEval();
                importContext.set((Object)false);
            }

            public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                hasAssignment.set((Object)true);
            }

            public void visitPhpClass(PhpClass clazz) {
                this.setWrapIntoEval();
            }

            public void visitPhpTry(Try tryStatement2) {
                this.setWrapIntoEval();
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                this.setWrapIntoEval();
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpWhile(While whileStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpFor(For forStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpIf(If ifStatement) {
                this.setWrapIntoEval();
            }

            public void visitPhpFunction(Function function) {
                this.setWrapIntoEval();
            }

            private void setWrapIntoEval() {
                wrapIntoEval.set((Object)true);
            }
        });
        Object object = newPosition = (Boolean)importContext.get() != false ? position : null;
        if (((Boolean)wrapIntoEval.get()).booleanValue()) {
            return new PhpDebugEvalCommand(file.getProject(), newPosition, (Boolean)hasAssignment.get());
        }
        return new PhpDebugSimpleCommand(file.getProject(), newPosition, (Boolean)hasAssignment.get());
    }

    private static boolean isComment(@NotNull PsiFile file) {
        PsiElement[] children;
        if (file == null) {
            PhpDebugCommandFactory.$$$reportNull$$$0(1);
        }
        if ((children = file.getChildren()).length == 1) {
            if (children[0] instanceof GroupStatement) {
                PsiElement[] statements = ((GroupStatement)children[0]).getStatements();
                return statements.length == 1 && statements[0] instanceof PsiComment;
            }
        } else if (children.length == 2 && children[0] instanceof PsiComment && children[1] instanceof GroupStatement) {
            PsiElement[] statements = ((GroupStatement)children[1]).getStatements();
            return statements.length == 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/jetbrains/php/debug/common/debugConsole/PhpDebugCommandFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

