/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.template.PhpTemplateLanguagePathMapper;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.text.MessageFormat;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PhpStackFrame<S extends PhpDebugConnection>
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(PhpStackFrame.class);
    private final Object myLock;
    public static final String GET_VARIABLES_EXPR = "array(\"this\"=>(isset($this) ? array(\"this\"=>$this) : null),\"vars\"=>get_defined_vars(),\"globals\"=>$GLOBALS)";
    protected static final String VAR_GROUP_VARS = "vars";
    public static final String VAR_GROUP_GLOBALS = "globals";
    public static final String VAR_THIS = "this";
    public static final String GLOBALS = "GLOBALS";
    @NotNull
    private final PhpDebugProcess<S> myDebugProcess;
    private final Runnable myReloader;
    private final String myRemoteFilePath;
    private final int myLineNumber;
    private final String myFunctionName;
    private final int myStackSize;
    private final int myDepth;
    private XSourcePosition mySourcePosition;
    protected final PhpDebugRuntimeEnvironment myRuntimeEnvironment;
    private XDebuggerEvaluator myEvaluator;

    public PhpStackFrame(@NotNull PhpDebugProcess<S> debugProcess, @NotNull Runnable reloader, @NotNull String remoteFilePath, int lineNumber, @NotNull String functionName, int stackSize, int depth) {
        if (debugProcess == null) {
            PhpStackFrame.$$$reportNull$$$0(0);
        }
        if (reloader == null) {
            PhpStackFrame.$$$reportNull$$$0(1);
        }
        if (remoteFilePath == null) {
            PhpStackFrame.$$$reportNull$$$0(2);
        }
        if (functionName == null) {
            PhpStackFrame.$$$reportNull$$$0(3);
        }
        this.myLock = new Object();
        this.myDebugProcess = debugProcess;
        this.myReloader = reloader;
        this.myRemoteFilePath = remoteFilePath;
        this.myLineNumber = lineNumber;
        this.myFunctionName = functionName;
        this.myStackSize = stackSize;
        this.myDepth = depth;
        PhpPathMapper pathMapper = this.getDebugProcess().getPathMapper();
        if (pathMapper == null) {
            this.mySourcePosition = null;
        } else {
            VirtualFile localFile = pathMapper.getLocalFile(remoteFilePath);
            if (localFile != null) {
                this.mySourcePosition = (XSourcePosition)ReadAction.compute(() -> XDebuggerUtil.getInstance().createPosition(localFile, lineNumber));
                Project project = this.myDebugProcess.getSession().getProject();
                PhpTemplateLanguagePathMapper templateMapper = PhpTemplateLanguagePathMapper.getInstance(localFile, project);
                if (templateMapper != null) {
                    this.mySourcePosition = templateMapper.mapToTemplate(this.mySourcePosition, project, pathMapper);
                }
            } else {
                this.mySourcePosition = null;
            }
        }
        this.myRuntimeEnvironment = new PhpDebugRuntimeEnvironment();
    }

    @NotNull
    public final PhpDebugProcess<S> getDebugProcess() {
        PhpDebugProcess<S> phpDebugProcess = this.myDebugProcess;
        if (phpDebugProcess == null) {
            PhpStackFrame.$$$reportNull$$$0(4);
        }
        return phpDebugProcess;
    }

    public Object getEqualityObject() {
        return Trinity.create((Object)(this.myStackSize - (this.myDepth + 1)), (Object)this.myRemoteFilePath, (Object)this.myFunctionName);
    }

    public final XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        PhpPathMapper pathMapper;
        if (node == null) {
            PhpStackFrame.$$$reportNull$$$0(5);
        }
        if ((pathMapper = this.getDebugProcess().getPathMapper()) == null) {
            this.myDebugProcess.onCannotFindPathMapper(node, this.myReloader);
        } else {
            String localPath = pathMapper.getLocalPath(this.myRemoteFilePath);
            if (localPath == null) {
                this.myDebugProcess.onCannotFindLocalPath(node, this.myRemoteFilePath, this.myReloader);
            } else {
                VirtualFile localFile = pathMapper.getLocalFile(this.myRemoteFilePath);
                if (localFile == null) {
                    this.myDebugProcess.onCannotFindLocalFile(node, this.myRemoteFilePath, localPath, this.myReloader);
                } else {
                    PsiFile localPsiFile;
                    Project project = this.myDebugProcess.getSession().getProject();
                    if (!GlobalSearchScope.allScope((Project)project).contains(localFile)) {
                        this.myDebugProcess.onScriptOutsideProject(node, this.myRemoteFilePath, localFile, this.myReloader);
                    }
                    if ((localPsiFile = PsiManager.getInstance((Project)project).findFile(localFile)) != null && !(localPsiFile.getFileType() instanceof LanguageFileType)) {
                        String message = PhpBundle.message("debug.process.cant.compute.source.position", localFile.getName());
                        Icon icon = UIUtil.getBalloonWarningIcon();
                        SimpleTextAttributes textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                        node.setMessage(message, icon, textAttributes, null);
                    }
                }
            }
        }
        node.addChildren(XValueChildrenList.EMPTY, false);
        this.computeVariables(node);
    }

    public final void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            PhpStackFrame.$$$reportNull$$$0(6);
        }
        SimpleTextAttributes regularTextAttributes = this.getSourcePosition() != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        SimpleTextAttributes italicTextAttributes = this.getSourcePosition() != null ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
        component.append(PathUtil.getFileName((String)this.myRemoteFilePath), regularTextAttributes);
        int lineNumber = this.myLineNumber + 1;
        @NlsSafe String format = MessageFormat.format(":{0}", String.valueOf(lineNumber));
        component.append(format, regularTextAttributes);
        component.setIcon(AllIcons.Debugger.Frame);
        if (StringUtil.isNotEmpty((String)this.myFunctionName)) {
            component.append(",", regularTextAttributes);
            @NlsSafe String format1 = MessageFormat.format(" {0}()", this.myFunctionName);
            component.append(format1, italicTextAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XDebuggerEvaluator getEvaluator() {
        if (this.getDepth() > 0) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myEvaluator == null) {
                this.myEvaluator = this.createEvaluator();
            }
            return this.myEvaluator;
        }
    }

    @NotNull
    protected abstract XDebuggerEvaluator createEvaluator();

    public final int getDepth() {
        return this.myDepth;
    }

    protected abstract void computeVariables(@NotNull XCompositeNode var1);

    public PhpDebugRuntimeEnvironment getRuntimeEnvironment() {
        return this.myRuntimeEnvironment;
    }

    protected boolean isHideEmptySuperGlobals() {
        Project project = this.getDebugProcess().getSession().getProject();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        return state.isHideEmptySuperglobals();
    }

    protected static boolean isSuperGlobal(@NotNull String variableName) {
        if (variableName == null) {
            PhpStackFrame.$$$reportNull$$$0(7);
        }
        return PhpLangUtil.isSuperGlobal(variableName) && !GLOBALS.equals(variableName);
    }

    protected static boolean isVar(@NotNull String variableName) {
        if (variableName == null) {
            PhpStackFrame.$$$reportNull$$$0(8);
        }
        return !PhpLangUtil.isSuperGlobal(variableName) && !PhpLangUtil.isSuperGlobalAlias(variableName) && !PhpLangUtil.equalsVariableNames(VAR_THIS, variableName);
    }

    protected static boolean isEvalCache(@NotNull String variableName) {
        if (variableName == null) {
            PhpStackFrame.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(!StringUtil.startsWith((CharSequence)variableName, (CharSequence)"$"), (Object)variableName);
        return PhpLangUtil.equalsVariableNames("IDE_EVAL_CACHE", variableName);
    }

    public final String getFunctionName() {
        return this.myFunctionName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpStackFrame";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpStackFrame";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuperGlobal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isVar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEvalCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

