/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSafeExpressionBuilder {
    private static final Logger LOG = Logger.getInstance(PhpSafeExpressionBuilder.class);
    public static final String IDE_EVAL_ERR = "IDE_EVAL_ERR";
    private final Project myProject;
    private final String myExpression;
    private boolean mySafeEvaluation;
    private boolean myAlwaysWrapInEval;
    private boolean myAddReturnStatement;
    private XSourcePosition myContext;

    public PhpSafeExpressionBuilder(@NotNull Project project, @NotNull String expression) {
        if (project == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(1);
        }
        this.mySafeEvaluation = false;
        this.myAlwaysWrapInEval = false;
        this.myAddReturnStatement = true;
        this.myContext = null;
        this.myProject = project;
        this.myExpression = expression;
    }

    @NotNull
    public PhpSafeExpressionBuilder setSafeEvaluation(boolean safeEvaluation) {
        this.mySafeEvaluation = safeEvaluation;
        PhpSafeExpressionBuilder phpSafeExpressionBuilder = this;
        if (phpSafeExpressionBuilder == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(2);
        }
        return phpSafeExpressionBuilder;
    }

    @NotNull
    public PhpSafeExpressionBuilder setAlwaysWrapInEval(boolean alwaysWrapInEval) {
        this.myAlwaysWrapInEval = alwaysWrapInEval;
        PhpSafeExpressionBuilder phpSafeExpressionBuilder = this;
        if (phpSafeExpressionBuilder == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(3);
        }
        return phpSafeExpressionBuilder;
    }

    @NotNull
    public PhpSafeExpressionBuilder setAddReturnStatement(boolean addReturnStatement) {
        this.myAddReturnStatement = addReturnStatement;
        PhpSafeExpressionBuilder phpSafeExpressionBuilder = this;
        if (phpSafeExpressionBuilder == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(4);
        }
        return phpSafeExpressionBuilder;
    }

    @NotNull
    public PhpSafeExpressionBuilder setContext(@Nullable XSourcePosition context) {
        this.myContext = context;
        PhpSafeExpressionBuilder phpSafeExpressionBuilder = this;
        if (phpSafeExpressionBuilder == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(5);
        }
        return phpSafeExpressionBuilder;
    }

    @NotNull
    public String build() {
        boolean canThrowException;
        PhpSafeEvaluationVisitor visitor;
        PhpPsiElement scope = PhpSafeExpressionBuilder.findScope(this.myProject, this.myContext);
        List<Object> imports = scope != null ? PhpCodeInsightUtil.collectImports(scope) : Collections.emptyList();
        String namespaceName = scope instanceof PhpNamespace ? PhpLangUtil.toName(((PhpNamespace)scope).getFQN()) : "";
        PhpSafeEvaluationVisitor phpSafeEvaluationVisitor = visitor = this.mySafeEvaluation ? new PhpSafeEvaluationVisitor(this.myProject) : null;
        if (this.mySafeEvaluation) {
            StringBuilder exp = new StringBuilder();
            PhpSafeExpressionBuilder.appendImports(exp, str -> exp.append((String)str), imports, namespaceName);
            exp.append(this.myExpression).append(";");
            if (LOG.isDebugEnabled()) {
                LOG.debug(exp.toString());
            }
            PsiFile element = PhpPsiElementFactory.createPsiFileFromText(this.myProject, exp.toString());
            element.accept((PsiElementVisitor)visitor);
        }
        String safeExpression = visitor != null ? visitor.generate(this.myExpression) : this.myExpression;
        boolean importContext = !imports.isEmpty() || StringUtil.isNotEmpty((String)namespaceName);
        boolean bl = canThrowException = visitor != null && visitor.getCanThrowException();
        if (!(this.myAlwaysWrapInEval || importContext || canThrowException)) {
            String string = safeExpression;
            if (string == null) {
                PhpSafeExpressionBuilder.$$$reportNull$$$0(6);
            }
            return string;
        }
        boolean addReturn = this.myAddReturnStatement && (importContext || canThrowException);
        StringBuilder buff = new StringBuilder("eval(\"");
        if (importContext) {
            PhpSafeExpressionBuilder.appendImports(buff, str -> StringUtil.escapeStringCharacters((int)str.length(), (String)str, (String)"$\"\\", (boolean)false, (StringBuilder)buff), imports, namespaceName);
        }
        if (canThrowException) {
            buff.append("try { ");
        }
        if (addReturn) {
            buff.append("return ");
        }
        StringUtil.escapeStringCharacters((int)safeExpression.length(), (String)safeExpression, (String)"$\"\\", (boolean)false, (StringBuilder)buff);
        if (addReturn && safeExpression.length() > 0 && safeExpression.charAt(safeExpression.length() - 1) != ';') {
            buff.append(";");
        }
        if (canThrowException) {
            buff.append("}catch (Exception \\$e) { return \\$e->getMessage();}");
        }
        buff.append("\")");
        String string = buff.toString();
        if (string == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static PhpPsiElement findScope(@NotNull Project project, @Nullable XSourcePosition position) {
        PsiFile file;
        if (project == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(8);
        }
        if (position == null) {
            return null;
        }
        VirtualFile positionFile = position.getFile();
        PsiFile psiFile = file = positionFile.isValid() ? PsiManager.getInstance((Project)project).findFile(positionFile) : null;
        if (file != null) {
            FileASTNode fileNode = file.getNode();
            ASTNode node = fileNode != null ? fileNode.findLeafElementAt(position.getOffset()) : null;
            return node != null ? PhpCodeInsightUtil.findScopeForUseOperator(node.getPsi()) : null;
        }
        return null;
    }

    private static void appendImports(@NotNull StringBuilder buff, @NotNull Consumer<String> safeAppender, @NotNull List<PhpUseList> imports, @NotNull String namespaceName) {
        if (buff == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(9);
        }
        if (safeAppender == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(10);
        }
        if (imports == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(11);
        }
        if (namespaceName == null) {
            PhpSafeExpressionBuilder.$$$reportNull$$$0(12);
        }
        if (StringUtil.isNotEmpty((String)namespaceName)) {
            buff.append("namespace ");
            safeAppender.accept(namespaceName);
            buff.append(";");
        }
        for (PhpUseList anImport : imports) {
            safeAppender.accept(anImport.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpSafeExpressionBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buff";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeAppender";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpSafeExpressionBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setSafeEvaluation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setAlwaysWrapInEval";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddReturnStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpSafeEvaluationVisitor
    extends PhpRecursiveElementVisitor {
        private final Project myProject;
        private final Set<String> myIsSetCheck;
        private final Set<String> mySafeConditions;
        private final Ref<Boolean> myCanThrowException;

        PhpSafeEvaluationVisitor(@NotNull Project project) {
            if (project == null) {
                PhpSafeEvaluationVisitor.$$$reportNull$$$0(0);
            }
            this.myIsSetCheck = new LinkedHashSet<String>();
            this.mySafeConditions = new LinkedHashSet<String>();
            this.myCanThrowException = new Ref((Object)false);
            this.myProject = project;
        }

        public boolean getCanThrowException() {
            return (Boolean)this.myCanThrowException.get();
        }

        public void visitPhpVariable(Variable variable) {
            super.visitPhpVariable(variable);
            String variableName = variable.getName();
            if (!StringUtil.isEmpty((String)variableName)) {
                PhpAccessInstruction.Access access = PhpCodeInsightUtil.getAccess((PhpPsiElement)variable);
                if (DumbService.isDumb((Project)this.myProject) || access.isRead() || access.isReadWrite()) {
                    this.myIsSetCheck.add("$" + variableName);
                }
            }
        }

        public void visitPhpClassReference(ClassReference classReference) {
            String fqn;
            if (PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpUse.INSTANCEOF) == null && StringUtil.isNotEmpty((String)(fqn = classReference.getFQN())) && !PhpLangUtil.isClassNameSpecial(fqn)) {
                this.mySafeConditions.add("class_exists('" + fqn + "')");
            }
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            super.visitPhpFunctionCall(reference);
            this.myCanThrowException.set((Object)true);
        }

        public void visitPhpMethodReference(MethodReference reference) {
            PhpExpression classReference;
            super.visitPhpMethodReference(reference);
            this.myCanThrowException.set((Object)true);
            String methodName = reference.getName();
            if (StringUtil.isNotEmpty((String)methodName) && (classReference = reference.getClassReference()) != null) {
                if (classReference instanceof ClassReference && PhpLangUtil.isClassNameSpecial(classReference.getName())) {
                    this.mySafeConditions.add("is_callable('" + classReference.getName() + "::" + methodName + "')");
                } else {
                    String className = classReference instanceof ClassReference ? "'" + ((ClassReference)classReference).getFQN() + "'" : classReference.getText();
                    this.mySafeConditions.add("is_callable(array(" + className + ",'" + methodName + "'))");
                }
            }
        }

        public void visitPhpFieldReference(FieldReference reference) {
            String fieldText;
            PhpExpression classReference = reference.getClassReference();
            if (classReference != null) {
                classReference.accept((PsiElementVisitor)this);
            }
            if (StringUtil.isNotEmpty((String)(fieldText = reference.getText()))) {
                this.myIsSetCheck.add(fieldText);
            }
        }

        @NotNull
        public String generate(@NotNull String expression) {
            Iterator<String> iterator;
            if (expression == null) {
                PhpSafeEvaluationVisitor.$$$reportNull$$$0(1);
            }
            if (!this.myIsSetCheck.isEmpty()) {
                iterator = this.myIsSetCheck.iterator();
                StringBuilder buff = new StringBuilder("isset(");
                while (iterator.hasNext()) {
                    buff.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    buff.append(",");
                }
                buff.append(")");
                this.mySafeConditions.add(buff.toString());
            }
            if ((iterator = this.mySafeConditions.iterator()).hasNext()) {
                StringBuilder expressionBuilder = new StringBuilder();
                expressionBuilder.append("(");
                while (iterator.hasNext()) {
                    expressionBuilder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    expressionBuilder.append("&&");
                }
                expressionBuilder.append(")?(").append(expression).append("):").append("\"IDE_EVAL_ERR\"");
                String string = expressionBuilder.toString();
                if (string == null) {
                    PhpSafeEvaluationVisitor.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = expression;
            if (string == null) {
                PhpSafeEvaluationVisitor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/common/PhpSafeExpressionBuilder$PhpSafeEvaluationVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/common/PhpSafeExpressionBuilder$PhpSafeEvaluationVisitor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

