/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

public class PhpMethodBreakpointValidator {
    private final Set<XBreakpoint<PhpMethodBreakpointProperties>> myMethodBreakpoints = new HashSet<XBreakpoint<PhpMethodBreakpointProperties>>();
    private final TObjectIntHashMap<String> myMethodNameToFirstLine = new TObjectIntHashMap();

    public void addBreakpoint(XBreakpoint<PhpMethodBreakpointProperties> breakpoint) {
        this.myMethodBreakpoints.add(breakpoint);
    }

    public void addBreakpoints(Set<XBreakpoint<PhpMethodBreakpointProperties>> breakpointsSet) {
        this.myMethodBreakpoints.addAll(breakpointsSet);
    }

    @Nullable
    public XBreakpoint<PhpMethodBreakpointProperties> findMethodBreakpoint(@NotNull String method) {
        if (method == null) {
            PhpMethodBreakpointValidator.$$$reportNull$$$0(0);
        }
        for (XBreakpoint<PhpMethodBreakpointProperties> breakpoint : this.myMethodBreakpoints) {
            String reportedMethodFqn;
            String sourceMethodFqn = ((PhpMethodBreakpointProperties)breakpoint.getProperties()).getStackFrameFunctionFqn();
            if (!StringUtil.equals((CharSequence)sourceMethodFqn, (CharSequence)(reportedMethodFqn = StringUtil.replace((String)method, (String)"->", (String)"::")))) continue;
            return breakpoint;
        }
        return null;
    }

    @Nullable
    public XBreakpoint<PhpMethodBreakpointProperties> findMethodBreakpointOnLine(@NotNull String stopMethodFqn, int stopLine) {
        XBreakpoint<PhpMethodBreakpointProperties> breakpoint;
        if (stopMethodFqn == null) {
            PhpMethodBreakpointValidator.$$$reportNull$$$0(1);
        }
        if ((breakpoint = this.findMethodBreakpoint(stopMethodFqn)) == null) {
            return null;
        }
        if (!this.myMethodNameToFirstLine.containsKey((Object)stopMethodFqn)) {
            this.myMethodNameToFirstLine.put((Object)stopMethodFqn, stopLine);
            return breakpoint;
        }
        int lineNumber = this.myMethodNameToFirstLine.get((Object)stopMethodFqn);
        if (lineNumber == stopLine) {
            return breakpoint;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopMethodFqn";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpMethodBreakpointValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodBreakpointOnLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

