/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpLineBreakpointTypeBase<P extends XBreakpointProperties>
extends XLineBreakpointType<P> {
    private final XDebuggerEditorsProvider myEditorsProvider;

    protected PhpLineBreakpointTypeBase(@NotNull String id, @Nls @NotNull String title, @Nullable XDebuggerEditorsProvider editorsProvider) {
        if (id == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(0);
        }
        if (title == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(1);
        }
        super(id, title);
        this.myEditorsProvider = editorsProvider;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<P> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(3);
        }
        return this.myEditorsProvider;
    }

    @Nullable
    public P createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public static PsiElement findPhpPsiElementByCondition(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull Predicate<PsiElement> accepts, @NotNull Predicate<PsiElement> prohibits) {
        Document document;
        if (file == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(6);
        }
        if (accepts == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(7);
        }
        if (prohibits == null) {
            PhpLineBreakpointTypeBase.$$$reportNull$$$0(8);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file)) == null) {
            return null;
        }
        Ref targetElement = new Ref(null);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, element -> {
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            PhpPsiElement parent = (PhpPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, PhpPsiElement.class, (boolean)false);
            if (parent == null) {
                return true;
            }
            if (accepts.test((PsiElement)element)) {
                targetElement.set(element);
            }
            if (prohibits.test((PsiElement)element)) {
                targetElement.set(null);
                return false;
            }
            return true;
        });
        return (PsiElement)targetElement.get();
    }

    static boolean isFunctionDeclaration(PsiElement element) {
        return element.getParent() instanceof Function && PhpPsiUtil.isOfType(element.getNode(), PhpTokenTypes.IDENTIFIER);
    }

    private static boolean isFunctionFromSpecialClass(Function function, Predicate<PhpClass> isSpecialClass) {
        if (function instanceof PhpClassMember) {
            PhpClass containingClass = ((PhpClassMember)function).getContainingClass();
            if (containingClass == null) {
                return false;
            }
            if (isSpecialClass.test(containingClass)) {
                return true;
            }
        }
        return false;
    }

    static boolean isMethodOfAnonymousClass(Function function) {
        return PhpLineBreakpointTypeBase.isFunctionFromSpecialClass(function, cl -> cl.isAnonymous());
    }

    static boolean isMethodInInterface(Function function) {
        return PhpLineBreakpointTypeBase.isFunctionFromSpecialClass(function, cl -> cl.isInterface());
    }

    static boolean isMethodInTrait(Function function) {
        return PhpLineBreakpointTypeBase.isFunctionFromSpecialClass(function, cl -> cl.isTrait());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accepts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prohibits";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpLineBreakpointTypeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpointProperties";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findPhpPsiElementByCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

