/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpLineBreakpointTypeBase;
import com.jetbrains.php.debug.template.PhpTemplateLanguagePathMapper;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.run.PhpRunUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLineBreakpointType
extends PhpLineBreakpointTypeBase<XBreakpointProperties> {
    public static final PhpLineBreakpointType INSTANCE = new PhpLineBreakpointType();

    @NotNull
    public static PhpLineBreakpointType getInstance() {
        PhpLineBreakpointType phpLineBreakpointType = (PhpLineBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtensionOrFail(PhpLineBreakpointType.class));
        if (phpLineBreakpointType == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(0);
        }
        return phpLineBreakpointType;
    }

    @Nullable
    public static XLineBreakpoint<XBreakpointProperties> findBreakpointAtLine(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(2);
        }
        return (XLineBreakpoint)ReadAction.compute(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().findBreakpointAtLine((XLineBreakpointType)PhpLineBreakpointType.getInstance(), file, line));
    }

    protected PhpLineBreakpointType() {
        super("php", PhpBundle.message("debug.php.line.breakpoint.title", new Object[0]), (XDebuggerEditorsProvider)new PhpDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (PhpTemplateLanguagePathMapper.isTemplateFile(file)) {
            return true;
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE) && !PhpRunUtil.isPhpScratch(project, file)) {
            return false;
        }
        PsiElement targetElement = PhpLineBreakpointTypeBase.findPhpPsiElementByCondition(file, line, project, element -> true, element -> PhpLineBreakpointType.isFunctionDeclaration(element) && !PhpLineBreakpointType.isMethodOfAnonymousClass((Function)element.getParent()) && !PhpLineBreakpointType.isMethodInInterface((Function)element.getParent()) && !PhpLineBreakpointType.isMethodInTrait((Function)element.getParent()));
        return targetElement != null;
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, @Nullable XDebugSession session) {
        XDebugProcess debugProcess;
        if (breakpoint == null) {
            PhpLineBreakpointType.$$$reportNull$$$0(5);
        }
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        if (session != null && sourcePosition != null && (debugProcess = session.getDebugProcess()) instanceof PhpDebugProcess) {
            return ((PhpDebugProcess)debugProcess).getAdditionalBreakpointPopupMenuActions(breakpoint);
        }
        return super.getAdditionalPopupMenuActions(breakpoint, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpLineBreakpointType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpLineBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointAtLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPopupMenuActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

