/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSshConnection {
    private static final Logger LOG = Logger.getInstance(PhpSshConnection.class);
    public static final String EXPR_SSH_CONNECTION = "$_SERVER['SSH_CONNECTION']";
    private static final int DEFAULT_PORT = 22;
    private final String myHost;
    private final int myPort;

    private PhpSshConnection(@NotNull String host, int port) {
        if (host == null) {
            PhpSshConnection.$$$reportNull$$$0(0);
        }
        this.myHost = host;
        this.myPort = port;
    }

    @Nullable
    public static PhpSshConnection parse(@Nullable String line) {
        List data;
        int size;
        if (StringUtil.isNotEmpty((String)line) && (size = (data = StringUtil.split((String)line, (String)" ")).size()) >= 2) {
            String host = ((String)data.get(size - 2)).trim();
            int port = PhpSshConnection.parsePort(((String)data.get(size - 1)).trim());
            return new PhpSshConnection(host, port);
        }
        return null;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            PhpSshConnection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getPort() {
        return this.myPort;
    }

    private static int parsePort(@NotNull String port) {
        if (port == null) {
            PhpSshConnection.$$$reportNull$$$0(2);
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            LOG.info(PhpBundle.message("debug.error.cannot.parse.ssh.connection", port));
            return 22;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpSshConnection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpSshConnection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parsePort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

