/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.PhpDebugConnectionInfo;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugSessionLogger {
    private static final PhpDebugSessionLogger INSTANCE = new PhpDebugSessionLogger(new PhpSystemTimeProvider(), -1, 150);
    private final int myAllowedEventsRate;
    private final int myAllowedEventNumber;
    private final AtomicInteger myTotalEvents;
    private final PhpTimeProvider myTimeProvider;
    private final AtomicBoolean myRecordedTooMuchSessionsEvent;

    public PhpDebugSessionLogger(@NotNull PhpTimeProvider timeProvider, int allowedEventRate, int allowedDebugEvents) {
        if (timeProvider == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(0);
        }
        this.myTotalEvents = new AtomicInteger();
        this.myRecordedTooMuchSessionsEvent = new AtomicBoolean(false);
        this.myAllowedEventsRate = allowedEventRate;
        this.myAllowedEventNumber = allowedDebugEvents;
        this.myTimeProvider = timeProvider;
    }

    @NotNull
    public static PhpDebugSessionLogger getInstance() {
        PhpDebugSessionLogger phpDebugSessionLogger = INSTANCE;
        if (phpDebugSessionLogger == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(1);
        }
        return phpDebugSessionLogger;
    }

    public boolean isEnabled() {
        return StatisticsUploadAssistant.isCollectAllowed();
    }

    public void logDebugConfig(@NotNull PhpDebugConnectionInfo connection, @NotNull FeatureUsageData data) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(2);
        }
        if (data == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(3);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        this.logEvent("config", data);
    }

    public void logSessionStarted(@NotNull PhpDebugConnectionInfo connection, boolean isExternalConnection, boolean isZeroConfigConnection) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(4);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        DebugSessionType type = isZeroConfigConnection ? DebugSessionType.ZERO_CONFIG : (isExternalConnection ? DebugSessionType.WEB_SERVER : DebugSessionType.CLI);
        FeatureUsageData data = new FeatureUsageData().addData("type", StringUtil.toLowerCase((String)type.name())).addData("debugger", PhpDebugSessionLogger.getExtensionName(connection.getEngineName())).addVersion(connection.getEngineVersion()).addData("php_version", PhpDebugSessionLogger.parseVersion(connection.getPhpVersion()));
        this.logEvent("session.started", data);
    }

    public void logSessionEnded(@NotNull PhpDebugConnectionInfo connection) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(5);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        FeatureUsageData data = new FeatureUsageData().addData("debugger", PhpDebugSessionLogger.getExtensionName(connection.getEngineName()));
        this.logEvent("session.ended", data);
    }

    private boolean shouldRecordSession(@NotNull PhpDebugConnectionInfo connection, int totalEvents) {
        boolean shouldRecord;
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean bl = shouldRecord = totalEvents > 0 && totalEvents <= this.myAllowedEventNumber;
        if (!shouldRecord && this.myAllowedEventsRate > 0) {
            long interval = this.myTimeProvider.interval();
            boolean bl2 = shouldRecord = interval > 0L && (long)totalEvents <= interval / (long)this.myAllowedEventsRate;
        }
        if (!shouldRecord && this.myRecordedTooMuchSessionsEvent.compareAndSet(false, true)) {
            FeatureUsageData data = new FeatureUsageData().addData("debugger", PhpDebugSessionLogger.getExtensionName(connection.getEngineName()));
            this.logEvent("too.much.events", data);
        }
        return shouldRecord;
    }

    protected void logEvent(@NotNull String eventId, @NotNull FeatureUsageData data) {
        if (eventId == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(7);
        }
        if (data == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(8);
        }
        FUCounterUsageLogger.getInstance().logEvent("php.debug", eventId, data);
    }

    @NotNull
    private static String getExtensionName(@NotNull String debugExtensionName) {
        if (debugExtensionName == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(9);
        }
        boolean isSupportedExtension = StringUtil.equals((CharSequence)debugExtensionName, (CharSequence)XdebugExtension.INSTANCE.getName()) || StringUtil.equals((CharSequence)debugExtensionName, (CharSequence)ZendDebuggerExtension.INSTANCE.getName());
        return isSupportedExtension ? debugExtensionName : "unknown";
    }

    @NotNull
    private static String parseVersion(@Nullable String versionAsString) {
        if (versionAsString == null) {
            return "unknown";
        }
        Version version = Version.parseVersion((String)versionAsString);
        return version != null ? version.toCompactString() : "unknown.format";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugSessionLogger";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugExtensionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugSessionLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logDebugConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logSessionStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logSessionEnded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordSession";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpSystemTimeProvider
    implements PhpTimeProvider {
        private final long myInitTime = System.currentTimeMillis();

        private PhpSystemTimeProvider() {
        }

        @Override
        public long interval() {
            return System.currentTimeMillis() - this.myInitTime;
        }
    }

    public static interface PhpTimeProvider {
        public long interval();
    }

    public static enum DebugSessionType {
        CLI,
        WEB_SERVER,
        ZERO_CONFIG;

    }
}

