/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpApplicationDebugConfiguration;
import com.jetbrains.php.debug.PhpDebugAdvancedConfigurationsForm;
import com.jetbrains.php.debug.PhpDebugConfigInstructionsPanel;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.ConfigurableFormWithValidation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDebugConfigurableForm
implements ConfigurableFormWithValidation {
    public static final int MIN_SIMULTANEOUS_CONNECTIONS = 1;
    public static final int MAX_SIMULTANEOUS_CONNECTIONS = 20;
    private JPanel myMainPanel;
    private JTextField myZendDebuggerDebugPortField;
    private JTextField myXDebugDebugPortField;
    private JTextField myZendDebuggerSettingsBroadcastingPortField;
    private JCheckBox myXDebugCanAcceptExternalConnectionsCheckBox;
    private JCheckBox myZendDebuggerCanAcceptExternalConnectionsCheckBox;
    private JCheckBox myIgnoreConnectionsThroughUnregisteredServersCheckBox;
    private JBCheckBox myZendAutoDetectHostCheckbox;
    private JTextField myZendConfiguredHostField;
    private JBCheckBox myXdebugResolveBreakpoints;
    private JCheckBox myXdebugForceBreakWhenNoPathMappingCheckBox;
    private JCheckBox myForceBreakWhenOutsideProjectCheckBox;
    private JSpinner myMaxSimultaneousConnectionsSpinner;
    private JBCheckBox myZendDebuggerIgnoreZRaySystemRequests;
    private HideableTitledPanel myAdvancedSettingsHideablePanel;
    private JCheckBox myBreakAtFirstLineCheckBox;
    private JCheckBox myXdebugSafeEvaluationModeCheckBox;
    private JBCheckBox myImportUseStatementsCheckBox;
    private JBCheckBox myShowArrayChildrenInRepl;
    private JPanel myPreConfigurationPanel;
    private final PhpDebugAdvancedConfigurationsForm myAdvancedConfigurationsForm;
    private final Project myProject;
    private String myZendDebuggerConfiguredHost;

    public PhpDebugConfigurableForm(@NotNull Project project) {
        if (project == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myMaxSimultaneousConnectionsSpinner.setModel(new SpinnerNumberModel(1, 1, 20, 1));
        this.myAdvancedConfigurationsForm = new PhpDebugAdvancedConfigurationsForm();
        this.myAdvancedSettingsHideablePanel.setContentComponent(this.myAdvancedConfigurationsForm.getMainComponent());
        this.myAdvancedSettingsHideablePanel.setOn(false);
        this.myPreConfigurationPanel.add((Component)PhpDebugConfigInstructionsPanel.createZeroConfigurationInstructions(project), "Center");
        this.myZendAutoDetectHostCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpDebugConfigurableForm.this.updateZendConfiguredHostField();
            }
        });
    }

    private void updateZendConfiguredHostField() {
        if (this.myZendAutoDetectHostCheckbox.isSelected()) {
            this.myZendDebuggerConfiguredHost = StringUtil.notNullize((String)this.myZendConfiguredHostField.getText()).trim();
            this.updateHostAsynchronously((Consumer<? super String>)((Consumer)host -> this.myZendConfiguredHostField.setText((String)host)));
        } else {
            this.myZendConfiguredHostField.setText(this.myZendDebuggerConfiguredHost);
        }
        this.myZendConfiguredHostField.setEditable(!this.myZendAutoDetectHostCheckbox.isSelected());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public boolean isModified() {
        PhpApplicationDebugConfiguration.State appState = PhpApplicationDebugConfiguration.getInstance().getState();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        if (state.isSafeEvaluationMode() != this.myXdebugSafeEvaluationModeCheckBox.isSelected()) {
            return true;
        }
        if (state.isImportUseStatementsFromContext() != this.myImportUseStatementsCheckBox.isSelected()) {
            return true;
        }
        if (state.isShowArrayChildrenInRepl() != this.myShowArrayChildrenInRepl.isSelected()) {
            return true;
        }
        if (state.isIgnoreConnectionsThroughUnregisteredServers() != this.myIgnoreConnectionsThroughUnregisteredServersCheckBox.isSelected()) {
            return true;
        }
        if (state.isBreakAtFirstLine() != this.myBreakAtFirstLineCheckBox.isSelected()) {
            return true;
        }
        if (state.getMaxSimultaneousConnections() != this.getMaxSimultaneousConnections()) {
            return true;
        }
        if (!state.getXDebugDebugPorts().equals(this.getXDebugDebugPorts())) {
            return true;
        }
        if (state.isXDebugCanAcceptExternalConnections() != this.myXDebugCanAcceptExternalConnectionsCheckBox.isSelected()) {
            return true;
        }
        if (appState.isXdebugResolveBreakpoints() != this.myXdebugResolveBreakpoints.isSelected()) {
            return true;
        }
        if (state.isXdebugForceBreakWhenNoPathMapping() != this.myXdebugForceBreakWhenNoPathMappingCheckBox.isSelected()) {
            return true;
        }
        if (state.isXdebugForceBreakWhenOutsideProject() != this.myForceBreakWhenOutsideProjectCheckBox.isSelected()) {
            return true;
        }
        if (state.getZendDebuggerDebugPort() != this.getZendDebuggerDebugPort()) {
            return true;
        }
        if (state.isZendDebuggerCanAcceptExternalConnections() != this.myZendDebuggerCanAcceptExternalConnectionsCheckBox.isSelected()) {
            return true;
        }
        if (state.isZendDebuggerIgnoreZRaySystemRequests() != this.myZendDebuggerIgnoreZRaySystemRequests.isSelected()) {
            return true;
        }
        if (state.getZendDebuggerSettingsBroadcastingPort() != this.getZendDebuggerSettingsBroadcastingPort()) {
            return true;
        }
        if (state.isZendDebuggerAutoDetectHosts() != this.myZendAutoDetectHostCheckbox.isSelected()) {
            return true;
        }
        if (!state.getZendDebuggerConfiguredHosts().equals(this.getZendDebuggerConfiguredHost())) {
            return true;
        }
        return this.myAdvancedConfigurationsForm.isModified(state, appState);
    }

    @Override
    public void apply() {
        List<Integer> xDebugDebugPort = this.getXDebugDebugPorts();
        int zendDebuggerDebugPort = this.getZendDebuggerDebugPort();
        int zendDebuggerSettingsBroadcastingPort = this.getZendDebuggerSettingsBroadcastingPort();
        PhpApplicationDebugConfiguration.State appState = PhpApplicationDebugConfiguration.getInstance().getState();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        state.setSafeEvaluationMode(this.myXdebugSafeEvaluationModeCheckBox.isSelected());
        state.setImportUseStatementsFromContext(this.myImportUseStatementsCheckBox.isSelected());
        state.setShowArrayChildrenInRepl(this.myShowArrayChildrenInRepl.isSelected());
        state.setIgnoreConnectionsThroughUnregisteredServers(this.myIgnoreConnectionsThroughUnregisteredServersCheckBox.isSelected());
        state.setBreakAtFirstLine(this.myBreakAtFirstLineCheckBox.isSelected());
        state.setMaxSimultaneousConnections(this.getMaxSimultaneousConnections());
        state.setXDebugDebugPorts(xDebugDebugPort);
        state.setXDebugCanAcceptExternalConnections(this.myXDebugCanAcceptExternalConnectionsCheckBox.isSelected());
        appState.setXdebugResolveBreakpoints(this.myXdebugResolveBreakpoints.isSelected());
        state.setXdebugForceBreakWhenNoPathMapping(this.myXdebugForceBreakWhenNoPathMappingCheckBox.isSelected());
        state.setXdebugForceBreakWhenOutsideProject(this.myForceBreakWhenOutsideProjectCheckBox.isSelected());
        state.setZendDebuggerDebugPort(zendDebuggerDebugPort);
        state.setZendDebuggerCanAcceptExternalConnections(this.myZendDebuggerCanAcceptExternalConnectionsCheckBox.isSelected());
        state.setZendDebuggerAutoDetectHosts(this.myZendAutoDetectHostCheckbox.isSelected());
        state.setZendDebuggerConfiguredHosts(this.getZendDebuggerConfiguredHost());
        state.setZendDebuggerIgnoreZRaySystemRequests(this.myZendDebuggerIgnoreZRaySystemRequests.isSelected());
        state.setZendDebuggerSettingsBroadcastingPort(zendDebuggerSettingsBroadcastingPort);
        this.myAdvancedConfigurationsForm.apply(state, appState);
    }

    @Override
    public void reset() {
        PhpApplicationDebugConfiguration.State appState = PhpApplicationDebugConfiguration.getInstance().getState();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        this.myXdebugSafeEvaluationModeCheckBox.setSelected(state.isSafeEvaluationMode());
        this.myImportUseStatementsCheckBox.setSelected(state.isImportUseStatementsFromContext());
        this.myShowArrayChildrenInRepl.setSelected(state.isShowArrayChildrenInRepl());
        this.myIgnoreConnectionsThroughUnregisteredServersCheckBox.setSelected(state.isIgnoreConnectionsThroughUnregisteredServers());
        this.myBreakAtFirstLineCheckBox.setSelected(state.isBreakAtFirstLine());
        this.myMaxSimultaneousConnectionsSpinner.setValue(state.getMaxSimultaneousConnections());
        this.myXDebugDebugPortField.setText(PhpDebugConfigurableForm.convertXDebugPortsToString(state.getXDebugDebugPorts()));
        this.myXDebugCanAcceptExternalConnectionsCheckBox.setSelected(state.isXDebugCanAcceptExternalConnections());
        this.myXdebugResolveBreakpoints.setSelected(appState.isXdebugResolveBreakpoints());
        this.myXdebugForceBreakWhenNoPathMappingCheckBox.setSelected(state.isXdebugForceBreakWhenNoPathMapping());
        this.myForceBreakWhenOutsideProjectCheckBox.setSelected(state.isXdebugForceBreakWhenOutsideProject());
        this.myZendDebuggerDebugPortField.setText(String.valueOf(state.getZendDebuggerDebugPort()));
        this.myZendDebuggerCanAcceptExternalConnectionsCheckBox.setSelected(state.isZendDebuggerCanAcceptExternalConnections());
        boolean detectHosts = state.isZendDebuggerAutoDetectHosts();
        this.myZendAutoDetectHostCheckbox.setSelected(detectHosts);
        this.myZendConfiguredHostField.setEditable(!detectHosts);
        if (detectHosts) {
            this.updateHostAsynchronously((Consumer<? super String>)((Consumer)host -> this.initZendDebuggerHost((String)host)));
        } else {
            this.initZendDebuggerHost(state.getZendDebuggerConfiguredHosts());
        }
        this.myZendDebuggerIgnoreZRaySystemRequests.setSelected(state.isZendDebuggerIgnoreZRaySystemRequests());
        this.myZendDebuggerSettingsBroadcastingPortField.setText(String.valueOf(state.getZendDebuggerSettingsBroadcastingPort()));
        this.myAdvancedConfigurationsForm.reset(state, appState);
    }

    public void updateHostAsynchronously(final @NotNull Consumer<? super String> callback) {
        if (callback == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(2);
        }
        this.myZendConfiguredHostField.setText(PhpDebugConfigurableForm.getDetectingMessage());
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, PhpDebugConfigurableForm.getDetectingTitle()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                String host = PhpProjectDebugConfiguration.detectIdeHostSynchronously();
                if (PhpDebugConfigurableForm.this.myZendAutoDetectHostCheckbox.isSelected() && PhpDebugConfigurableForm.this.isDetectingHostsInProgress()) {
                    AppUIUtil.invokeOnEdt(() -> callback.consume((Object)host));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/debug/PhpDebugConfigurableForm$2", "run"));
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
    }

    private void initZendDebuggerHost(@NotNull String detectedHosts) {
        if (detectedHosts == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(3);
        }
        this.myZendDebuggerConfiguredHost = detectedHosts;
        this.myZendConfiguredHostField.setText(this.myZendDebuggerConfiguredHost);
    }

    @Override
    public void validate() throws ConfigurationException {
        List<Integer> xDebugDebugPorts = this.getXDebugDebugPorts();
        if (xDebugDebugPorts.isEmpty()) {
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.xdebug.debug.port", new Object[0])));
        }
        for (Integer xDebugDebugPort : xDebugDebugPorts) {
            if (xDebugDebugPort >= 0) continue;
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.xdebug.debug.port", new Object[0])));
        }
        int zendDebuggerDebugPort = this.getZendDebuggerDebugPort();
        if (zendDebuggerDebugPort < 0) {
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.zend.debug.port", new Object[0])));
        }
        int zendDebuggerSettingsBroadcastingPort = this.getZendDebuggerSettingsBroadcastingPort();
        if (zendDebuggerSettingsBroadcastingPort < 0) {
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.zend.settings.broadcasting.port", new Object[0])));
        }
        if (!this.myZendAutoDetectHostCheckbox.isSelected() && StringUtil.isEmpty((String)this.getZendDebuggerConfiguredHost())) {
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.zend.settings.ide.hosts", new Object[0])));
        }
    }

    @NotNull
    private static String convertXDebugPortsToString(List<Integer> ports) {
        String string = ports.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        if (string == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private List<Integer> getXDebugDebugPorts() {
        List ports = StringUtil.split((String)this.myXDebugDebugPortField.getText(), (String)",");
        List list = ContainerUtil.map((Collection)ports, port -> PhpUiUtil.getIntValue(port.trim()));
        if (list == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(5);
        }
        return list;
    }

    private int getZendDebuggerDebugPort() {
        return PhpUiUtil.getIntValue(this.myZendDebuggerDebugPortField.getText());
    }

    private int getZendDebuggerSettingsBroadcastingPort() {
        return PhpUiUtil.getIntValue(this.myZendDebuggerSettingsBroadcastingPortField.getText());
    }

    @NotNull
    private String getZendDebuggerConfiguredHost() {
        if (this.myZendAutoDetectHostCheckbox.isSelected()) {
            return "";
        }
        String string = this.isDetectingHostsInProgress() ? "" : StringUtil.notNullize((String)this.myZendConfiguredHostField.getText()).trim();
        if (string == null) {
            PhpDebugConfigurableForm.$$$reportNull$$$0(6);
        }
        return string;
    }

    private boolean isDetectingHostsInProgress() {
        return PhpDebugConfigurableForm.getDetectingMessage().equals(this.myZendConfiguredHostField.getText());
    }

    private int getMaxSimultaneousConnections() {
        return ((SpinnerNumberModel)this.myMaxSimultaneousConnectionsSpinner.getModel()).getNumber().intValue();
    }

    private void createUIComponents() {
        this.myAdvancedSettingsHideablePanel = new HideableTitledPanel(PhpBundle.message("framework.composer.add.dependency.settings.title", new Object[0]), false);
    }

    @Nls
    private static String getDetectingMessage() {
        return PhpBundle.message("PhpDebugConfigurable.zend.settings.ide.hosts.detect", new Object[0]);
    }

    @Nls
    private static String getDetectingTitle() {
        return PhpBundle.message("PhpDebugConfigurable.zend.settings.ide.hosts.detect.progress", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugConfigurableForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedHosts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugConfigurableForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertXDebugPortsToString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXDebugDebugPorts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getZendDebuggerConfiguredHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateHostAsynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initZendDebuggerHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JSpinner jSpinner;
        JTextField jTextField;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JCheckBox jCheckBox4;
        JTextField jTextField2;
        JTextField jTextField3;
        JBCheckBox jBCheckBox5;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JTextField jTextField4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.xdebug"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.debug.port"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myXDebugDebugPortField = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(140, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myXDebugCanAcceptExternalConnectionsCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.checkbox.can.accept.external.connections"));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myXdebugForceBreakWhenNoPathMappingCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.xdebug.force.break.no.path.mapping"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myForceBreakWhenOutsideProjectCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.xdebug.force.break.when.outside.project"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myXdebugResolveBreakpoints = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.xdebug.resolve.breakpoints"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.zend.debugger"), (int)0, (int)0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.debug.port"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, null, null, null));
        this.myZendDebuggerDebugPortField = jTextField3 = new JTextField();
        jPanel6.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(70, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.settings.broadcasting.port"));
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myZendDebuggerSettingsBroadcastingPortField = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(70, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myZendDebuggerCanAcceptExternalConnectionsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.checkbox.can.accept.external.connections"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myZendDebuggerIgnoreZRaySystemRequests = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setHorizontalTextPosition(4);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.checkbox.ignore.z.ray.system.requests"));
        jPanel6.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myZendAutoDetectHostCheckbox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.settings.auto.detect.ide.host"));
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myZendConfiguredHostField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.external.connections"), (int)0, (int)0, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("debug.label.max.simultaneous.connections"));
        jPanel8.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel8.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMaxSimultaneousConnectionsSpinner = jSpinner = new JSpinner();
        jPanel8.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 2, 2, 0, null, new Dimension(50, -1), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIgnoreConnectionsThroughUnregisteredServersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.ignore.external.connections.through.unregistered.server.configurations.label"));
        jPanel9.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBreakAtFirstLineCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.break.at.first.line"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.myAdvancedSettingsHideablePanel;
        hideableTitledPanel.setTitle(ResourceBundle.getBundle("messages/PhpBundle").getString("PhpDebugConfigurable.advanced.settings"));
        jPanel2.add((Component)hideableTitledPanel, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPreConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.zero.configuration"), (int)0, (int)0, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel10, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.evaluation"), (int)0, (int)0, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myXdebugSafeEvaluationModeCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.safe.evaluation.mode"));
        jPanel11.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel11.add((Component)spacer6, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowArrayChildrenInRepl = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.show.array.children.in.repl"));
        jPanel11.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImportUseStatementsCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugConfigurableForm.class).getString("PhpDebugConfigurable.import.use.statements"));
        jPanel11.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField4);
        jLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

