/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.servers.PhpServer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PhpServers", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PhpServersWorkspaceStateComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PhpServersWorkspaceStateComponent.class);
    private static final SerializationFilter myFilter = new SkipDefaultValuesSerializationFilters();
    private static final String SHARED_SERVER = "shared_server";
    private final Project myProject;
    private List<PhpServer> myServers = new ArrayList<PhpServer>();
    private final Map<String, Boolean> mySharedConfigurations = new THashMap();
    private final Map<String, List<PathMappingSettings.PathMapping>> myLibraryPathMappingsForShared = new THashMap();
    public final Condition<PathMappingSettings.PathMapping> myOutsideProject = new Condition<PathMappingSettings.PathMapping>(){

        public boolean value(PathMappingSettings.PathMapping mapping) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping.getLocalRoot());
            return file != null && !ProjectRootManager.getInstance((Project)PhpServersWorkspaceStateComponent.this.myProject).getFileIndex().isInContent(file);
        }
    };

    public PhpServersWorkspaceStateComponent(Project project) {
        this.myProject = project;
    }

    public static PhpServersWorkspaceStateComponent getInstance(@NotNull Project project) {
        if (project == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(0);
        }
        return (PhpServersWorkspaceStateComponent)ServiceManager.getService((Project)project, PhpServersWorkspaceStateComponent.class);
    }

    @XCollection(elementName="servers")
    public List<PhpServer> getServers() {
        return this.myServers;
    }

    public void setServers(@NotNull List<PhpServer> servers) {
        if (servers == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(1);
        }
        this.myServers = servers;
    }

    public Condition<PathMappingSettings.PathMapping> getNotInsideProjectCondition() {
        return this.myOutsideProject;
    }

    public Element getState() {
        Element root = new Element("state");
        List<PhpServer> servers = this.myServers;
        if (!servers.isEmpty()) {
            Element serversElement = new Element("servers");
            for (PhpServer server : servers) {
                this.serializeServerConfiguration(server, null, serversElement);
            }
            root.addContent(serversElement);
        }
        return root;
    }

    public void serializeServerConfiguration(@NotNull PhpServer server, @Nullable Condition<PathMappingSettings.PathMapping> mappingsFilter, @NotNull Element parent) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(3);
        }
        Element serverElement = XmlSerializer.serialize((Object)server, (SerializationFilter)myFilter);
        this.serializePathMappings(server, mappingsFilter, serverElement, parent);
    }

    public void serializePathMappings(@NotNull PhpServer server, @Nullable Condition<PathMappingSettings.PathMapping> mappingsFilter, @NotNull Element serverElement, @NotNull Element parent) {
        List mappings;
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(4);
        }
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(6);
        }
        List list = mappings = mappingsFilter == null ? server.getSerializedMappings() : ContainerUtil.filter(server.getSerializedMappings(), mappingsFilter);
        if (!mappings.isEmpty()) {
            Element mappingsRoot = new Element("path_mappings");
            for (PathMappingSettings.PathMapping mapping : mappings) {
                Element mappingElement = XmlSerializer.serialize((Object)mapping, (SerializationFilter)myFilter);
                mappingsRoot.addContent(mappingElement);
            }
            serverElement.addContent(mappingsRoot);
        }
        parent.addContent(serverElement);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(7);
        }
        this.clear(false);
        Element rootElement = this.extractServerRootElement(element);
        if (rootElement != null) {
            for (Element serverElement : rootElement.getChildren("server")) {
                PhpServer server = this.deserializeServerConfiguration(serverElement);
                if (server == null) continue;
                this.addServer(server, false);
            }
            List sharedServerElements = rootElement.getChildren(SHARED_SERVER);
            for (Element serverElement : sharedServerElements) {
                List<PathMappingSettings.PathMapping> mappings;
                Attribute id = serverElement.getAttribute("id");
                if (id == null || !StringUtil.isNotEmpty((String)id.getValue()) || (mappings = this.deserializePathMappings(serverElement)) == null) continue;
                this.myLibraryPathMappingsForShared.put(id.getValue(), mappings);
            }
        }
    }

    public void loadServers(@NotNull Element rootElement, boolean isShared) {
        if (rootElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(8);
        }
        this.removeConfigurations(isShared);
        for (Element serverElement : rootElement.getChildren("server")) {
            PhpServer server = this.deserializeServerConfiguration(serverElement);
            if (server == null) continue;
            this.addServer(server, isShared);
        }
        for (PhpServer server : this.myServers) {
            List<PathMappingSettings.PathMapping> libraryMappings;
            if (!this.isConfigurationShared(server) || (libraryMappings = this.myLibraryPathMappingsForShared.remove(server.getId())) == null || libraryMappings.isEmpty()) continue;
            List<PathMappingSettings.PathMapping> projectPathMappings = server.getMappings();
            if (projectPathMappings == null) {
                projectPathMappings = new ArrayList<PathMappingSettings.PathMapping>();
            }
            projectPathMappings.addAll(libraryMappings);
        }
    }

    @Nullable
    public PhpServer deserializeServerConfiguration(@NotNull Element serverElement) {
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(9);
        }
        PhpServer server = (PhpServer)XmlSerializer.deserialize((Element)serverElement, PhpServer.class);
        List<PathMappingSettings.PathMapping> mappings = this.deserializePathMappings(serverElement);
        if (mappings != null) {
            server.setSerializedMappings(mappings);
        }
        return server;
    }

    @Nullable
    private List<PathMappingSettings.PathMapping> deserializePathMappings(@NotNull Element serverElement) {
        List<Element> mappingElements;
        Element mappingRoot;
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(10);
        }
        if ((mappingRoot = serverElement.getChild("path_mappings")) != null && (mappingElements = this.extractMappings(mappingRoot)) != null) {
            ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>();
            for (Element mappingElement : mappingElements) {
                Attribute remotePath;
                Attribute localPath = mappingElement.getAttribute("local_path");
                if (localPath == null) {
                    localPath = mappingElement.getAttribute("local-root");
                }
                if ((remotePath = mappingElement.getAttribute("remote_path")) == null) {
                    remotePath = mappingElement.getAttribute("remote-root");
                }
                if (localPath == null || remotePath == null) continue;
                PathMappingSettings.PathMapping mapping = new PathMappingSettings.PathMapping(localPath.getValue(), remotePath.getValue());
                mappings.add(mapping);
            }
            return mappings;
        }
        return null;
    }

    public void addServer(@NotNull PhpServer server, boolean shared) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(11);
        }
        Iterator<PhpServer> iterator = this.myServers.iterator();
        while (iterator.hasNext()) {
            PhpServer phpServer = iterator.next();
            if (!StringUtil.equals((CharSequence)phpServer.getId(), (CharSequence)server.getId())) continue;
            if (shared) {
                LOG.info("Replacing existing server with the shared one with the same id");
                if (!phpServer.equals(server)) {
                    this.myLibraryPathMappingsForShared.put(phpServer.getId(), ContainerUtil.filter(phpServer.getMappings(), this.myOutsideProject));
                }
            } else {
                LOG.warn("Trying to create server '" + server.getName() + "' when another one with the same id exists");
            }
            iterator.remove();
        }
        this.myServers.add(server);
        this.mySharedConfigurations.put(server.getId(), shared);
    }

    @Nullable
    protected List<Element> extractMappings(@NotNull Element mappings) {
        List oldMappings;
        if (mappings == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(12);
        }
        if (!(oldMappings = mappings.getChildren("path_mapping")).isEmpty()) {
            return oldMappings;
        }
        return mappings.getChildren("mapping");
    }

    @Nullable
    protected Element extractServerRootElement(@NotNull Element element) {
        if (element == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(13);
        }
        List options = element.getChildren("option");
        for (Element option : options) {
            Attribute name = option.getAttribute("name");
            if (name == null || !name.getValue().equals("servers")) continue;
            return option;
        }
        return element.getChild("servers");
    }

    @NotNull
    public List<PhpServer> getPhpServerConfigurations(boolean shared) {
        List result = null;
        for (PhpServer configuration : this.myServers) {
            if (this.isConfigurationShared(configuration) != shared) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(configuration);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(14);
        }
        return list;
    }

    public boolean isConfigurationShared(@NotNull PhpServer server) {
        Boolean shared;
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(15);
        }
        return (shared = this.mySharedConfigurations.get(server.getId())) != null && shared != false;
    }

    public void setConfigurationShared(@NotNull PhpServer server, boolean shared) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(16);
        }
        if (this.isConfigurationShared(server) != shared) {
            this.mySharedConfigurations.put(server.getId(), shared);
        }
    }

    private void clear(boolean allConfigurations) {
        if (allConfigurations) {
            this.myServers.clear();
            this.mySharedConfigurations.clear();
            this.myLibraryPathMappingsForShared.clear();
        } else {
            this.myLibraryPathMappingsForShared.clear();
            this.removeConfigurations(false);
        }
    }

    public void removeConfigurations(boolean shared) {
        Iterator<PhpServer> it = this.myServers.iterator();
        while (it.hasNext()) {
            PhpServer server = it.next();
            if (this.isConfigurationShared(server) != shared) continue;
            if (shared) {
                this.mySharedConfigurations.put(server.getId(), false);
                continue;
            }
            it.remove();
            this.mySharedConfigurations.remove(server.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverElement";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpServersWorkspaceStateComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpServersWorkspaceStateComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpServerConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setServers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serializeServerConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializePathMappings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadServers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeServerConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializePathMappings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractServerRootElement";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationShared";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationShared";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

