/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpDeploymentAwareUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpImportPathMappingsDialog;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServerConfigurable;
import com.jetbrains.php.config.servers.PhpServersWorkspaceStateComponent;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestRunConfiguration;
import com.jetbrains.php.run.remoteDebug.PhpRemoteDebugRunConfiguration;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfiguration;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpServersConfigurable
extends PhpNamedCloneableItemsListEditor<PhpServer>
implements SearchableConfigurable {
    @NonNls
    private static final String SUBJ_DISPLAY_NAME = "server";
    private final Project myProject;

    public PhpServersConfigurable(@NotNull Project project) {
        if (project == null) {
            PhpServersConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public PhpServersConfigurable(final @NotNull Project project, @Nullable String initialElement) {
        if (project == null) {
            PhpServersConfigurable.$$$reportNull$$$0(1);
        }
        super(new Namer<PhpServer>(){

            public String getName(PhpServer phpServer) {
                return phpServer.getName();
            }

            public boolean canRename(PhpServer item) {
                return true;
            }

            public void setName(PhpServer server, String newName) {
                server.setName(newName);
            }
        }, () -> new PhpServer(), new PhpNamedCloneableItemsListEditor.Cloner<PhpServer>(){

            @Override
            @NotNull
            public PhpServer cloneOf(@NotNull PhpServer server) {
                if (server == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpServer phpServer = server.clone();
                if (phpServer == null) {
                    2.$$$reportNull$$$0(1);
                }
                return phpServer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = PhpServersConfigurable.SUBJ_DISPLAY_NAME;
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/config/servers/PhpServersConfigurable$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/config/servers/PhpServersConfigurable$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cloneOf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cloneOf";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new PhpNamedCloneableItemsListEditor.ItemsProvider<PhpServer>(){

            @Override
            @NotNull
            public List<PhpServer> getItems() {
                List<PhpServer> list = PhpProjectConfigurationFacade.getInstance(project).getServers();
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/config/servers/PhpServersConfigurable$3", "getItems"));
            }
        }, new PhpNamedCloneableItemsListEditor.ItemsConsumer<PhpServer>(){

            @Override
            public void applyItems(@NotNull List<PhpServer> items) {
                if (items == null) {
                    4.$$$reportNull$$$0(0);
                }
                PhpProjectConfigurationFacade.getInstance(project).updateServers(items);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/php/config/servers/PhpServersConfigurable$4", "applyItems"));
            }
        }, new PhpNamedCloneableItemsListEditor.ConfigurableFactory<PhpServer>(){

            @Override
            @NotNull
            public UnnamedConfigurable createConfigurable(@NotNull PhpServer item) {
                if (item == null) {
                    5.$$$reportNull$$$0(0);
                }
                return new PhpServerConfigurable(project, item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/php/config/servers/PhpServersConfigurable$5", "createConfigurable"));
            }
        }, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler<PhpServer>(){

            @Override
            public void onItemChanged(@NotNull PhpServer oldItem, @NotNull PhpServer newItem) {
                if (oldItem == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (newItem == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (StringUtil.equals((CharSequence)oldItem.getName(), (CharSequence)newItem.getName())) {
                    return;
                }
                RunManager manager = RunManager.getInstance((Project)project);
                ArrayList runConfigurations = new ArrayList(manager.getAllConfigurationsList());
                String oldName = oldItem.getName();
                String newName = newItem.getName();
                if (oldName != null && newName != null && !oldName.equals(newName)) {
                    for (RunConfiguration next : runConfigurations) {
                        Object settings;
                        if (next instanceof PhpRemoteDebugRunConfiguration) {
                            settings = (PhpRemoteDebugRunConfiguration.Settings)((PhpRemoteDebugRunConfiguration)next).getSettings();
                            if (!oldName.equals(((PhpRemoteDebugRunConfiguration.Settings)settings).getServerName())) continue;
                            ((PhpRemoteDebugRunConfiguration.Settings)settings).setServerName(newName);
                            continue;
                        }
                        if (next instanceof PhpWebAppRunConfiguration) {
                            settings = (PhpWebAppRunConfiguration.Settings)((PhpWebAppRunConfiguration)next).getSettings();
                            if (!oldName.equals(((PhpWebAppRunConfiguration.Settings)settings).getServerName())) continue;
                            ((PhpWebAppRunConfiguration.Settings)settings).setServerName(newName);
                            continue;
                        }
                        if (!(next instanceof PhpHttpRequestRunConfiguration) || !oldName.equals(((PhpHttpRequestRunConfiguration.Settings)(settings = (PhpHttpRequestRunConfiguration.Settings)((PhpHttpRequestRunConfiguration)next).getSettings())).getServerName())) continue;
                        ((PhpHttpRequestRunConfiguration.Settings)settings).setServerName(newName);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldItem";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newItem";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/servers/PhpServersConfigurable$6";
                objectArray[2] = "onItemChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, initialElement);
        this.setSubjectDisplayName(SUBJ_DISPLAY_NAME);
        this.myProject = project;
    }

    @Override
    @NotNull
    protected PhpServer cloneItem(PhpServer item) {
        PhpServer server = super.cloneItem(item);
        server.setId(PhpServer.getNextId());
        PhpServersWorkspaceStateComponent manager = PhpServersWorkspaceStateComponent.getInstance(this.myProject);
        manager.setConfigurationShared(server, manager.isConfigurationShared(item));
        PhpServer phpServer = server;
        if (phpServer == null) {
            PhpServersConfigurable.$$$reportNull$$$0(2);
        }
        return phpServer;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List actions = super.createActions(fromPopup);
        if (PhpDeploymentAwareUtil.isDeploymentPluginEnabled()) {
            ((ArrayList)actions).add(new ImportAction());
        }
        List list = actions;
        if (list == null) {
            PhpServersConfigurable.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected String suggestName(PhpServer server) {
        if (StringUtil.isNotEmpty((String)server.getName())) {
            String string = server.getName();
            if (string == null) {
                PhpServersConfigurable.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = super.suggestName(server);
        if (string == null) {
            PhpServersConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("configurable.PhpServersConfigurable.display.name", new Object[0]);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PhpServersConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getHelpTopic() {
        return "settings.php.debug.servers";
    }

    public static void openSettings(@NotNull Project project, @Nullable String selectedServer) {
        if (project == null) {
            PhpServersConfigurable.$$$reportNull$$$0(7);
        }
        PhpUiUtil.editConfigurable(project, (Configurable)new PhpServersConfigurable(project, selectedServer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpServersConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpServersConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ImportAction
    extends AnAction {
        public ImportAction() {
            super(PhpBundle.message("import", new Object[0]), PhpBundle.message("import.from.deployment.configuration", new Object[0]), AllIcons.ToolbarDecorator.Import);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            PhpServer server;
            if (event == null) {
                ImportAction.$$$reportNull$$$0(0);
            }
            PhpImportPathMappingsDialog dialog = new PhpImportPathMappingsDialog(PhpServersConfigurable.this.myProject);
            dialog.show();
            if (dialog.isOK() && (server = dialog.createServer()) != null) {
                PhpServersConfigurable.this.onItemCreated(server);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/config/servers/PhpServersConfigurable$ImportAction", "actionPerformed"));
        }
    }
}

