/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpPathMappingsConfigurable;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.ui.PhpDebuggerComboBox;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpServerConfigurableForm {
    private JPanel myMainPanel;
    private JTextField myHostTextField;
    private JTextField myPortTextField;
    private JPanel myMappingsPanel;
    private PhpDebuggerComboBox myDebuggerComboBox;
    private JPanel myErrorMessagePanel;
    private JLabel myErrorMessageLabel;
    private JLabel myDebuggerLabel;
    private final PhpPathMappingsConfigurable myPathMappingsConfigurable;
    private final PhpServer myServer;

    public PhpServerConfigurableForm(@NotNull Project project, @NotNull PhpServer server, boolean showDebugger) {
        if (project == null) {
            PhpServerConfigurableForm.$$$reportNull$$$0(0);
        }
        if (server == null) {
            PhpServerConfigurableForm.$$$reportNull$$$0(1);
        }
        this.myServer = server;
        this.$$$setupUI$$$();
        this.myPathMappingsConfigurable = new PhpPathMappingsConfigurable(project, server);
        JComponent component = this.myPathMappingsConfigurable.createComponent();
        assert (component != null);
        this.myMappingsPanel.add((Component)component, "Center");
        if (!showDebugger) {
            this.myDebuggerComboBox.setVisible(false);
            this.myDebuggerLabel.setVisible(false);
        }
        this.myErrorMessageLabel.setIcon(UIUtil.getBalloonErrorIcon());
        this.myErrorMessagePanel.setVisible(false);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (!this.myHostTextField.getText().equals(StringUtil.notNullize((String)this.myServer.getHost()))) {
            return true;
        }
        if (this.myServer.getPort() != PhpUiUtil.getIntValue(this.myPortTextField.getText())) {
            return true;
        }
        if (!this.myServer.getDebuggerId().equals(this.myDebuggerComboBox.getSelectedDebuggerId())) {
            return true;
        }
        return this.myPathMappingsConfigurable.isModified();
    }

    @Nullable
    @Nls
    public String validate() {
        int serverPort = PhpUiUtil.getIntValue(this.myPortTextField.getText());
        if (serverPort < 0) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpServerConfigurable.port", new Object[0]));
        }
        String host = this.myHostTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpServerConfigurable.host", new Object[0]));
        }
        return null;
    }

    public void apply() throws ConfigurationException {
        String error = this.validate();
        if (StringUtil.isNotEmpty((String)error)) {
            this.showMessage(error, UIUtil.getBalloonErrorIcon());
            throw new ConfigurationException(error);
        }
        int serverPort = PhpUiUtil.getIntValue(this.myPortTextField.getText());
        String host = this.myHostTextField.getText();
        this.myPathMappingsConfigurable.apply();
        this.myServer.setHost(host);
        this.myServer.setPort(serverPort);
        this.myServer.setDebuggerId(this.myDebuggerComboBox.getSelectedDebuggerId());
        this.hideMessage();
    }

    public void reset() {
        this.myHostTextField.setText(this.myServer.getHost());
        this.myPortTextField.setText(String.valueOf(this.myServer.getPort()));
        this.myDebuggerComboBox.setSelectedDebuggerId(this.myServer.getDebuggerId());
        this.myPathMappingsConfigurable.reset();
        this.hideMessage();
    }

    public void hideMessage() {
        this.myErrorMessagePanel.setVisible(false);
    }

    public void showMessage(@NotNull @Nls String result, @Nullable Icon icon) {
        if (result == null) {
            PhpServerConfigurableForm.$$$reportNull$$$0(2);
        }
        this.myErrorMessagePanel.setVisible(true);
        this.myErrorMessageLabel.setIcon(icon == null ? UIUtil.getBalloonErrorIcon() : icon);
        this.myErrorMessageLabel.setText(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/servers/PhpServerConfigurableForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        PhpDebuggerComboBox phpDebuggerComboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 5, 5, 5), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(":");
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 0, 0, null, new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpServerConfigurableForm.class).getString("PhpServerConfigurable.port.label"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpServerConfigurableForm.class).getString("PhpServerConfigurable.host.label"));
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpServerConfigurableForm.class).getString("PhpServerConfigurable.debugger.label"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerComboBox = phpDebuggerComboBox = new PhpDebuggerComboBox();
        jPanel4.add((Component)((Object)phpDebuggerComboBox), new GridConstraints(1, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myMappingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myErrorMessagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorMessageLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jTextField2);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

