/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServerConfigurable;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="server")
public class PhpServer
implements Cloneable {
    private static final Comparator<PathMappingSettings.PathMapping> ourPathMappingComparator = (o1, o2) -> {
        String localRoot1 = o1.getLocalRoot();
        String localRoot2 = o2.getLocalRoot();
        if (localRoot1 == null && localRoot2 == null) {
            return 0;
        }
        if (localRoot1 == null) {
            return 1;
        }
        if (localRoot2 == null) {
            return -1;
        }
        return localRoot1.compareTo(localRoot2);
    };
    private String myId;
    private String myName;
    private String myHost;
    private int myPort;
    private String myDebuggerId;
    private String myDeploymentServerId;
    private boolean myUsePathMappings;
    private List<PathMappingSettings.PathMapping> myMappings;

    public PhpServer() {
        this.myId = null;
        this.myName = null;
        this.myHost = null;
        this.myPort = 80;
        this.myDebuggerId = "php.debugger.XDebug";
        this.myDeploymentServerId = null;
        this.myUsePathMappings = false;
        this.myMappings = new ArrayList<PathMappingSettings.PathMapping>();
    }

    public PhpServer(@NotNull String serverName, @NotNull String host, int port, @NotNull String debuggerId, @NotNull List<? extends PathMappingSettings.PathMapping> mappings, boolean usePathMappings) {
        if (serverName == null) {
            PhpServer.$$$reportNull$$$0(0);
        }
        if (host == null) {
            PhpServer.$$$reportNull$$$0(1);
        }
        if (debuggerId == null) {
            PhpServer.$$$reportNull$$$0(2);
        }
        if (mappings == null) {
            PhpServer.$$$reportNull$$$0(3);
        }
        this.myId = null;
        this.myName = null;
        this.myHost = null;
        this.myPort = 80;
        this.myDebuggerId = "php.debugger.XDebug";
        this.myDeploymentServerId = null;
        this.myUsePathMappings = false;
        this.myMappings = new ArrayList<PathMappingSettings.PathMapping>();
        this.myName = serverName;
        this.myHost = host;
        this.myPort = port;
        this.myDebuggerId = debuggerId;
        this.myMappings = new ArrayList<PathMappingSettings.PathMapping>(mappings);
        this.myUsePathMappings = usePathMappings;
    }

    public PhpServer(@NotNull String serverName, @NotNull String host, int port, @NotNull String debuggerId, @NotNull List<? extends PathMappingSettings.PathMapping> mappings) {
        if (serverName == null) {
            PhpServer.$$$reportNull$$$0(4);
        }
        if (host == null) {
            PhpServer.$$$reportNull$$$0(5);
        }
        if (debuggerId == null) {
            PhpServer.$$$reportNull$$$0(6);
        }
        if (mappings == null) {
            PhpServer.$$$reportNull$$$0(7);
        }
        this(serverName, host, port, debuggerId, mappings, false);
    }

    public PhpServer(@NotNull String serverName, @NotNull String host, int port, @NotNull String debuggerId, boolean usePathMappings) {
        if (serverName == null) {
            PhpServer.$$$reportNull$$$0(8);
        }
        if (host == null) {
            PhpServer.$$$reportNull$$$0(9);
        }
        if (debuggerId == null) {
            PhpServer.$$$reportNull$$$0(10);
        }
        this(serverName, host, port, debuggerId, Collections.emptyList(), usePathMappings);
    }

    @NotNull
    public static String getNextId() {
        String string = UUID.randomUUID().toString();
        if (string == null) {
            PhpServer.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean equals(@NotNull String host, int port) {
        if (host == null) {
            PhpServer.$$$reportNull$$$0(12);
        }
        return host.equalsIgnoreCase(this.myHost) && this.myPort == port;
    }

    @Attribute(value="id")
    @NotNull
    public String getId() {
        if (this.myId == null) {
            this.myId = PhpServer.getNextId();
        }
        String string = this.myId;
        if (string == null) {
            PhpServer.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setId(String id) {
        this.myId = id;
    }

    @Attribute(value="name")
    @Nullable
    @NlsSafe
    public String getName() {
        return this.myName;
    }

    public void setName(@NlsSafe String name) {
        this.myName = StringUtil.nullize((String)name);
    }

    @Attribute(value="host")
    @Nullable
    @NlsSafe
    public String getHost() {
        return this.myHost;
    }

    public void setHost(@NotNull @NlsSafe String host) {
        if (host == null) {
            PhpServer.$$$reportNull$$$0(14);
        }
        this.myHost = StringUtil.nullize((String)host);
    }

    @Attribute(value="port")
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    @Attribute(value="debugger_id")
    @NotNull
    @NlsSafe
    public String getDebuggerId() {
        String string = this.myDebuggerId;
        if (string == null) {
            PhpServer.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setDebuggerId(@NotNull @NlsSafe String debuggerId) {
        if (debuggerId == null) {
            PhpServer.$$$reportNull$$$0(16);
        }
        this.myDebuggerId = debuggerId;
    }

    @Attribute(value="use_path_mappings")
    public boolean isUsePathMappings() {
        return this.myUsePathMappings;
    }

    public void setUsePathMappings(boolean usePathMappings) {
        this.myUsePathMappings = usePathMappings;
    }

    @Transient
    public List<PathMappingSettings.PathMapping> getMappings() {
        return this.myMappings;
    }

    public void setMappings(@NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (mappings == null) {
            PhpServer.$$$reportNull$$$0(17);
        }
        this.myMappings = mappings;
    }

    @Transient
    public List<PathMappingSettings.PathMapping> getSerializedMappings() {
        ArrayList<PathMappingSettings.PathMapping> serialized = new ArrayList<PathMappingSettings.PathMapping>();
        for (PathMappingSettings.PathMapping mapping : this.myMappings) {
            serialized.add(new PathMappingSettings.PathMapping(PhpConfigurationUtil.serializePath(mapping.getLocalRoot()), mapping.getRemoteRoot()));
        }
        ContainerUtil.sort(serialized, ourPathMappingComparator);
        return serialized;
    }

    public void setSerializedMappings(@NotNull List<PathMappingSettings.PathMapping> mappings) {
        if (mappings == null) {
            PhpServer.$$$reportNull$$$0(18);
        }
        ArrayList<PathMappingSettings.PathMapping> deserialized = new ArrayList<PathMappingSettings.PathMapping>();
        for (PathMappingSettings.PathMapping mapping : mappings) {
            deserialized.add(new PathMappingSettings.PathMapping(PhpConfigurationUtil.deserializePath(mapping.getLocalRoot()), mapping.getRemoteRoot()));
        }
        this.myMappings = deserialized;
    }

    public String getDeploymentServerId() {
        return this.myDeploymentServerId;
    }

    @Attribute(value="deployment_server")
    public void setDeploymentServerId(String deploymentServerId) {
        this.myDeploymentServerId = deploymentServerId;
    }

    public PhpServer clone() {
        PhpServer phpServer = new PhpServer();
        phpServer.myId = this.myId;
        phpServer.myName = this.myName;
        phpServer.myHost = this.myHost;
        phpServer.myPort = this.myPort;
        phpServer.myDebuggerId = this.myDebuggerId;
        phpServer.myUsePathMappings = this.myUsePathMappings;
        ArrayList<PathMappingSettings.PathMapping> pathMappings = new ArrayList<PathMappingSettings.PathMapping>();
        for (PathMappingSettings.PathMapping mapping : this.myMappings) {
            pathMappings.add(mapping.clone());
        }
        phpServer.myMappings = pathMappings;
        phpServer.myDeploymentServerId = this.myDeploymentServerId;
        return phpServer;
    }

    public void checkConfiguration(@NotNull Project project) throws RuntimeConfigurationException {
        if (project == null) {
            PhpServer.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getHost())) {
            throw new RuntimeConfigurationError(PhpBundle.message("dialog.message.server.host.cannot.be.empty", new Object[0]), PhpServer.createQuickFix(project, this));
        }
        if (this.getPort() < 0) {
            throw new RuntimeConfigurationError(PhpBundle.message("dialog.message.port.cannot.be.negative.number", new Object[0]), PhpServer.createQuickFix(project, this));
        }
    }

    private static Runnable createQuickFix(@NotNull Project project, @NotNull PhpServer server) {
        if (project == null) {
            PhpServer.$$$reportNull$$$0(20);
        }
        if (server == null) {
            PhpServer.$$$reportNull$$$0(21);
        }
        return () -> ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PhpServerConfigurable(project, server));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 3: 
            case 7: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpServer";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpServer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setHost";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setSerializedMappings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

