/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.ui.PhpAbstractFileTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPathMappingsTreeTable
extends PhpAbstractFileTreeTable<String> {
    public PhpPathMappingsTreeTable(@NotNull Project project, boolean suggestMirror, @NotNull Collection<String> fileSuggestions, @NotNull Collection<String> folderSuggestions) {
        if (project == null) {
            PhpPathMappingsTreeTable.$$$reportNull$$$0(0);
        }
        if (fileSuggestions == null) {
            PhpPathMappingsTreeTable.$$$reportNull$$$0(1);
        }
        if (folderSuggestions == null) {
            PhpPathMappingsTreeTable.$$$reportNull$$$0(2);
        }
        super(project, String.class, PhpBundle.message("debug.path.on.server", new Object[0]), new PhpAbstractFileTreeTable.ProjectRootNode[]{new PhpAbstractFileTreeTable.ProjectRootContentsNode(project, new PhpAbstractFileTreeTable.ProjectContentFileFilter(project)), new IncludePathRootNode(project)});
        this.setRowHeight(new JTextField().getPreferredSize().height);
        this.getValueColumn().setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected && !hasFocus && column == 1 && table.getValueAt(row, 1) == null && table.isCellEditable(row, column)) {
                    super.getTableCellRendererComponent(table, value, true, false, row, column);
                    this.setIcon(PlatformIcons.EDIT_IN_SECTION_ICON);
                    return this;
                }
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(null);
                return this;
            }
        });
        this.getValueColumn().setCellEditor(new MyCellEditor(fileSuggestions, folderSuggestions, suggestMirror));
    }

    @Override
    protected boolean isNullObject(String value) {
        return StringUtil.isEmptyOrSpaces((String)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileSuggestions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "folderSuggestions";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/config/servers/PhpPathMappingsTreeTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyIncludePathFileFilter
    implements VirtualFileFilter {
        private MyIncludePathFileFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                MyIncludePathFileFilter.$$$reportNull$$$0(0);
            }
            return file.isDirectory() || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/config/servers/PhpPathMappingsTreeTable$MyIncludePathFileFilter", "accept"));
        }
    }

    private static class IncludePathRootNode
    extends PhpAbstractFileTreeTable.ProjectRootNode {
        IncludePathRootNode(@NotNull Project project) {
            if (project == null) {
                IncludePathRootNode.$$$reportNull$$$0(0);
            }
            super(project, new MyIncludePathFileFilter());
        }

        @Override
        protected VirtualFile[] getRoots() {
            Project project = (Project)this.getObject();
            return VfsUtilCore.toVirtualFileArray(PhpIncludePathManager.getInstance(project).getRoots());
        }

        @Override
        @Nls
        protected String getPresentableText() {
            return PhpBundle.message("include.path", new Object[0]);
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return PlatformIcons.LIBRARY_ICON;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/config/servers/PhpPathMappingsTreeTable$IncludePathRootNode", "<init>"));
        }
    }

    private static final class MyCellEditor
    extends DefaultCellEditor {
        private final boolean mySuggestMirror;
        private final Collection<String> myFileSuggestions;
        private final Collection<String> myFolderSuggestions;

        private MyCellEditor(@NotNull Collection<String> fileSuggestions, @NotNull Collection<String> folderSuggestions, boolean suggestMirror) {
            if (fileSuggestions == null) {
                MyCellEditor.$$$reportNull$$$0(0);
            }
            if (folderSuggestions == null) {
                MyCellEditor.$$$reportNull$$$0(1);
            }
            super(new JComboBox());
            this.mySuggestMirror = suggestMirror;
            this.myFileSuggestions = fileSuggestions;
            this.myFolderSuggestions = folderSuggestions;
            JComboBox comboBox = this.getEditorComboBox();
            if (comboBox != null) {
                comboBox.setEditable(true);
                comboBox.setLightWeightPopupEnabled(true);
                comboBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, (Color)JBColor.GRAY));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox box;
            String initialValue;
            Component tableCellEditorComponent = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
            if (value instanceof String) {
                initialValue = (String)value;
                suggestions.add(initialValue);
            } else {
                initialValue = null;
            }
            suggestions.add("");
            Object valueAt = table.getValueAt(row, 0);
            if (valueAt instanceof VirtualFile) {
                String presentableUrl;
                VirtualFile file = (VirtualFile)valueAt;
                if (this.mySuggestMirror && !(presentableUrl = file.getPresentableUrl()).equals(initialValue)) {
                    suggestions.add(presentableUrl);
                }
                if (file.isDirectory()) {
                    suggestions.addAll(this.myFolderSuggestions);
                } else {
                    suggestions.addAll(this.myFileSuggestions);
                }
            }
            if ((box = (JComboBox)tableCellEditorComponent).getSelectedItem() instanceof String) {
                suggestions.add((String)box.getSelectedItem());
            }
            box.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(suggestions)));
            return tableCellEditorComponent;
        }

        @Override
        public boolean stopCellEditing() {
            Object item;
            JComboBox comboBox = this.getEditorComboBox();
            if (comboBox != null && (item = comboBox.getEditor().getItem()) != null) {
                comboBox.setSelectedItem(item);
            }
            return super.stopCellEditing();
        }

        @Nullable
        private JComboBox getEditorComboBox() {
            return this.editorComponent instanceof JComboBox ? (JComboBox)this.editorComponent : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileSuggestions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "folderSuggestions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/config/servers/PhpPathMappingsTreeTable$MyCellEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

