/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.UriUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServerConfigurableForm;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportPathMappingsForm {
    public static final int DEFAULT_PORT = 80;
    private final PhpServerConfigurableForm myConfigurableForm;
    private final ActionListener myDeploymentTypeListener;
    private WebServerCombo myWebServerCombo;
    private JTextField myPathToRootTextField;
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JBLabel myDeploymentLabel;
    private JBLabel myAbsolutePathDescriptionLabel;
    private JBLabel myPathToDeploymentRootLabel;
    private JBLabel myPathToMountedRootLabel;
    private JRadioButton myLocalRadioButton;
    private JRadioButton myMountedRadioButton;
    private JPanel myDeploymentTypePanel;
    private final DocumentAdapter myPathTextFieldListener;
    private final Project myProject;
    private final PhpServer myServer;
    @NotNull
    private final Alarm myReloadAlarm;
    private boolean myDisposed;

    public PhpImportPathMappingsForm(@NotNull Project project) {
        if (project == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(0);
        }
        this.myDisposed = false;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myServer = new PhpServer();
        this.myServer.setUsePathMappings(true);
        this.myDeploymentLabel.setLabelFor((Component)this.myWebServerCombo);
        this.myReloadAlarm = new Alarm();
        this.myReloadAlarm.setActivationComponent((JComponent)this.myMainPanel);
        this.myPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpImportPathMappingsForm.this.scheduleInfoComputation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/servers/PhpImportPathMappingsForm$1", "textChanged"));
            }
        };
        this.myPreviewPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("debug.server.import.configuration.preview.border.title", new Object[0])));
        this.myConfigurableForm = new PhpServerConfigurableForm(this.myProject, this.myServer, false);
        this.myPreviewPanel.add((Component)this.myConfigurableForm.createComponent(), "Center");
        this.myPathToDeploymentRootLabel.setText(PhpBundle.message("debug.server.import.configuration.path.to.remote.root", new Object[0]));
        this.myPathToDeploymentRootLabel.setToolTipText(PhpBundle.message("debug.server.import.configuration.path.to.remote.root.sftp.tooltip", new Object[0]));
        this.myPathToDeploymentRootLabel.setLabelFor((Component)this.myPathToRootTextField);
        this.myPathToMountedRootLabel.setText(PhpBundle.message("debug.server.import.configuration.path.to.remote.root.mounted.label", new Object[0]));
        this.myPathToMountedRootLabel.setToolTipText(PhpBundle.message("debug.server.import.configuration.path.to.remote.root.mounted.tooltip", new Object[0]));
        this.myPathToMountedRootLabel.setVisible(false);
        this.myPathToMountedRootLabel.setLabelFor((Component)this.myPathToRootTextField);
        this.myDeploymentTypePanel.setVisible(false);
        this.myAbsolutePathDescriptionLabel.setVisible(false);
        this.myPathToRootTextField.getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myWebServerCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebServerConfig server = PhpImportPathMappingsForm.this.myWebServerCombo.getSelectedServer();
                if (server != null && server.getFileTransferConfig().getAccessType() == AccessType.MOUNT) {
                    PhpImportPathMappingsForm.this.myDeploymentTypePanel.setVisible(true);
                    PhpImportPathMappingsForm.this.myPathToRootTextField.setVisible(PhpImportPathMappingsForm.this.myMountedRadioButton.isSelected());
                } else {
                    PhpImportPathMappingsForm.this.myDeploymentTypePanel.setVisible(false);
                    PhpImportPathMappingsForm.this.myPathToRootTextField.setVisible(true);
                }
                PhpImportPathMappingsForm.this.scheduleInfoComputation();
            }
        });
        this.myDeploymentTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpImportPathMappingsForm.this.myPathToRootTextField.setVisible(PhpImportPathMappingsForm.this.myMountedRadioButton.isSelected());
                PhpImportPathMappingsForm.this.scheduleInfoComputation();
            }
        };
        this.myMountedRadioButton.addActionListener(this.myDeploymentTypeListener);
        this.myLocalRadioButton.addActionListener(this.myDeploymentTypeListener);
        this.myConfigurableForm.reset();
        this.updateImportedSettings();
    }

    private void scheduleInfoComputation() {
        if (this.myDisposed) {
            return;
        }
        this.myReloadAlarm.cancelAllRequests();
        this.myReloadAlarm.addComponentRequest(() -> this.updateImportedSettings(), 200);
    }

    @NotNull
    private String getPathToRoot() {
        WebServerConfig server = this.myWebServerCombo.getSelectedServer();
        if (server != null && server.getFileTransferConfig().getAccessType() == AccessType.MOUNT && this.myLocalRadioButton.isSelected()) {
            String string = server.getFileTransferConfig().getMountedFolder();
            if (string == null) {
                PhpImportPathMappingsForm.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myPathToRootTextField.getText();
        if (string == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void updateImportedSettings() {
        String pathToRoot;
        WebServerConfig server;
        Pair selected = this.myWebServerCombo.getSelectedElement();
        String result = PhpImportPathMappingsForm.validate((Pair<WebServerGroupingWrap, WebServerConfig>)selected, server = (WebServerConfig)selected.second, pathToRoot = this.getPathToRoot());
        if (StringUtil.isNotEmpty((String)result)) {
            UIUtil.invokeAndWaitIfNeeded(() -> this.myConfigurableForm.showMessage(result, UIUtil.getBalloonWarningIcon()));
            return;
        }
        assert (server != null);
        String fullPathToRoot = DeploymentPathUtils.join((String)pathToRoot.trim(), (String)server.getFileTransferConfig().getRootFolder().trim());
        this.importConfiguration(server, fullPathToRoot);
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myConfigurableForm.reset();
            String validateResult = this.myConfigurableForm.validate();
            if (StringUtil.isNotEmpty((String)validateResult)) {
                this.myConfigurableForm.showMessage(validateResult, UIUtil.getBalloonErrorIcon());
            }
            this.updateRemotePathTextField(server, fullPathToRoot);
        });
    }

    private void updateRemotePathTextField(@NotNull WebServerConfig webServerConfig, @NotNull String fullPathToRoot) {
        if (webServerConfig == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(3);
        }
        if (fullPathToRoot == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(4);
        }
        AccessType accessType = webServerConfig.getFileTransferConfig().getAccessType();
        switch (accessType) {
            case FTP: 
            case SFTP: 
            case FTPS: {
                this.myPathToMountedRootLabel.setVisible(false);
                this.myPathToDeploymentRootLabel.setVisible(true);
                this.updateAbsolutePathTextField(PhpBundle.message("debug.server.import.configuration.path.to.remote.root.sftp", fullPathToRoot));
                break;
            }
            case MOUNT: {
                this.myPathToDeploymentRootLabel.setVisible(false);
                if (this.myLocalRadioButton.isSelected()) {
                    this.myPathToMountedRootLabel.setVisible(false);
                    this.updateAbsolutePathTextField(null);
                    break;
                }
                this.myPathToMountedRootLabel.setVisible(true);
                String localPath = webServerConfig.getFileTransferConfig().getMountedFolder().trim();
                String message = PhpBundle.message("debug.server.import.configuration.path.to.remote.root.mounted", localPath, fullPathToRoot);
                this.updateAbsolutePathTextField(message);
                break;
            }
            default: {
                this.updateAbsolutePathTextField(null);
            }
        }
    }

    private void updateAbsolutePathTextField(@Nullable @Nls String message) {
        if (StringUtil.isEmpty((String)message)) {
            this.myPathToRootTextField.setEnabled(false);
            this.myAbsolutePathDescriptionLabel.setVisible(false);
        } else {
            this.myPathToRootTextField.setEnabled(true);
            this.myAbsolutePathDescriptionLabel.setVisible(true);
            this.myAbsolutePathDescriptionLabel.setText(message);
        }
    }

    @Nullable
    private static String validate(Pair<WebServerGroupingWrap, WebServerConfig> selected, @Nullable WebServerConfig server, @NotNull String pathToRoot) {
        if (pathToRoot == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(5);
        }
        if (server == null) {
            return selected.first == null ? "Please, select deployment configuration to import settings" : "Please, select a server to import settings, not a group";
        }
        return null;
    }

    private void importConfiguration(@NotNull WebServerConfig webServerConfig, @NotNull String pathToDeploymentRoot) {
        List<PathMappingSettings.PathMapping> pathMappings;
        if (webServerConfig == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(6);
        }
        if (pathToDeploymentRoot == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(7);
        }
        this.myServer.setDeploymentServerId(webServerConfig.getId());
        this.myServer.setName(webServerConfig.getName());
        String url = webServerConfig.getUrl();
        Couple split = UriUtil.splitScheme((String)url);
        String simplifiedUrl = ((String)split.getSecond()).trim();
        String[] path = simplifiedUrl.split(":");
        if (path.length < 3) {
            this.myServer.setHost(path[0].trim());
            this.myServer.setPort(PhpImportPathMappingsForm.parsePort(path.length == 2 ? path[1] : null));
        } else {
            int endHost;
            int startHost = simplifiedUrl.indexOf("[");
            int n = endHost = startHost >= 0 ? simplifiedUrl.indexOf("]", startHost) : -1;
            if (startHost != -1 && endHost != -1) {
                this.myServer.setHost(simplifiedUrl.substring(startHost + 1, endHost));
                this.myServer.setPort(PhpImportPathMappingsForm.parsePort(endHost + 2 < simplifiedUrl.length() ? simplifiedUrl.substring(endHost + 2) : null));
            } else {
                this.myServer.setHost(simplifiedUrl);
                this.myServer.setPort(80);
            }
        }
        if (pathToDeploymentRoot.endsWith("/") || pathToDeploymentRoot.endsWith("\\")) {
            pathToDeploymentRoot = pathToDeploymentRoot.substring(0, pathToDeploymentRoot.length() - 1);
        }
        this.myServer.setUsePathMappings(!(pathMappings = PhpImportPathMappingsForm.getMappings(this.myProject, webServerConfig, pathToDeploymentRoot)).isEmpty());
        this.myServer.setMappings(pathMappings);
    }

    private static int parsePort(@Nullable String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            try {
                return Integer.parseInt(path);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 80;
    }

    @NotNull
    private static List<PathMappingSettings.PathMapping> getMappings(@NotNull Project project, @NotNull WebServerConfig webConfig, @NotNull String fullPathToRoot) {
        if (project == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(8);
        }
        if (webConfig == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(9);
        }
        if (fullPathToRoot == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(10);
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        ArrayList<PathMappingSettings.PathMapping> pathMappings = new ArrayList<PathMappingSettings.PathMapping>(mappings.size());
        for (DeploymentPathMapping mapping : mappings) {
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            pathMappings.add(new PathMappingSettings.PathMapping(mapping.getLocalPath(), DeploymentPathUtils.join((String)fullPathToRoot, (String)mapping.getDeployPath())));
        }
        ArrayList<PathMappingSettings.PathMapping> arrayList = pathMappings;
        if (arrayList == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public PhpServer getServer() {
        return this.myServer;
    }

    @NotNull
    protected JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpImportPathMappingsForm.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myWebServerCombo = new WebServerCombo(false, -1, false, false);
        this.myWebServerCombo.setPreferredSize(new Dimension(200, this.myWebServerCombo.getPreferredSize().height));
        this.myWebServerCombo.setProject(this.myProject);
        this.myWebServerCombo.resetToServerOrGroup(null);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myWebServerCombo);
        this.myPathToRootTextField.getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myMountedRadioButton.removeActionListener(this.myDeploymentTypeListener);
        this.myLocalRadioButton.removeActionListener(this.myDeploymentTypeListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myReloadAlarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpImportPathMappingsForm";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfig";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPathToRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToDeploymentRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpImportPathMappingsForm";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateRemotePathTextField";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myAbsolutePathDescriptionLabel = jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel3.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myDeploymentLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpImportPathMappingsForm.class).getString("debug.server.import.configuration.deployment"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        WebServerCombo webServerCombo = this.myWebServerCombo;
        jPanel5.add((Component)webServerCombo, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myPathToRootTextField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(1, 2, 1, 4, 0, 3, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPathToDeploymentRootLabel = jBLabel2 = new JBLabel();
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToMountedRootLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLocalRadioButton = jRadioButton2 = new JRadioButton();
        ((Component)jRadioButton2).setEnabled(true);
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpImportPathMappingsForm.class).getString("debug.server.import.configuration.local"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMountedRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpImportPathMappingsForm.class).getString("debug.server.import.configuration.mounted"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

