/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;

public class PhpInfoDialog
extends DialogWrapper {
    private final JEditorPane myPhpInfoEditorPane;
    @NotNull
    private final PhpInfo myPhpInfo;
    private final PhpNonPersistedInfo myPhpNonPersistedInfo;

    public PhpInfoDialog(@NotNull Project project, @NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        if (project == null) {
            PhpInfoDialog.$$$reportNull$$$0(0);
        }
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(1);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(2);
        }
        super(project, false);
        this.myPhpInfoEditorPane = new JEditorPane();
        this.myPhpInfo = phpInfo;
        this.myPhpNonPersistedInfo = phpNonPersistedInfo;
        this.init();
    }

    public PhpInfoDialog(@NotNull JComponent parent, @NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        if (parent == null) {
            PhpInfoDialog.$$$reportNull$$$0(3);
        }
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(4);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(5);
        }
        super((Component)parent, false);
        this.myPhpInfoEditorPane = new JEditorPane();
        this.myPhpInfo = phpInfo;
        this.myPhpNonPersistedInfo = phpNonPersistedInfo;
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(PhpBundle.message("php.information.dialog.title", new Object[0]));
        this.setModal(false);
        this.myPhpInfoEditorPane.setEditable(false);
        this.myPhpInfoEditorPane.setEditorKit(new HTMLEditorKit());
        this.myPhpInfoEditorPane.setDocument(new HTMLDocument());
        try {
            this.myPhpInfoEditorPane.read(new StringReader(PhpInfoDialog.toHtml(this.myPhpInfo, this.myPhpNonPersistedInfo)), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static String toHtml(@NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        String[] phpiniFiles;
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(6);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(7);
        }
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n    \"http://www.w3.org/TR/html4/loose.dtd\">");
        htmlBuilder.append("<html><body>");
        htmlBuilder.append("<h2><b> PHP version: </b>").append(phpInfo.getVersion()).append("</h2>");
        if (StringUtil.isNotEmpty((String)phpInfo.getCliPath())) {
            htmlBuilder.append("<b>PHP CLI: </b>").append(phpInfo.getCliPath()).append("<br/>");
        }
        htmlBuilder.append("<b>PHP CGI: </b>");
        if (StringUtil.isNotEmpty((String)phpInfo.getCgiPath())) {
            htmlBuilder.append(phpInfo.getCgiPath());
        } else {
            htmlBuilder.append("Not Installed <i>(php-cgi sapi is necessary to use built-in web server)</i>");
        }
        htmlBuilder.append("<br/>");
        htmlBuilder.append("<p><b>Loaded Configuration File: </b>");
        if (StringUtil.isNotEmpty((String)phpInfo.getConfigurationFile())) {
            htmlBuilder.append(phpInfo.getConfigurationFile());
        } else {
            htmlBuilder.append("Not Found");
        }
        htmlBuilder.append("</p>");
        if (StringUtil.isNotEmpty((String)phpInfo.getAdditionalPhpIni()) && (phpiniFiles = phpInfo.getAdditionalPhpIni().split(",")).length > 0) {
            htmlBuilder.append("<p><b>Additional .ini files parsed: </b><br/>");
            for (int i = 0; i < phpiniFiles.length - 1; ++i) {
                String phpini = phpiniFiles[i];
                htmlBuilder.append(phpini).append("<br/>");
            }
            htmlBuilder.append(phpiniFiles[phpiniFiles.length - 1]).append("</p>");
        }
        htmlBuilder.append("<p><b> Debugger extension: </b>");
        if (phpInfo.getDebuggers().isEmpty()) {
            htmlBuilder.append("Not Found");
        } else {
            htmlBuilder.append(StringUtil.join(phpInfo.getDebuggers(), (String)", "));
        }
        htmlBuilder.append("</p>");
        htmlBuilder.append("<p><b> Loaded extensions: </b>");
        htmlBuilder.append("<br/>");
        ArrayList<String> loadedExtensionsList = new ArrayList<String>(phpInfo.getLoadedExtensions());
        loadedExtensionsList.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        Iterator extensionsIterator = loadedExtensionsList.iterator();
        while (extensionsIterator.hasNext()) {
            htmlBuilder.append((String)extensionsIterator.next());
            if (!extensionsIterator.hasNext()) continue;
            htmlBuilder.append(", ");
        }
        htmlBuilder.append("</p>");
        htmlBuilder.append("<p><b> Configuration options: </b>");
        htmlBuilder.append("<br/>");
        htmlBuilder.append("<table>");
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(phpNonPersistedInfo.getConfigurationOptions().entrySet());
        entries.sort((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey()));
        for (Map.Entry entry : entries) {
            htmlBuilder.append("<tr>").append("<td>").append((String)entry.getKey()).append("</td>").append("<td>").append((String)entry.getValue()).append("</td>").append("</tr>");
        }
        htmlBuilder.append("</table>");
        htmlBuilder.append("</p>");
        htmlBuilder.append("</body></html>");
        String string = htmlBuilder.toString();
        if (string == null) {
            PhpInfoDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.myPhpInfoEditorPane);
    }

    protected String getDimensionServiceKey() {
        return "com.jetbrains.php.config.phpInfo.PhpInfo.PhpInfoDialog";
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            PhpInfoDialog.$$$reportNull$$$0(9);
        }
        return actionArray;
    }

    public static void show(@NotNull Project project, @NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        if (project == null) {
            PhpInfoDialog.$$$reportNull$$$0(10);
        }
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(11);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(12);
        }
        PhpInfoDialog dialog = new PhpInfoDialog(project, phpInfo, phpNonPersistedInfo);
        UIUtil.invokeLaterIfNeeded(() -> dialog.show());
    }

    public static void show(@NotNull JComponent parent, @NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        if (parent == null) {
            PhpInfoDialog.$$$reportNull$$$0(13);
        }
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(14);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(15);
        }
        PhpInfoDialog dialog = new PhpInfoDialog(parent, phpInfo, phpNonPersistedInfo);
        UIUtil.invokeLaterIfNeeded(() -> dialog.show());
    }

    public static NotificationListener createNotificationListener(final @NotNull Project project, final @NotNull PhpInfo phpInfo, final @NotNull PhpNonPersistedInfo phpNonPersistedInfo) {
        if (project == null) {
            PhpInfoDialog.$$$reportNull$$$0(16);
        }
        if (phpInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(17);
        }
        if (phpNonPersistedInfo == null) {
            PhpInfoDialog.$$$reportNull$$$0(18);
        }
        return new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                if (notification2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PhpInfoDialog.show(project, phpInfo, phpNonPersistedInfo);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/phpInfo/PhpInfoDialog$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpNonPersistedInfo";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/phpInfo/PhpInfoDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/phpInfo/PhpInfoDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

