/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.phpInfo.PhpBinaryType;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="phpinfo")
public class PhpInfo {
    private static final String DEFAULT_PHP_VERSION = "5.6.0";
    private static final String DEFAULT_PATH_SEPARATOR = ";";
    public static final String INCLUDE_PATH_OPTIONS_KEY = "include_path";
    @NotNull
    private String myVersion;
    @NotNull
    private String myPathSeparator;
    @NotNull
    private List<PhpDebuggerInfo> myDebuggers;
    @Nullable
    private @NlsContexts.Label String myWarning;
    @NotNull
    private Set<String> myLoadedExtensions;
    @Nullable
    private String myIncludePath;
    @Nullable
    private String myRemoteHost;
    @NotNull
    private String myConfigurationFile;
    @NotNull
    private String myAdditionalPhpIni;
    @NotNull
    private String myCliPath;
    @Nullable
    private String myCgiPath;
    @Nullable
    private PhpBinaryType myBinaryType;

    public PhpInfo() {
        this.myVersion = DEFAULT_PHP_VERSION;
        this.myPathSeparator = DEFAULT_PATH_SEPARATOR;
        this.myDebuggers = new SmartList();
        this.myWarning = null;
        this.myLoadedExtensions = new HashSet<String>();
        this.myRemoteHost = null;
        this.myConfigurationFile = "";
        this.myAdditionalPhpIni = "";
        this.myCliPath = "";
        this.myBinaryType = PhpBinaryType.PHP;
    }

    public PhpInfo(@NotNull String version, @NotNull String pathSeparator, @NotNull List<? extends PhpDebuggerInfo> debuggers, @NotNull Set<String> extensions, @NotNull Map<String, String> configurationOptions, @Nullable String configurationFile, @Nullable String additionalPhpIni, @Nullable String phpCli, @Nullable String phpCgi, @Nullable String remoteHost, @Nullable @NlsContexts.Label String warning, @Nullable PhpBinaryType type) {
        if (version == null) {
            PhpInfo.$$$reportNull$$$0(0);
        }
        if (pathSeparator == null) {
            PhpInfo.$$$reportNull$$$0(1);
        }
        if (debuggers == null) {
            PhpInfo.$$$reportNull$$$0(2);
        }
        if (extensions == null) {
            PhpInfo.$$$reportNull$$$0(3);
        }
        if (configurationOptions == null) {
            PhpInfo.$$$reportNull$$$0(4);
        }
        this.myVersion = DEFAULT_PHP_VERSION;
        this.myPathSeparator = DEFAULT_PATH_SEPARATOR;
        this.myDebuggers = new SmartList();
        this.myWarning = null;
        this.myLoadedExtensions = new HashSet<String>();
        this.myRemoteHost = null;
        this.myConfigurationFile = "";
        this.myAdditionalPhpIni = "";
        this.myCliPath = "";
        this.myBinaryType = PhpBinaryType.PHP;
        this.myVersion = version;
        this.myPathSeparator = pathSeparator;
        this.myDebuggers.addAll(debuggers);
        this.myRemoteHost = remoteHost;
        this.myLoadedExtensions = extensions;
        this.myConfigurationFile = StringUtil.notNullize((String)configurationFile);
        this.myAdditionalPhpIni = StringUtil.notNullize((String)additionalPhpIni);
        this.myCliPath = StringUtil.notNullize((String)phpCli);
        this.myCgiPath = phpCgi;
        this.myIncludePath = configurationOptions.get(INCLUDE_PATH_OPTIONS_KEY);
        this.myWarning = warning;
        this.myBinaryType = type;
    }

    @Attribute(value="version")
    @NotNull
    @NlsSafe
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setVersion(@NotNull @NlsSafe String version) {
        if (version == null) {
            PhpInfo.$$$reportNull$$$0(6);
        }
        this.myVersion = version;
    }

    @Transient
    @NotNull
    public String getShortVersion() {
        String version = this.getVersion();
        int separator = version.indexOf("-");
        String string = separator < 0 ? version : version.substring(0, separator);
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Attribute(value="path_separator")
    @NotNull
    public String getPathSeparator() {
        String string = this.myPathSeparator;
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setPathSeparator(@NotNull String pathSeparator) {
        if (pathSeparator == null) {
            PhpInfo.$$$reportNull$$$0(9);
        }
        this.myPathSeparator = pathSeparator;
    }

    @Tag(value="configuration_file")
    @NotNull
    public String getConfigurationFile() {
        String string = this.myConfigurationFile;
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setConfigurationFile(@NotNull String configurationFile) {
        if (configurationFile == null) {
            PhpInfo.$$$reportNull$$$0(11);
        }
        this.myConfigurationFile = configurationFile;
    }

    @Tag(value="additional_php_ini")
    @NotNull
    @NlsSafe
    public String getAdditionalPhpIni() {
        String string = this.myAdditionalPhpIni;
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setAdditionalPhpIni(@NotNull String additionalPhpIni) {
        if (additionalPhpIni == null) {
            PhpInfo.$$$reportNull$$$0(13);
        }
        this.myAdditionalPhpIni = additionalPhpIni;
    }

    @Attribute(value="php_cgi")
    @Nullable
    public String getCgiPath() {
        return this.myCgiPath;
    }

    public void setCgiPath(@Nullable String cgiPath) {
        this.myCgiPath = cgiPath;
    }

    @Attribute(value="php_cli")
    @NotNull
    public String getCliPath() {
        String string = this.myCliPath;
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setCliPath(@NotNull String cliPath) {
        if (cliPath == null) {
            PhpInfo.$$$reportNull$$$0(15);
        }
        this.myCliPath = cliPath;
    }

    @XCollection(propertyElementName="debuggers", elementName="debuggers")
    @NotNull
    public List<PhpDebuggerInfo> getDebuggers() {
        List<PhpDebuggerInfo> list = this.myDebuggers;
        if (list == null) {
            PhpInfo.$$$reportNull$$$0(16);
        }
        return list;
    }

    public void setDebuggers(@NotNull List<PhpDebuggerInfo> debuggers) {
        if (debuggers == null) {
            PhpInfo.$$$reportNull$$$0(17);
        }
        this.myDebuggers = debuggers;
    }

    @XCollection(propertyElementName="loaded_extensions", elementName="extension", valueAttributeName="name")
    @NotNull
    public Set<String> getLoadedExtensions() {
        Set<String> set = this.myLoadedExtensions;
        if (set == null) {
            PhpInfo.$$$reportNull$$$0(18);
        }
        return set;
    }

    public void setLoadedExtensions(@NotNull Set<String> loadedExtensions) {
        if (loadedExtensions == null) {
            PhpInfo.$$$reportNull$$$0(19);
        }
        this.myLoadedExtensions = loadedExtensions;
    }

    @Tag(value="configuration_options")
    @Deprecated
    @MapAnnotation(entryTagName="configuration_option", keyAttributeName="name", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    @NotNull
    public Map<String, String> getConfigurationOptions() {
        Map<String, String> map = this.myIncludePath == null ? Collections.emptyMap() : Collections.singletonMap(INCLUDE_PATH_OPTIONS_KEY, this.myIncludePath);
        if (map == null) {
            PhpInfo.$$$reportNull$$$0(20);
        }
        return map;
    }

    @Deprecated
    public void setConfigurationOptions(@Nullable Map<String, String> configurationOptions) {
        this.myIncludePath = configurationOptions != null ? configurationOptions.get(INCLUDE_PATH_OPTIONS_KEY) : null;
    }

    @Attribute(value="remote_host")
    @Nullable
    public String getRemoteHost() {
        if (StringUtil.isNotEmpty((String)this.myRemoteHost)) {
            List split = StringUtil.split((String)this.myRemoteHost, (String)" ");
            return split.isEmpty() ? this.myRemoteHost : (String)split.get(0);
        }
        return this.myRemoteHost;
    }

    public void setRemoteHost(@NotNull String remoteHost) {
        if (remoteHost == null) {
            PhpInfo.$$$reportNull$$$0(21);
        }
        this.myRemoteHost = remoteHost;
    }

    @Attribute(value="warning")
    @Nullable
    @NlsContexts.Label
    public String getWarning() {
        return this.myWarning;
    }

    public void setWarning(@Nullable @NlsContexts.Label String warning) {
        this.myWarning = warning;
    }

    @Attribute(value="binary_type")
    public void setBinaryType(@Nullable PhpBinaryType binaryType) {
        this.myBinaryType = binaryType;
    }

    @Nullable
    public PhpBinaryType getBinaryType() {
        return this.myBinaryType;
    }

    @Transient
    @NotNull
    public List<String> getIncludePath() {
        String includePath = this.myIncludePath;
        if (includePath != null) {
            List list = StringUtil.split((String)includePath, (String)this.getPathSeparator());
            if (list == null) {
                PhpInfo.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpInfo.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public String toPresentableString() {
        StringBuilder result = new StringBuilder("PHP ").append(this.myVersion);
        if (!this.myDebuggers.isEmpty()) {
            result.append(" with ");
            for (int i = 0; i < this.myDebuggers.size(); ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.myDebuggers.get(i).toString());
            }
        }
        String string = result.toString();
        if (string == null) {
            PhpInfo.$$$reportNull$$$0(24);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpInfo info = (PhpInfo)o;
        return this.getVersion().equals(info.getVersion()) && this.getPathSeparator().equals(info.getPathSeparator()) && this.getDebuggers().equals(info.getDebuggers()) && Objects.equals(this.getWarning(), info.getWarning()) && this.getLoadedExtensions().equals(info.getLoadedExtensions()) && Objects.equals(this.getIncludePath(), info.getIncludePath()) && Objects.equals(this.getRemoteHost(), info.getRemoteHost()) && this.getConfigurationFile().equals(info.getConfigurationFile()) && this.getAdditionalPhpIni().equals(info.getAdditionalPhpIni()) && this.getCliPath().equals(info.getCliPath()) && Objects.equals(this.getCgiPath(), info.getCgiPath()) && this.getBinaryType() == info.getBinaryType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getVersion(), this.getPathSeparator(), this.getDebuggers(), this.getWarning(), this.getLoadedExtensions(), this.getIncludePath(), this.getRemoteHost(), this.getConfigurationFile(), this.getAdditionalPhpIni(), this.getCliPath(), this.getCgiPath(), this.getBinaryType()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSeparator";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/phpInfo/PhpInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalPhpIni";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedExtensions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/phpInfo/PhpInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSeparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPhpIni";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedExtensions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPathSeparator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalPhpIni";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCliPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setLoadedExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

