/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpLibraryRoot;
import com.jetbrains.php.config.library.PhpLibraryRootProvider;
import com.jetbrains.php.ui.PhpUiUtil;
import icons.PhpIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRuntimeLibraryRootsProvider
extends AdditionalLibraryRootsProvider {
    private static final Logger LOG = Logger.getInstance(PhpRuntimeLibraryRootsProvider.class);
    private static final String GIT_VCS_NAME = "Git";
    private static final Key<SimpleModificationTracker> TRACKER = Key.create((String)"phpRuntimeLibraryRoots");

    @NotNull
    private static Set<VirtualFile> getLibraryRootsInternal(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(0);
        }
        Map<String, Boolean> extensions = PhpRuntimeConfiguration.getInstance(project).getExtensions();
        HashSet contentRoots = ContainerUtil.newHashSet((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
        Set set = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project)).peek(extension -> LOG.trace("Extension '" + extension.getName() + "' " + (extensions.getOrDefault(extension.getName(), true) != false ? "added" : "ignored")))).filter(extension -> extensions.getOrDefault(extension.getName(), true))).filter(extension -> !VfsUtilCore.isUnder((VirtualFile)extension, (Set)contentRoots))).toSet();
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getLibraryRootsBeforeFiltering(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(2);
        }
        LOG.trace("Collecting PHP Runtime modules...");
        Map modules = (Map)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)PhpLibraryRoot.EP_NAME.getExtensionList()).map(PhpLibraryRoot::getProvider).peek(provider -> LOG.trace("Provider '" + provider.getClass() + "' from '" + PathUtil.getJarPathForClass(provider.getClass()) + "'"))).filter(PhpLibraryRootProvider::isRuntime)).flatMap(provider -> provider.getLibraryRoots(project)).map(VirtualFile::getChildren).flatMap(Arrays::stream).filter(VirtualFile::isDirectory)).remove(module -> module.getName().startsWith("."))).peek(module -> LOG.trace("Module '" + module.getName() + "' " + (module.findChild(".ignore") == null ? "added" : "ignored")))).collect(Collectors.toMap(VirtualFile::getName, Function.identity(), (curr, next) -> next));
        Set<VirtualFile> set = modules.values().stream().filter(root -> root.findChild(".ignore") == null).collect(Collectors.toSet());
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !PhpRuntimeLibraryRootsProvider.hasWebModules(project)) {
            List<SyntheticLibrary> list = Collections.emptyList();
            if (list == null) {
                PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project);
        List<Object> list = roots.isEmpty() ? Collections.emptyList() : Collections.singletonList(new PhpRuntimeSyntheticLibrary(project, roots));
        if (list == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean hasWebModules(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(7);
        }
        return ContainerUtil.or((Object[])ModuleManager.getInstance((Project)project).getModules(), ModuleTypeWithWebFeatures::isAvailable);
    }

    @NotNull
    public static Set<VirtualFile> getLibraryRoots(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(8);
        }
        if (!TRACKER.isIn((UserDataHolder)project)) {
            TRACKER.set((UserDataHolder)project, (Object)new SimpleModificationTracker());
        }
        CachedValueProvider provider = () -> {
            Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRootsInternal(project);
            return PhpRuntimeLibraryRootsProvider.createCacheResult(roots, project, roots.toArray());
        };
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, provider);
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static <T> CachedValueProvider.Result<T> createCacheResult(@Nullable T value, @NotNull Project project, Object ... deps) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(10);
        }
        CachedValueProvider.Result result = CachedValueProvider.Result.create(value, (Object[])new Object[]{TRACKER.get((UserDataHolder)project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, deps});
        if (result == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(11);
        }
        return result;
    }

    @Deprecated
    @Nullable
    public static VirtualFile findFile(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(13);
        }
        return PhpRuntimeLibraryRootsProvider.getLibraryRoots(project).stream().map(root -> root.findChild(name)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static void fireRootsChanged(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(() -> PhpRuntimeLibraryRootsProvider.invalidateCache(project), false, true));
    }

    private static void invalidateCache(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(15);
        }
        LOG.trace("Cache invalidated");
        SimpleModificationTracker tracker = (SimpleModificationTracker)TRACKER.get((UserDataHolder)project);
        if (tracker != null) {
            tracker.incModificationCount();
        }
    }

    public static void applyNewStubsPath(@NotNull String previousDefaultStubsPath, @NotNull String newDefaultStubsPath, @NotNull Project project) {
        if (previousDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(16);
        }
        if (newDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(18);
        }
        PhpRuntimeLibraryRootsProvider.closePreviousStubFiles(project);
        PhpRuntimeLibraryRootsProvider.updateGitMappings(previousDefaultStubsPath, newDefaultStubsPath, project);
    }

    private static void closePreviousStubFiles(@NotNull Project project) {
        FileEditorManager fileEditorManager;
        Set<VirtualFile> roots;
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(19);
        }
        if (!(roots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project)).isEmpty() && (fileEditorManager = FileEditorManager.getInstance((Project)project)) != null) {
            ((StreamEx)((StreamEx)StreamEx.of((Object[])EditorFactory.getInstance().getAllEditors()).filter(editor -> editor.getProject() == project)).select(EditorEx.class).map(EditorEx::getVirtualFile).nonNull().filter(file -> VfsUtilCore.isUnder((VirtualFile)file, (Set)roots))).forEach(arg_0 -> ((FileEditorManager)fileEditorManager).closeFile(arg_0));
        }
    }

    private static void updateGitMappings(@NotNull String previousDefaultStubsPath, @NotNull String newDefaultStubsPath, @NotNull Project project) {
        VirtualFile git;
        VirtualFile file;
        if (previousDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(20);
        }
        if (newDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(21);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(22);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        List mappings = manager.getDirectoryMappings();
        if (!previousDefaultStubsPath.isEmpty()) {
            mappings = ContainerUtil.filter((Collection)mappings, mapping -> !mapping.getVcs().equals(GIT_VCS_NAME) || !mapping.getDirectory().equals(previousDefaultStubsPath));
        }
        if (!newDefaultStubsPath.isEmpty() && (file = VfsUtil.findFileByIoFile((File)new File(newDefaultStubsPath), (boolean)true)) != null && (git = file.findChild(".git")) != null && git.isDirectory()) {
            mappings = VcsUtil.addMapping((List)mappings, (String)newDefaultStubsPath, (String)GIT_VCS_NAME);
        }
        if (!previousDefaultStubsPath.isEmpty() || !newDefaultStubsPath.isEmpty()) {
            manager.setDirectoryMappings(mappings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousDefaultStubsPath";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDefaultStubsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsInternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsBeforeFiltering";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCacheResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsInternal";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsBeforeFiltering";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasWebModules";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCacheResult";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireRootsChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCache";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyNewStubsPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closePreviousStubFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateGitMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpRuntimeSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final Project myProject;
        private final Set<VirtualFile> myLibraryRoots;

        private PhpRuntimeSyntheticLibrary(@NotNull Project project, @NotNull Set<VirtualFile> libraryRoots) {
            if (project == null) {
                PhpRuntimeSyntheticLibrary.$$$reportNull$$$0(0);
            }
            if (libraryRoots == null) {
                PhpRuntimeSyntheticLibrary.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLibraryRoots = libraryRoots;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Set<VirtualFile> set = this.myLibraryRoots;
            if (set == null) {
                PhpRuntimeSyntheticLibrary.$$$reportNull$$$0(2);
            }
            return set;
        }

        public String getPresentableText() {
            return PhpBundle.message("PhpProjectConfigurable.php.runtime", new Object[0]);
        }

        public Icon getIcon(boolean unused) {
            return PhpIcons.PhpRuntime;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void navigate(boolean requestFocus) {
            PhpProjectConfigurable configurable = new PhpProjectConfigurable(this.myProject);
            configurable.openPhpRuntimeTab(false);
            PhpUiUtil.editConfigurable(this.myProject, (Configurable)configurable);
        }

        public String getNavigateActionText(boolean focusEditor) {
            return PhpBundle.message("action.configure.php.runtime.text", new Object[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PhpRuntimeSyntheticLibrary library = (PhpRuntimeSyntheticLibrary)((Object)o);
            return this.myLibraryRoots.equals(library.myLibraryRoots);
        }

        public int hashCode() {
            return this.myLibraryRoots.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider$PhpRuntimeSyntheticLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider$PhpRuntimeSyntheticLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

