/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.config.library.PhpLibraryRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhpIncludePathManager", storages={@Storage(value="php.xml")})
public final class PhpIncludePathManager
extends PhpAdditionalLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PhpIncludePathManager.class);
    public static final String PHP_LIBRARY_NAME = "PHP";
    private long myLastRootsChangeTimestampMillis;
    @NotNull
    private List<String> myIncludePaths;
    private volatile boolean myMuted;

    public static PhpIncludePathManager getInstance(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(0);
        }
        return (PhpIncludePathManager)project.getService(PhpIncludePathManager.class);
    }

    public PhpIncludePathManager(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(1);
        }
        super(project, LOG);
        this.myLastRootsChangeTimestampMillis = System.currentTimeMillis();
        this.myIncludePaths = new SmartList();
    }

    @Override
    public void projectOpened() {
        super.projectOpened();
        PhpIncludePathManager.deleteOldStyleLibrary(this.myProject, PHP_LIBRARY_NAME);
        PhpIncludePathManager.deleteOldStyleLibrary(this.myProject, "PHP Runtime");
    }

    @Override
    @NotNull
    protected Collection<VirtualFile> collectRoots() {
        List<VirtualFile> files = Collections.synchronizedList(new ArrayList());
        if (this.myProject.isDisposed()) {
            List<VirtualFile> list = files;
            if (list == null) {
                PhpIncludePathManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)this.myProject);
        for (String path : this.getIncludePath()) {
            VirtualFile includeRoot = null;
            if (FileUtil.isAbsolute((String)path)) {
                includeRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            } else if (baseDir != null) {
                includeRoot = baseDir.findFileByRelativePath(path);
            }
            if (includeRoot == null) continue;
            files.add(includeRoot);
        }
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PhpLibraryRoot.EP_NAME.extensions().map(PhpLibraryRoot::getProvider).filter(provider -> !provider.isRuntime()).flatMap(provider -> provider.getLibraryRoots(this.myProject)).forEach(files::add);
        });
        List<VirtualFile> list = files;
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<String> getIncludePath() {
        this.ensureOldPathsSynchronized(null);
        return new ArrayList<String>(this.myIncludePaths);
    }

    public void setIncludePath(@NotNull List<String> includePath) {
        if (includePath == null) {
            PhpIncludePathManager.$$$reportNull$$$0(4);
        }
        HashSet<String> initialIncludePaths = new HashSet<String>(this.myIncludePaths);
        SmartList addedOldPaths = new SmartList();
        this.ensureOldPathsSynchronized((List<String>)addedOldPaths);
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.prepareAsIncludePaths(includePath));
        this.myIncludePaths.addAll((Collection<String>)addedOldPaths);
        HashSet<String> newIncludePaths = new HashSet<String>(this.myIncludePaths);
        if (newIncludePaths.equals(initialIncludePaths)) {
            return;
        }
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        configuration.setIncludePath(this.myIncludePaths);
        long timestamp = System.currentTimeMillis();
        long delta = timestamp - this.myLastRootsChangeTimestampMillis;
        if (delta < 10000L && !this.myMuted) {
            LOG.warn("Frequent include path update. Delta " + delta + ", old path: " + initialIncludePaths + "\nnew path: " + this.myIncludePaths);
        }
        this.myLastRootsChangeTimestampMillis = timestamp;
        if (!this.myProject.isDefault()) {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> {
                this.myWorkSynchronouslyInHeadlessEnvironment = true;
                try {
                    PhpAdditionalLibraryManager.fireLibraryChanged(this.myProject);
                }
                finally {
                    this.myWorkSynchronouslyInHeadlessEnvironment = false;
                }
            });
        }
    }

    public void setMutedForTest(boolean muted) {
        this.myMuted = muted;
    }

    @Override
    protected void updateProjectLibrary(@Nullable AtomicBoolean changed) {
        if (this.myMuted) {
            return;
        }
        super.updateProjectLibrary(changed);
    }

    @Override
    protected void modifyLibraries(@Nullable VirtualFile fileToAdd, boolean removeInvalidFiles) {
        if (this.myMuted) {
            return;
        }
        super.modifyLibraries(fileToAdd, removeInvalidFiles);
    }

    @NotNull
    public State getState() {
        State state = new State();
        state.setSerializedIncludePath(this.myIncludePaths);
        State state2 = state;
        if (state2 == null) {
            PhpIncludePathManager.$$$reportNull$$$0(5);
        }
        return state2;
    }

    @NotNull
    private static List<String> prepareAsIncludePaths(List<String> includePaths) {
        List list = ContainerUtil.map(includePaths, path -> FileUtil.toSystemIndependentName((String)path));
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpIncludePathManager.$$$reportNull$$$0(7);
        }
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.prepareAsIncludePaths(state.getSerializedIncludePath()));
        this.ensureOldPathsSynchronized(null);
    }

    private void ensureOldPathsSynchronized(@Nullable List<String> addedOldPaths) {
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        List<String> oldIncludePath = PhpIncludePathManager.prepareAsIncludePaths(configuration.getIncludePath());
        for (String path : oldIncludePath) {
            if (this.myIncludePaths.contains(path)) continue;
            this.myIncludePaths.add(path);
            if (addedOldPaths == null) continue;
            addedOldPaths.add(path);
        }
        configuration.setIncludePath(this.myIncludePaths);
    }

    public static boolean isInProject(@NotNull VirtualFile file, @NotNull ProjectFileIndex projectFileIndex, @NotNull List<VirtualFile> includeRoots) {
        if (file == null) {
            PhpIncludePathManager.$$$reportNull$$$0(8);
        }
        if (projectFileIndex == null) {
            PhpIncludePathManager.$$$reportNull$$$0(9);
        }
        if (includeRoots == null) {
            PhpIncludePathManager.$$$reportNull$$$0(10);
        }
        if (projectFileIndex.isInContent(file)) {
            return true;
        }
        for (VirtualFile root : includeRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAsIncludePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setIncludePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        private List<String> myIncludePath = new ArrayList<String>();

        @XCollection(propertyElementName="include_path", elementName="path")
        public List<String> getSerializedIncludePath() {
            return this.myIncludePath;
        }

        public void setSerializedIncludePath(@NotNull List<String> includePaths) {
            if (includePaths == null) {
                State.$$$reportNull$$$0(0);
            }
            this.myIncludePath = includePaths;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includePaths", "com/jetbrains/php/config/library/PhpIncludePathManager$State", "setSerializedIncludePath"));
        }
    }

    static final class IncludePathStartupActivity
    implements StartupActivity.DumbAware {
        IncludePathStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                IncludePathStartupActivity.$$$reportNull$$$0(0);
            }
            PhpIncludePathManager.getInstance(project).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/config/library/PhpIncludePathManager$IncludePathStartupActivity", "runActivity"));
        }
    }
}

