/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.StringSetDataExternalizer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtensionStubsMetadataProvider {
    private static final VirtualFileGist<Set<String>> GIST = GistManager.getInstance().newVirtualFileGist("PhpExtensionStubsMetadataProvider", PhpClassAliasUtil.getVersion() + 1, (DataExternalizer)StringSetDataExternalizer.INSTANCE, (project, file) -> {
        THashSet signatures = new THashSet();
        if (file.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0], (Set)signatures){
                final /* synthetic */ Set val$signatures;
                {
                    this.val$signatures = set;
                    super(arg0);
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory()) {
                        PsiFile psiFile = PhpExtensionStubsMetadataProvider.getPsiFile(project, file);
                        if (psiFile instanceof PhpFile) {
                            for (Map.Entry entry : ((PhpFile)psiFile).getTopLevelDefs().entrySet()) {
                                String fqn = (String)entry.getKey();
                                for (PhpNamedElement element : (Collection)entry.getValue()) {
                                    if (element instanceof PhpClass) {
                                        this.val$signatures.add(PhpTypeSignatureKey.CLASS.sign((CharSequence)fqn));
                                        continue;
                                    }
                                    if (element instanceof Function) {
                                        this.val$signatures.add(PhpTypeSignatureKey.FUNCTION.sign((CharSequence)fqn));
                                        continue;
                                    }
                                    if (!(element instanceof Constant)) continue;
                                    this.val$signatures.add(PhpTypeSignatureKey.CONSTANT.sign((CharSequence)fqn));
                                }
                            }
                            CharSequence contents = psiFile.getViewProvider().getContents();
                            List providers = PhpClassAliasUtil.getRelevantProviders((CharSequence)contents);
                            PhpClassAliasUtil.processClassAliasDeclarations((PsiElement)psiFile, (Collection)providers, (reference, result) -> this.val$signatures.add(PhpTypeSignatureKey.CLASS.sign((CharSequence)result.getAliasFqn())));
                        }
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider$1", "visitFile"));
                }
            });
        }
        return signatures;
    });

    @Nullable
    private static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psi;
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(1);
        }
        if (!((psi = PsiManager.getInstance((Project)project).findFile(file)) instanceof PsiFileImpl) || ((PsiFileImpl)psi).isContentsLoaded()) {
            return psi;
        }
        return FileContentImpl.createFileFromText((Project)project, (CharSequence)psi.getViewProvider().getContents(), (LanguageFileType)PhpFileType.INSTANCE, (VirtualFile)file, (String)file.getName());
    }

    @Nullable
    public static String findDisabledExtension(@NotNull Project project, @NotNull String signature) {
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(2);
        }
        if (signature == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(3);
        }
        Map signatureToDisabledExtension = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> PhpRuntimeLibraryRootsProvider.createCacheResult(PhpExtensionStubsMetadataProvider.getSignatureToDisabledExtension(project), project, new Object[0]));
        return (String)signatureToDisabledExtension.get(signature);
    }

    @NotNull
    private static Map<String, String> getSignatureToDisabledExtension(@NotNull Project project) {
        Set<Map.Entry<String, Boolean>> extensions;
        Set disabledExtensions;
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(4);
        }
        if ((disabledExtensions = ((StreamEx)StreamEx.of(extensions = PhpRuntimeConfiguration.getInstance(project).getExtensions().entrySet()).filter(entry -> (Boolean)entry.getValue() == false)).map(Map.Entry::getKey).toSet()).isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(5);
            }
            return map;
        }
        Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project);
        Map nameToRoot = StreamEx.of(roots).toMap(VirtualFile::getName, x -> x);
        TreeMap<String, String> signatureToDisabledExtension = new TreeMap<String, String>(String::compareToIgnoreCase);
        for (String extension : disabledExtensions) {
            VirtualFile root = (VirtualFile)nameToRoot.get(extension);
            if (root == null) continue;
            for (String signature : (Set)GIST.getFileData(project, root)) {
                signatureToDisabledExtension.put(signature, extension);
            }
        }
        TreeMap<String, String> treeMap = signatureToDisabledExtension;
        if (treeMap == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(6);
        }
        return treeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureToDisabledExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDisabledExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureToDisabledExtension";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

