/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.ui.PhpUiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpEmbeddedStubsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"php.embedded.stubs.notification.provider");
    private static final String DO_NOT_SHOW_PROPERTY = "php.embedded.stubs.notification.provider.do.not.show.again.property";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(3);
        }
        if (PropertiesComponent.getInstance().isTrueValue(DO_NOT_SHOW_PROPERTY)) {
            return null;
        }
        if (fileEditor instanceof TextEditor && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE) && "stubs".equals(PhpEmbeddedStubsNotificationProvider.getStubsRootName(file)) && PhpEmbeddedStubsNotificationProvider.isEmbeddedPhpRuntime(file)) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel();
            panel2.setText(PhpBundle.message("php.embedded.stubs.notification.provider.notification", new Object[0]));
            panel2.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.clone", new Object[0]), () -> BrowserUtil.browse((String)"https://github.com/JetBrains/phpstorm-stubs/"));
            panel2.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.provide", new Object[0]), () -> {
                PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                configurable.openPhpRuntimeTab(true);
                PhpUiUtil.editConfigurable(project, (Configurable)configurable);
            });
            panel2.createActionLabel(PhpBundle.message("php.embedded.stubs.notification.provider.do.not.show.again", new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(DO_NOT_SHOW_PROPERTY, "true");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            return panel2;
        }
        return null;
    }

    private static boolean isEmbeddedPhpRuntime(@NotNull VirtualFile file) {
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(4);
        }
        String path = file.getPath();
        if (ApplicationManager.getApplication().isInternal() && path.contains("/out/classes/production/intellij.php.impl/stubs/")) {
            return true;
        }
        return file.getFileSystem() instanceof JarFileSystem && path.contains("/php.jar!/stubs/");
    }

    @Nullable
    private static String getStubsRootName(@NotNull VirtualFile file) {
        VirtualFile root;
        VirtualFile parent;
        if (file == null) {
            PhpEmbeddedStubsNotificationProvider.$$$reportNull$$$0(5);
        }
        if ((parent = file.getParent()) != null && (root = parent.getParent()) != null) {
            return root.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpEmbeddedStubsNotificationProvider";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpEmbeddedStubsNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEmbeddedPhpRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStubsRootName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

