/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAdditionalLibraryManager
implements ModuleRootListener,
Disposable {
    private final Logger LOG;
    private static final Comparator<VirtualFile> FILE_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getUrl(), (String)o2.getUrl(), (boolean)false);
    protected final Project myProject;
    private final Object ROOTS_WRITE_LOCK;
    private volatile List<VirtualFile> myRoots;
    private long myLastRootsChangeTimestampMillis;
    private final Alarm myUpdateLibraryAlarm;
    protected boolean myWorkSynchronouslyInHeadlessEnvironment;

    protected PhpAdditionalLibraryManager(@NotNull Project project, @NotNull Logger logger) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(1);
        }
        this.ROOTS_WRITE_LOCK = new Object();
        this.myRoots = new SortedList(FILE_COMPARATOR);
        this.myProject = project;
        this.LOG = logger;
        this.myUpdateLibraryAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public List<VirtualFile> getRoots() {
        List<VirtualFile> roots = Collections.unmodifiableList(this.myRoots);
        this.LOG.trace("myRoots " + roots);
        return roots;
    }

    public void projectOpened() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect((Disposable)this.myUpdateLibraryAlarm).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(this::scheduleLibraryUpdate);
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        this.LOG.trace("Roots changed " + event);
        this.scheduleLibraryUpdate();
    }

    private void scheduleLibraryUpdate() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (this.myWorkSynchronouslyInHeadlessEnvironment) {
                this.updateProjectLibrary(null);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.updateProjectLibrary(null));
            }
        } else {
            this.myUpdateLibraryAlarm.cancelAllRequests();
            this.myUpdateLibraryAlarm.addRequest(() -> this.updateProjectLibrary(null), 10);
        }
    }

    protected void updateProjectLibrary(@Nullable AtomicBoolean changed) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Collection<VirtualFile> roots = this.collectRoots();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (this.LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found roots: ");
            for (VirtualFile root : roots) {
                stringBuilder.append(root.getPath()).append('\n');
            }
            this.LOG.trace(stringBuilder.toString());
        }
        this.applyRootsChange(roots, true, false, changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRootsChange(@NotNull Collection<? extends VirtualFile> rootsToAdd, boolean reset, boolean removeInvalid, @Nullable AtomicBoolean changed) {
        boolean isChanged;
        if (rootsToAdd == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(3);
        }
        if (this.LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Applying change, reset ").append(reset).append(", removeInvalid ").append(removeInvalid).append("\nTo add:\n");
            for (VirtualFile object : rootsToAdd) {
                sb.append(object.getPath()).append('\n');
            }
            this.LOG.trace(sb.toString());
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        SortedList newRoots = new SortedList(FILE_COMPARATOR);
        Object object = this.ROOTS_WRITE_LOCK;
        synchronized (object) {
            if (!reset) {
                for (VirtualFile file : this.myRoots) {
                    if (removeInvalid && !file.isValid()) continue;
                    this.LOG.trace("Retained " + file.getPath());
                    newRoots.add(file);
                }
            }
            this.addPatchedRoots(rootsToAdd, (List<? super VirtualFile>)newRoots);
            boolean bl = isChanged = !this.myRoots.equals(newRoots);
            if (isChanged) {
                long timestamp = System.currentTimeMillis();
                long delta = timestamp - this.myLastRootsChangeTimestampMillis;
                if (delta < 10000L) {
                    this.LOG.warn("Frequent root change. Source " + this.getClass() + ", delta " + delta + ".\n" + PhpAdditionalLibraryManager.getDescription(this.myRoots, (List<? extends VirtualFile>)newRoots));
                }
                this.myLastRootsChangeTimestampMillis = timestamp;
                this.myRoots = newRoots;
            }
        }
        if (!(!isChanged || ApplicationManager.getApplication().isHeadlessEnvironment() && this.myWorkSynchronouslyInHeadlessEnvironment)) {
            PhpAdditionalLibraryManager.fireLibraryChanged(this.myProject);
        }
        if (changed != null) {
            changed.set(isChanged);
        }
    }

    private static String getDescription(List<? extends VirtualFile> oldRoots, List<? extends VirtualFile> newRoots) {
        String rootList = "Old roots: " + oldRoots + "\nNew Roots: " + newRoots;
        if (oldRoots.size() != newRoots.size()) {
            return rootList;
        }
        for (int i = 0; i < oldRoots.size(); ++i) {
            VirtualFile newFile;
            VirtualFile oldFile = oldRoots.get(i);
            if (oldFile.equals(newFile = newRoots.get(i))) continue;
            return rootList + ".\n Nonequality index " + i + ". Classes: old " + oldFile.getClass() + ", new " + newFile.getClass();
        }
        return rootList + ". But all files are equal 0_o";
    }

    protected void addPatchedRoots(@NotNull Collection<? extends VirtualFile> rootsToAdd, @NotNull List<? super VirtualFile> newRoots) {
        if (rootsToAdd == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(4);
        }
        if (newRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(5);
        }
        this.LOG.trace("Added " + rootsToAdd);
        newRoots.addAll(rootsToAdd);
    }

    public static void fireLibraryChanged(@NotNull Project project) {
        ProjectRootManagerEx projectRootManager;
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(6);
        }
        if ((projectRootManager = ProjectRootManagerEx.getInstanceEx((Project)project)) instanceof ProjectRootManagerBridge && ((ProjectRootManagerBridge)projectRootManager).isFiringEvent()) {
            return;
        }
        Runnable writeAction = () -> WriteAction.run(() -> projectRootManager.makeRootsChange(EmptyRunnable.getInstance(), false, true));
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            writeAction.run();
        } else {
            DumbService.getInstance((Project)project).runWhenSmart(writeAction);
        }
    }

    protected void modifyLibraries(@Nullable VirtualFile fileToAdd, boolean removeInvalidFiles) {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (fileToAdd == null && !removeInvalidFiles) {
            return;
        }
        this.LOG.trace("Modifying libraries");
        Collection<Object> rootsToAdd = fileToAdd == null ? Collections.emptyList() : Collections.singleton(fileToAdd);
        this.applyRootsChange(rootsToAdd, false, removeInvalidFiles, null);
    }

    @NotNull
    protected abstract Collection<VirtualFile> collectRoots();

    public static void deleteOldStyleLibrary(@NotNull Project project, @NotNull String libraryName) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(7);
        }
        if (libraryName == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(8);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                PhpAdditionalLibraryManager.deleteLibrary(libraryName, module);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public static void deleteLibrary(@NotNull String libraryName, @NotNull Module module) {
        if (libraryName == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(9);
        }
        if (module == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(10);
        }
        if (PhpAdditionalLibraryManager.findLibraryByName(OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), libraryName) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            LibraryTable.ModifiableModel libraryTableModel = model.getModuleLibraryTable().getModifiableModel();
            Library phpLibrary = PhpAdditionalLibraryManager.findLibraryByName(Arrays.asList(libraryTableModel.getLibraries()), libraryName);
            if (phpLibrary == null) {
                model.dispose();
                return;
            }
            libraryTableModel.removeLibrary(phpLibrary);
            libraryTableModel.commit();
            model.commit();
        });
    }

    @Nullable
    private static Library findLibraryByName(List<? extends Library> libraries, String name) {
        return (Library)ContainerUtil.find(libraries, l -> name.equals(l.getName()));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAdd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/library/PhpAdditionalLibraryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRootsChange";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPatchedRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fireLibraryChanged";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteOldStyleLibrary";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

