/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.ui.ResultMessage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLocalInterpreterComponent
extends PhpInterpreterComponent {
    private static final Logger LOG = Logger.getInstance(PhpLocalInterpreterComponent.class);
    private static final int TIMEOUT = 30000;
    private final DocumentAdapter myPathTextFieldListener;
    private final DocumentAdapter myDebuggerPathTextFieldListener;
    @Nullable
    private transient VirtualFile myPhpBinary;
    @NotNull
    private final Alarm myReloadAlarm;
    private boolean myDisposed;

    protected PhpLocalInterpreterComponent(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull String interpreterName) {
        if (project == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(1);
        }
        if (interpreterName == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(2);
        }
        super(project, data);
        this.myPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent$1", "textChanged"));
            }
        };
        this.myDebuggerPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent$2", "textChanged"));
            }
        };
        this.myPhpBinary = null;
        this.myDisposed = false;
        this.myReloadAlarm = new Alarm();
        this.myReloadAlarm.setActivationComponent((JComponent)this.myMainPanel);
        this.init(interpreterName);
    }

    @Override
    protected void init(@NotNull String interpreterName) {
        if (interpreterName == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(3);
        }
        super.init(interpreterName);
        this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myOptionsComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }
        });
        this.myLastLoadedInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(interpreterName);
        this.myLastLoadedNonPersistedInfo = null;
    }

    @Override
    @NlsSafe
    protected String getInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(4);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(6);
        }
        return interpreter.getHomePath();
    }

    @Override
    @NlsSafe
    protected String getNewFullInterpreterPath() {
        return this.myPathTextField.getText();
    }

    private void scheduleInfoComputation(boolean reload) {
        if (this.myDisposed) {
            return;
        }
        this.myReloadAlarm.cancelAllRequests();
        this.myReloadAlarm.addComponentRequest(() -> {
            this.myPhpBinary = PhpSdkType.getPhpBinary(this.myPathTextField.getText());
            if (this.myPhpBinary != null) {
                String path = this.myPhpBinary.getPresentableUrl();
                if (StringUtil.isNotEmpty((String)path) && !FileUtil.pathsEqual((String)path, (String)this.myPathTextField.getText())) {
                    UIUtil.invokeAndWaitIfNeeded(() -> this.myPathTextField.setText(path));
                }
                this.logFileUpdate(path);
            } else {
                this.logFileUpdate("null");
            }
            if (reload) {
                this.reloadInterpreter(this.myPhpBinary);
            } else {
                this.resetPhpInfo();
            }
        }, 200);
    }

    private void logFileUpdate(@NotNull String path) {
        if (path == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(7);
        }
        LOG.debug("Binary file was updated: " + path + " (by " + this.myPathTextField.getText() + ")");
    }

    @Override
    @Nullable
    protected ProcessOutput executeCommand(@NotNull @Nls String title, @NotNull String command) throws ExecutionException {
        if (title == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(8);
        }
        if (command == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(9);
        }
        if (this.myPhpBinary != null) {
            Ref outputRef = new Ref(null);
            Ref exceptionRef = new Ref(null);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.myPhpBinary.getPath(), command});
                try {
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    ProcessOutput output = indicator == null ? processHandler.runProcess(30000) : processHandler.runProcessWithProgressIndicator(indicator);
                    outputRef.set((Object)output);
                }
                catch (ExecutionException e) {
                    exceptionRef.set((Object)e);
                }
            }, title, true, this.myProject, (JComponent)this.myMainPanel);
            if (!exceptionRef.isNull()) {
                throw (ExecutionException)((Object)exceptionRef.get());
            }
            return (ProcessOutput)outputRef.get();
        }
        return null;
    }

    @NotNull
    public ResultMessage reloadInterpreter(@Nullable VirtualFile phpBinary) {
        if (phpBinary == null) {
            this.myLastLoadedInfo = null;
            this.myLastLoadedNonPersistedInfo = null;
            this.resetPhpInfo();
            String message = PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP executable");
            return new ResultMessage(message, MessageType.ERROR);
        }
        try {
            List<PhpConfigurationOption> options = this.getConfigurationOption();
            Pair<PhpInfo, PhpNonPersistedInfo> wholePhpInfo = PhpInfoUtil.getWholePhpInfo(this.myProject, phpBinary.getPresentableUrl(), this.mySdkAdditionalData, options, this.myMainPanel);
            this.myLastLoadedInfo = (PhpInfo)wholePhpInfo.getFirst();
            this.myLastLoadedNonPersistedInfo = (PhpNonPersistedInfo)wholePhpInfo.getSecond();
            LOG.assertTrue(this.myLastLoadedInfo != null);
            LOG.debug("PHP Debugger was updated: " + this.myLastLoadedInfo.getDebuggers());
            this.resetPhpInfo();
            return new ResultMessage(PhpBundle.message("PhpInterpreterConfigurable.updated.phpinfo", new Object[0]), MessageType.INFO);
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.debug(e.getMessage());
            this.myLastLoadedInfo = null;
            this.myLastLoadedNonPersistedInfo = null;
            this.resetPhpInfo();
            String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("PhpInterpreterConfigurable.can.not.updated.phpinfo", new Object[0]));
            return new ResultMessage(message, MessageType.ERROR);
        }
    }

    @Override
    @NotNull
    protected ResultMessage reloadPhpInfo() {
        ResultMessage resultMessage = this.reloadInterpreter(this.myPhpBinary);
        if (resultMessage == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(10);
        }
        return resultMessage;
    }

    @Override
    protected boolean canReloadPhpInfo() {
        return this.myReloadAlarm.isEmpty() && this.myPhpBinary != null;
    }

    @Override
    @NotNull
    @NlsSafe
    protected String getPresentableInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(13);
        }
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)this.getInterpreterPath(name, data, interpreter)));
        if (string == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public void reset(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(15);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(16);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(17);
        }
        this.myPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        super.reset(name, data, interpreter);
        this.myDebuggerExtensionTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        UIUtil.invokeLaterIfNeeded(() -> this.scheduleInfoComputation(this.myLastLoadedInfo == null || this.myLastLoadedNonPersistedInfo == null));
    }

    @Override
    public void disposeUIResources() {
        this.myPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myReloadAlarm);
        super.disposeUIResources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadPhpInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logFileUpdate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableInterpreterPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

