/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpretersSerializer {
    private static final String ROOT = "root";
    private static final String INTERPRETERS = "interpreters";
    private static final String INTERPRETER = "interpreter";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String HOME_ATTR = "home";

    @NotNull
    public static Element serialize(@NotNull List<PhpInterpreter> interpreters) {
        if (interpreters == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(0);
        }
        Element root = new Element(ROOT);
        if (interpreters.isEmpty()) {
            Element element = root;
            if (element == null) {
                PhpInterpretersSerializer.$$$reportNull$$$0(1);
            }
            return element;
        }
        PhpSdkType sdkType = PhpSdkType.getInstance();
        Element interpretersElement = new Element(INTERPRETERS);
        for (PhpInterpreter interpreter : interpreters) {
            Element element = PhpInterpretersSerializer.saveInterpreter(interpreter);
            sdkType.saveAdditionalData(interpreter.getPhpSdkAdditionalData(), element);
            interpretersElement.addContent(element);
        }
        root.addContent(interpretersElement);
        Element element = root;
        if (element == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(2);
        }
        return element;
    }

    @NotNull
    private static Element saveInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(3);
        }
        Element element = new Element(INTERPRETER);
        element.setAttribute(ID_ATTR, interpreter.getId());
        element.setAttribute(NAME_ATTR, interpreter.getName());
        element.setAttribute(HOME_ATTR, PhpInterpretersSerializer.getSerializedHomePath(interpreter));
        Element element2 = element;
        if (element2 == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(4);
        }
        return element2;
    }

    @NotNull
    private static String getSerializedHomePath(@NotNull PhpInterpreter interpreter) {
        int separator;
        if (interpreter == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(5);
        }
        String path = interpreter.getHomePath();
        if (interpreter.isRemote() && StringUtil.isNotEmpty((String)path) && (separator = StringUtil.indexOf((CharSequence)path, (CharSequence)"://")) > 0) {
            String string = path.substring(0, separator + 3) + "DATA";
            if (string == null) {
                PhpInterpretersSerializer.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)path);
        if (string == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static List<PhpInterpreter> deserialize(@Nullable Project project, @NotNull Element element) {
        Element root;
        if (element == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(8);
        }
        if ((root = element.getChild(INTERPRETERS)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpInterpretersSerializer.$$$reportNull$$$0(9);
            }
            return list;
        }
        List interpretersElements = root.getChildren(INTERPRETER);
        if (interpretersElements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpInterpretersSerializer.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<PhpInterpreter> interpreters = new ArrayList<PhpInterpreter>();
        PhpSdkType sdkType = PhpSdkType.getInstance();
        for (Element interpreterElement : interpretersElements) {
            PhpInterpreter interpreter = PhpInterpretersSerializer.loadInterpreter(interpreterElement);
            interpreter.setIsProjectLevel(project != null);
            PhpSdkAdditionalData data = sdkType.loadPhpAdditionalData(interpreter, interpreterElement, project);
            if (data instanceof RemoteSdkAdditionalData) {
                RemoteSdkAdditionalData remoteData = (RemoteSdkAdditionalData)data;
                interpreter.setHomePath(StringUtil.notNullize((String)remoteData.getSdkId()));
            }
            interpreter.setPhpSdkAdditionalData(data);
            interpreters.add(interpreter);
        }
        ArrayList<PhpInterpreter> arrayList = interpreters;
        if (arrayList == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static PhpInterpreter loadInterpreter(Element element) {
        PhpInterpreter interpreter = new PhpInterpreter();
        String id = element.getAttributeValue(ID_ATTR);
        if (StringUtil.isNotEmpty((String)id)) {
            interpreter.setId(id);
        }
        interpreter.setName(StringUtil.notNullize((String)element.getAttributeValue(NAME_ATTR)));
        interpreter.setHomePath(StringUtil.notNullize((String)element.getAttributeValue(HOME_ATTR)));
        PhpInterpreter phpInterpreter = interpreter;
        if (phpInterpreter == null) {
            PhpInterpretersSerializer.$$$reportNull$$$0(12);
        }
        return phpInterpreter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = INTERPRETERS;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersSerializer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = INTERPRETER;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersSerializer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "saveInterpreter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedHomePath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveInterpreter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSerializedHomePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

