/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCache;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheBase;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpretersPhpInfoCacheImpl
implements PhpInterpretersPhpInfoCache {
    private final Project myProject;
    private final PhpApplicationInterpretersPhpInfoCache myApplicationManager;
    private final PhpProjectInterpretersPhpInfoCache myProjectManager;

    public static PhpInterpretersPhpInfoCacheImpl getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpInterpretersPhpInfoCacheImpl)ServiceManager.getService((Project)targetProject, PhpInterpretersPhpInfoCacheImpl.class);
    }

    public PhpInterpretersPhpInfoCacheImpl(@Nullable Project project) {
        this.myProject = project;
        this.myApplicationManager = (PhpApplicationInterpretersPhpInfoCache)ApplicationManager.getApplication().getService(PhpApplicationInterpretersPhpInfoCache.class);
        this.myProjectManager = project != null && !project.isDefault() ? (PhpProjectInterpretersPhpInfoCache)ServiceManager.getService((Project)project, PhpProjectInterpretersPhpInfoCache.class) : null;
    }

    public void resolveConflicts(@NotNull Map<String, String> oldProjectInterpretersNameToNew) {
        if (oldProjectInterpretersNameToNew == null) {
            PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(0);
        }
        for (Map.Entry<String, String> entry : oldProjectInterpretersNameToNew.entrySet()) {
            String oldName = entry.getKey();
            PhpInfo phpInfo = this.myProjectManager.getPhpInfo(oldName);
            if (phpInfo == null) continue;
            this.myProjectManager.removePhpInfo(oldName);
            this.myProjectManager.setPhpInfo(entry.getValue(), phpInfo);
        }
    }

    @Override
    @NotNull
    public Map<String, PhpInfo> getPhpInfoCache() {
        if (this.myProjectManager == null) {
            Map<String, PhpInfo> map = this.myApplicationManager.getPhpInfoCache();
            if (map == null) {
                PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(1);
            }
            return map;
        }
        THashMap result = new THashMap();
        result.putAll(this.myApplicationManager.getPhpInfoCache());
        result.putAll(this.myProjectManager.getPhpInfoCache());
        THashMap tHashMap = result;
        if (tHashMap == null) {
            PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(2);
        }
        return tHashMap;
    }

    @Override
    public void setPhpInfo(@NotNull String interpreterName, @Nullable PhpInfo phpInfo) {
        PhpInterpreter interpreter;
        if (interpreterName == null) {
            PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(3);
        }
        if (this.myProjectManager != null && (interpreter = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreter(interpreterName)) != null && interpreter.isProjectLevel()) {
            this.myProjectManager.setPhpInfo(interpreterName, phpInfo);
            return;
        }
        this.myApplicationManager.setPhpInfo(interpreterName, phpInfo);
    }

    @Override
    @Nullable
    public PhpInfo getPhpInfo(@Nullable String interpreterName) {
        PhpInfo phpInfo = this.myApplicationManager.getPhpInfo(interpreterName);
        if (phpInfo == null && this.myProjectManager != null) {
            phpInfo = this.myProjectManager.getPhpInfo(interpreterName);
        }
        return phpInfo;
    }

    @Override
    @Nullable
    public PhpInfo updateAnGet(@NotNull Project project, @Nullable String interpreterName, @Nullable JComponent parentComponent) {
        PhpInfo phpInfo;
        if (project == null) {
            PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(4);
        }
        if ((phpInfo = this.myApplicationManager.updateAnGet(project, interpreterName, parentComponent)) == null && this.myProjectManager != null) {
            phpInfo = this.myProjectManager.updateAnGet(project, interpreterName, parentComponent);
        }
        return phpInfo;
    }

    @Override
    @Nullable
    public Pair<PhpInfo, PhpNonPersistedInfo> updateAnGetWholeInfo(@NotNull Project project, @Nullable String interpreterName, @Nullable JComponent parentComponent) {
        Pair<PhpInfo, PhpNonPersistedInfo> phpInfo;
        if (project == null) {
            PhpInterpretersPhpInfoCacheImpl.$$$reportNull$$$0(5);
        }
        if ((phpInfo = this.myApplicationManager.updateAnGetWholeInfo(project, interpreterName, parentComponent)) == null && this.myProjectManager != null) {
            phpInfo = this.myProjectManager.updateAnGetWholeInfo(project, interpreterName, parentComponent);
        }
        return phpInfo;
    }

    @Override
    public void clear() {
        this.myApplicationManager.clear();
        if (this.myProjectManager != null) {
            this.myProjectManager.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldProjectInterpretersNameToNew";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpInfoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflicts";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPhpInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateAnGet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateAnGetWholeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="PhpInterpretersPhpInfoCache", storages={@Storage(value="php.xml")})
    public static class PhpProjectInterpretersPhpInfoCache
    extends PhpInterpretersPhpInfoCacheBase {
        public static PhpProjectInterpretersPhpInfoCache getInstance(@NotNull Project project) {
            if (project == null) {
                PhpProjectInterpretersPhpInfoCache.$$$reportNull$$$0(0);
            }
            return (PhpProjectInterpretersPhpInfoCache)ServiceManager.getService((Project)project, PhpProjectInterpretersPhpInfoCache.class);
        }

        @Override
        protected boolean canUpdateInfo(@NotNull PhpInterpreter interpreter) {
            if (interpreter == null) {
                PhpProjectInterpretersPhpInfoCache.$$$reportNull$$$0(1);
            }
            return interpreter.isProjectLevel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheImpl$PhpProjectInterpretersPhpInfoCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canUpdateInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="PhpInterpretersPhpInfoCache", storages={@Storage(value="php.xml")})
    public static class PhpApplicationInterpretersPhpInfoCache
    extends PhpInterpretersPhpInfoCacheBase {
        public static PhpApplicationInterpretersPhpInfoCache getInstance() {
            return (PhpApplicationInterpretersPhpInfoCache)ApplicationManager.getApplication().getService(PhpApplicationInterpretersPhpInfoCache.class);
        }

        @Override
        protected boolean canUpdateInfo(@NotNull PhpInterpreter interpreter) {
            if (interpreter == null) {
                PhpApplicationInterpretersPhpInfoCache.$$$reportNull$$$0(0);
            }
            return !interpreter.isProjectLevel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheImpl$PhpApplicationInterpretersPhpInfoCache", "canUpdateInfo"));
        }
    }
}

