/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandSettingsBuilder {
    private static final Function<PhpConfigurationOptionData, PhpConfigurationOption> CONFIGURATION_OPTION_ADAPTER = configurationOption -> new PhpConfigurationOption(configurationOption.getName(), configurationOption.getValue());
    @Deprecated
    public static final String INTERPRETER_NOT_FOUND_ERROR = "Interpreter is not specified or invalid.";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final PhpInterpreter myInterpreter;
    private boolean myLoadDebugExtension;
    private boolean myStartDebugger;

    public PhpCommandSettingsBuilder(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(1);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = interpreter;
    }

    public PhpCommandSettingsBuilder(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(2);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
    }

    @NotNull
    public PhpCommandSettingsBuilder loadDebugExtension() {
        this.myLoadDebugExtension = true;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(3);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug(boolean startDebugger) {
        this.myLoadDebugExtension = startDebugger;
        this.myStartDebugger = startDebugger;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(4);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug() {
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this.loadAndStartDebug(true);
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(5);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettings build() throws ExecutionException {
        PhpCommandSettings command;
        if (this.myInterpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        PhpCommandSettings phpCommandSettings = command = this.myInterpreter.isRemote() ? this.createRemoteSettings() : this.createLocalSettings();
        if (this.myLoadDebugExtension && StringUtil.isNotEmpty((String)this.myInterpreter.getDebuggerId())) {
            PhpProjectDebugConfiguration.State configuration;
            String extension = this.myInterpreter.getDebuggerExtension();
            if (StringUtil.isNotEmpty((String)extension)) {
                command.addOption(PhpConfigurationOption.createZendExtensionOption(extension).getText());
            }
            if (this.myStartDebugger && (configuration = PhpProjectDebugConfiguration.getInstance(this.myProject).getState()) != null && configuration.isLocalPassConfigurationOptions()) {
                PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(this.myInterpreter.getDebuggerId());
                String remoteHost = null;
                if (this.myInterpreter.isRemote()) {
                    PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                    if (manager == null) {
                        throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
                    }
                    remoteHost = manager.getRemoteHost(this.myProject, this.myInterpreter.getName(), this.myInterpreter.getPhpSdkAdditionalData());
                }
                remoteHost = StringUtil.notNullize(remoteHost, (String)"127.0.0.1");
                command.addConfigurationOptions(debugExtension.getDebugConfigurationsOptions(this.myProject, remoteHost, this.myInterpreter));
            }
        }
        command.addConfigurationOptions(ContainerUtil.map(this.myInterpreter.getConfigurationOptions(), CONFIGURATION_OPTION_ADAPTER));
        PhpCommandSettings phpCommandSettings2 = command;
        if (phpCommandSettings2 == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(6);
        }
        return phpCommandSettings2;
    }

    @NotNull
    protected PhpCommandSettings createRemoteSettings() throws ExecutionException {
        PhpCommandSettings command;
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager == null) {
            throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
        }
        PhpCommandSettings phpCommandSettings = command = manager.createPhpCommand(this.myProject, this.myInterpreter.getPhpSdkAdditionalData());
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(7);
        }
        return phpCommandSettings;
    }

    @NotNull
    protected PhpCommandSettings createLocalSettings() throws ExecutionException {
        PhpCommandSettings command;
        PhpCommandLinePathProcessor pathProcessor = PhpCommandLinePathProcessor.LOCAL;
        assert (this.myInterpreter != null);
        String path = pathProcessor.process(PhpCommandSettingsBuilder.findPhpBinary(this.myInterpreter.getHomePath()).getPath());
        PhpCommandSettings phpCommandSettings = command = PhpCommandSettingsBuilder.create(path, pathProcessor, null);
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(8);
        }
        return phpCommandSettings;
    }

    @Nullable
    public static String validate(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(9);
        }
        return PhpCommandSettingsBuilder.validate(project, null);
    }

    @Nullable
    public static String validate(@NotNull Project project, @Nullable String interpreterName) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(10);
        }
        try {
            PhpInterpreter interpreter;
            PhpInterpreter phpInterpreter = interpreter = interpreterName == null ? PhpProjectConfigurationFacade.getInstance(project).getInterpreter() : PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
            if (interpreter == null) {
                return interpreterName == null ? PhpCommandSettingsBuilder.getProjectInterpreterNotSpecified() : PhpCommandSettingsBuilder.getInterpreterNotFoundError();
            }
            PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
            String validate = data.validate(project, null);
            if (StringUtil.isNotEmpty((String)validate)) {
                return validate;
            }
            if (!interpreter.isRemote()) {
                PhpCommandSettingsBuilder.findPhpBinary(interpreter.getHomePath());
            }
        }
        catch (ExecutionException e) {
            return e.getMessage();
        }
        return null;
    }

    public static PhpCommandSettings create(@NotNull String pathToBinary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData data) {
        if (pathToBinary == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(11);
        }
        if (pathProcessor == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(12);
        }
        return new PhpCommandSettings(pathToBinary, pathProcessor, data);
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(13);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(14);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, @NotNull PhpInterpreter interpreter, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(15);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(16);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(17);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static VirtualFile findPhpBinary(@Nullable String phpHome) throws ExecutionException {
        VirtualFile binary = PhpRunUtil.findFileOrDirectory(phpHome, false);
        if (binary == null) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP home"));
        }
        if (binary.isDirectory()) {
            String phpExecutableName = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            VirtualFile executable = binary.findChild(phpExecutableName);
            if (executable == null) {
                throw new ExecutionException(PhpBundle.message("validation.0.not.found.at.1", phpExecutableName, binary.getPresentableUrl()));
            }
            if (executable.isDirectory()) {
                throw new ExecutionException(PhpBundle.message("validation.0.is.not.a.directory", executable.getPresentableUrl()));
            }
            VirtualFile virtualFile = executable;
            if (virtualFile == null) {
                PhpCommandSettingsBuilder.$$$reportNull$$$0(18);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = binary;
        if (virtualFile == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(19);
        }
        return virtualFile;
    }

    @Nls
    public static String getInterpreterNotFoundError() {
        return PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("interpreter", new Object[0]));
    }

    @Nls
    public static String getProjectInterpreterNotSpecified() {
        return PhpBundle.message("framework.composer.interpreters.combo.no.default.interpreter.in.project", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBinary";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDebugExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndStartDebug";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalSettings";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhpBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

